/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.jdbc.CallableStatementResultSetHandler;
import com.mockrunner.jdbc.PreparedStatementResultSetHandler;
import com.mockrunner.jdbc.StatementResultSetHandler;
import com.mockrunner.mock.jdbc.MockArray;
import com.mockrunner.mock.jdbc.MockBlob;
import com.mockrunner.mock.jdbc.MockCallableStatement;
import com.mockrunner.mock.jdbc.MockClob;
import com.mockrunner.mock.jdbc.MockDatabaseMetaData;
import com.mockrunner.mock.jdbc.MockNClob;
import com.mockrunner.mock.jdbc.MockPreparedStatement;
import com.mockrunner.mock.jdbc.MockSQLXML;
import com.mockrunner.mock.jdbc.MockSavepoint;
import com.mockrunner.mock.jdbc.MockStatement;
import com.mockrunner.mock.jdbc.MockStruct;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class MockConnection
implements Connection {
    private StatementResultSetHandler statementHandler = new StatementResultSetHandler();
    private PreparedStatementResultSetHandler preparedStatementHandler = new PreparedStatementResultSetHandler();
    private CallableStatementResultSetHandler callableStatementHandler = new CallableStatementResultSetHandler();
    private DatabaseMetaData metaData = new MockDatabaseMetaData();
    private Map savepoints;
    private int savepointCount;
    private boolean closed;
    private boolean autoCommit;
    private boolean readOnly;
    private int holdability;
    private int level;
    private Map typeMap;
    private String catalog;
    private String schema;
    private int numberCommits;
    private int numberRollbacks;
    private Properties clientInfo;
    private int networkTimeout;

    public MockConnection() {
        ((MockDatabaseMetaData)this.metaData).setConnection(this);
        this.closed = false;
        this.autoCommit = false;
        this.readOnly = false;
        this.holdability = 1;
        try {
            this.level = this.metaData.getDefaultTransactionIsolation();
        }
        catch (SQLException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
        this.typeMap = new HashMap();
        this.savepoints = new HashMap();
        this.savepointCount = 0;
        this.catalog = null;
        this.numberCommits = 0;
        this.numberRollbacks = 0;
        this.clientInfo = new Properties();
    }

    public void abort(Executor executor) throws SQLException {
    }

    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.networkTimeout = milliseconds;
    }

    public int getNetworkTimeout() throws SQLException {
        return this.networkTimeout;
    }

    public void setMetaData(DatabaseMetaData metaData) throws SQLException {
        if (metaData != null && metaData instanceof MockDatabaseMetaData) {
            ((MockDatabaseMetaData)metaData).setConnection(this);
        }
        this.metaData = metaData;
    }

    public int getNumberCommits() {
        return this.numberCommits;
    }

    public int getNumberRollbacks() {
        return this.numberRollbacks;
    }

    public Map getSavepointMap() {
        return Collections.unmodifiableMap(this.savepoints);
    }

    public void resetNumberCommits() {
        this.numberCommits = 0;
    }

    public void resetNumberRollbacks() {
        this.numberRollbacks = 0;
    }

    public void resetSavepointMap() {
        this.savepoints.clear();
    }

    public StatementResultSetHandler getStatementResultSetHandler() {
        return this.statementHandler;
    }

    public PreparedStatementResultSetHandler getPreparedStatementResultSetHandler() {
        return this.preparedStatementHandler;
    }

    public CallableStatementResultSetHandler getCallableStatementResultSetHandler() {
        return this.callableStatementHandler;
    }

    public Statement createStatement() throws SQLException {
        MockStatement statement = new MockStatement(this);
        this.getStatementResultSetHandler().addStatement(statement);
        return statement;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        MockStatement statement = new MockStatement(this, resultSetType, resultSetConcurrency);
        this.getStatementResultSetHandler().addStatement(statement);
        return statement;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        MockStatement statement = new MockStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.getStatementResultSetHandler().addStatement(statement);
        return statement;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        MockCallableStatement statement = new MockCallableStatement(this, sql);
        this.getCallableStatementResultSetHandler().addCallableStatement(statement);
        return statement;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        MockCallableStatement statement = new MockCallableStatement((Connection)this, sql, resultSetType, resultSetConcurrency);
        this.getCallableStatementResultSetHandler().addCallableStatement(statement);
        return statement;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        MockCallableStatement statement = new MockCallableStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.getCallableStatementResultSetHandler().addCallableStatement(statement);
        return statement;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        MockPreparedStatement statement = new MockPreparedStatement(this, sql);
        this.getPreparedStatementResultSetHandler().addPreparedStatement(statement);
        return statement;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        MockPreparedStatement statement = new MockPreparedStatement((Connection)this, sql, resultSetType, resultSetConcurrency);
        this.getPreparedStatementResultSetHandler().addPreparedStatement(statement);
        return statement;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        MockPreparedStatement statement = new MockPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.getPreparedStatementResultSetHandler().addPreparedStatement(statement);
        return statement;
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.verifyAutoGeneratedKeysParameter(autoGeneratedKeys);
        MockPreparedStatement statement = new MockPreparedStatement((Connection)this, sql, autoGeneratedKeys == 1);
        this.getPreparedStatementResultSetHandler().addPreparedStatement(statement);
        return statement;
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql, 1);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql, 1);
    }

    public Blob createBlob() throws SQLException {
        return new MockBlob(new byte[0]);
    }

    public Clob createClob() throws SQLException {
        return new MockClob("");
    }

    public NClob createNClob() throws SQLException {
        return new MockNClob("");
    }

    public SQLXML createSQLXML() throws SQLException {
        return new MockSQLXML();
    }

    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        MockArray array = new MockArray(elements);
        array.setBaseTypeName(typeName);
        return array;
    }

    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return new MockStruct(typeName, attributes);
    }

    private void verifyAutoGeneratedKeysParameter(int autoGeneratedKeys) throws SQLException {
        if (1 != autoGeneratedKeys && 2 != autoGeneratedKeys) {
            throw new SQLException("autoGeneratedKeys must be either Statement.RETURN_GENERATED_KEYS or Statement.NO_GENERATED_KEYS");
        }
    }

    public void close() throws SQLException {
        this.closed = true;
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public String getCatalog() throws SQLException {
        return this.catalog;
    }

    public int getHoldability() throws SQLException {
        return this.holdability;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    public int getTransactionIsolation() throws SQLException {
        return this.level;
    }

    public Map getTypeMap() throws SQLException {
        return this.typeMap;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public Properties getClientInfo() throws SQLException {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.clientInfo);
        return properties;
    }

    public String getClientInfo(String name) throws SQLException {
        return this.clientInfo.getProperty(name);
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public boolean isValid(int timeout) throws SQLException {
        return !this.isClosed();
    }

    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
    }

    public void setCatalog(String catalog) throws SQLException {
        this.catalog = catalog;
    }

    public void setHoldability(int holdability) throws SQLException {
        this.holdability = holdability;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.setSavepoint("");
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        MockSavepoint savePoint = new MockSavepoint(name, this.savepointCount);
        this.savepoints.put(new Integer(savePoint.getSavepointId()), savePoint);
        ++this.savepointCount;
        return savePoint;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.level = level;
    }

    public void setTypeMap(Map typeMap) throws SQLException {
        this.typeMap = typeMap;
    }

    public void setClientInfo(Properties properties) {
        this.clientInfo.clear();
        this.clientInfo.putAll((Map<?, ?>)properties);
    }

    public void setClientInfo(String name, String value) {
        this.clientInfo.setProperty(name, value);
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        MockSavepoint currentSavepoint = (MockSavepoint)this.savepoints.get(new Integer(savepoint.getSavepointId()));
        if (currentSavepoint.isReleased()) {
            throw new SQLException("Savepoint with id " + currentSavepoint.getSavepointId() + " and name " + currentSavepoint.getSavepointName() + " is released");
        }
        currentSavepoint.setReleased(true);
    }

    public void commit() throws SQLException {
        ++this.numberCommits;
    }

    public void rollback() throws SQLException {
        ++this.numberRollbacks;
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        MockSavepoint currentSavepoint = (MockSavepoint)this.savepoints.get(new Integer(savepoint.getSavepointId()));
        if (currentSavepoint.isReleased()) {
            throw new SQLException("Savepoint with id " + currentSavepoint.getSavepointId() + " and name " + currentSavepoint.getSavepointName() + " is released");
        }
        currentSavepoint.setRolledBack(true);
        ++this.numberRollbacks;
    }

    public void clearWarnings() throws SQLException {
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        return false;
    }

    public Object unwrap(Class iface) throws SQLException {
        throw new SQLException("No object found for " + iface);
    }
}

