/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.jdbc;

import com.mockrunner.jdbc.ArrayResultSetFactory;
import com.mockrunner.jdbc.StringValuesTable;
import com.mockrunner.mock.jdbc.MockResultSet;
import java.util.Arrays;
import junit.framework.TestCase;

public class ArrayResultSetFactoryTest
extends TestCase {
    private ArrayResultSetFactory arrayResultSetFactory;
    private StringValuesTable stringTable;
    private String[] columnNames;
    private String[][] stringMatrix;

    public void setUp() throws Exception {
        super.setUp();
        this.columnNames = new String[]{"id", "name", "address"};
        this.stringMatrix = new String[][]{{"1", "moe", "123 main"}, {"2", "larry", "123 main"}, {"3", "curly", "123 main"}};
        this.stringTable = new StringValuesTable("table", this.columnNames, this.stringMatrix);
        this.arrayResultSetFactory = new ArrayResultSetFactory(this.columnNames, this.stringMatrix);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.arrayResultSetFactory = null;
    }

    public void testConstructors() throws Exception {
        try {
            this.arrayResultSetFactory = new ArrayResultSetFactory((StringValuesTable)null);
            ArrayResultSetFactoryTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.arrayResultSetFactory = new ArrayResultSetFactory((String[][])null);
            ArrayResultSetFactoryTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.arrayResultSetFactory = new ArrayResultSetFactory(null, null);
            ArrayResultSetFactoryTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.arrayResultSetFactory = new ArrayResultSetFactory(this.columnNames, null);
            ArrayResultSetFactoryTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.arrayResultSetFactory = new ArrayResultSetFactory(new String[]{"", "", null}, this.stringMatrix);
            ArrayResultSetFactoryTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.arrayResultSetFactory = new ArrayResultSetFactory(this.columnNames, new String[][]{null, {"", "", ""}});
            ArrayResultSetFactoryTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.arrayResultSetFactory = new ArrayResultSetFactory(this.columnNames, new String[][]{{"", null, ""}});
            ArrayResultSetFactoryTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.arrayResultSetFactory = new ArrayResultSetFactory(this.columnNames, new String[][]{{"", ""}, {"", "", ""}});
            ArrayResultSetFactoryTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.arrayResultSetFactory = new ArrayResultSetFactory(this.columnNames, new String[][]{{"", "", ""}, {"", ""}});
            ArrayResultSetFactoryTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.arrayResultSetFactory = new ArrayResultSetFactory(this.stringTable);
        this.arrayResultSetFactory = new ArrayResultSetFactory(this.stringMatrix);
        this.arrayResultSetFactory = new ArrayResultSetFactory(this.columnNames, this.stringMatrix);
    }

    public void testCreate() throws Exception {
        int ii;
        MockResultSet mockResultSet = null;
        try {
            mockResultSet = this.arrayResultSetFactory.create(null);
            ArrayResultSetFactoryTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        mockResultSet = this.arrayResultSetFactory.create("");
        ArrayResultSetFactoryTest.assertEquals((int)this.columnNames.length, (int)mockResultSet.getColumnCount());
        for (ii = 0; ii < this.columnNames.length; ++ii) {
            ArrayResultSetFactoryTest.assertNotNull((Object)mockResultSet.getColumn(this.columnNames[ii]));
        }
        for (ii = 0; ii < this.stringMatrix.length; ++ii) {
            ArrayResultSetFactoryTest.assertEquals(Arrays.asList(this.stringMatrix[ii]), (Object)mockResultSet.getRow(ii + 1));
        }
    }
}

