/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.jdbc;

import com.mockrunner.mock.jdbc.JDBCMockObjectFactory;
import com.mockrunner.mock.jdbc.MockConnection;
import com.mockrunner.mock.jdbc.MockDataSource;
import com.mockrunner.mock.jdbc.MockDriver;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import junit.framework.TestCase;

public class JDBCMockObjectFactoryTest
extends TestCase {
    public void testCreate() throws Exception {
        JDBCMockObjectFactory factory = new JDBCMockObjectFactory();
        JDBCMockObjectFactoryTest.assertTrue((factory.getMockDriver().connect("", null) == factory.getMockDataSource().getConnection() ? 1 : 0) != 0);
        JDBCMockObjectFactoryTest.assertNotNull((Object)DriverManager.getConnection("test"));
        JDBCMockObjectFactoryTest.assertTrue((factory.getMockDriver().connect("", null) == DriverManager.getConnection("test") ? 1 : 0) != 0);
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        drivers.nextElement();
        JDBCMockObjectFactoryTest.assertFalse((boolean)drivers.hasMoreElements());
    }

    public void testRestoreDivers() throws Exception {
        DriverManager.registerDriver(new TestDriver());
        DriverManager.registerDriver(new TestDriver());
        ArrayList<Driver> oldDrivers = new ArrayList<Driver>();
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            oldDrivers.add(drivers.nextElement());
        }
        JDBCMockObjectFactory factory = new JDBCMockObjectFactory();
        new JDBCMockObjectFactory();
        new JDBCMockObjectFactory();
        drivers = DriverManager.getDrivers();
        JDBCMockObjectFactoryTest.assertTrue((boolean)(drivers.nextElement() instanceof MockDriver));
        JDBCMockObjectFactoryTest.assertFalse((boolean)drivers.hasMoreElements());
        factory.restoreDrivers();
        drivers = DriverManager.getDrivers();
        int numberDrivers = 0;
        while (drivers.hasMoreElements()) {
            ++numberDrivers;
            JDBCMockObjectFactoryTest.assertTrue((boolean)oldDrivers.contains(drivers.nextElement()));
        }
        factory.restoreDrivers();
        factory.restoreDrivers();
        factory.restoreDrivers();
        int newNumberDrivers = 0;
        drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            ++newNumberDrivers;
            JDBCMockObjectFactoryTest.assertTrue((boolean)oldDrivers.contains(drivers.nextElement()));
        }
        JDBCMockObjectFactoryTest.assertTrue((numberDrivers == newNumberDrivers ? 1 : 0) != 0);
        factory.registerMockDriver();
        drivers = DriverManager.getDrivers();
        numberDrivers = 0;
        while (drivers.hasMoreElements()) {
            ++numberDrivers;
            JDBCMockObjectFactoryTest.assertTrue((boolean)(drivers.nextElement() instanceof MockDriver));
        }
        JDBCMockObjectFactoryTest.assertTrue((numberDrivers == 1 ? 1 : 0) != 0);
        factory.registerMockDriver();
        factory.registerMockDriver();
        factory.restoreDrivers();
        factory.restoreDrivers();
        drivers = DriverManager.getDrivers();
        numberDrivers = 0;
        while (drivers.hasMoreElements()) {
            ++numberDrivers;
            JDBCMockObjectFactoryTest.assertTrue((boolean)oldDrivers.contains(drivers.nextElement()));
        }
        JDBCMockObjectFactoryTest.assertTrue((numberDrivers == newNumberDrivers ? 1 : 0) != 0);
    }

    public void testOverrideCreate() {
        TestJDBCMockObjectFactory factory = new TestJDBCMockObjectFactory();
        JDBCMockObjectFactoryTest.assertNotSame(factory.getMockConnection().getClass(), MockConnection.class);
        JDBCMockObjectFactoryTest.assertNotSame(factory.getMockDataSource().getClass(), MockDataSource.class);
        JDBCMockObjectFactoryTest.assertNotSame(factory.getMockDriver().getClass(), MockDriver.class);
    }

    public static class TestJDBCMockObjectFactory
    extends JDBCMockObjectFactory {
        public MockConnection createMockConnection() {
            return new MockConnection(){};
        }

        public MockDataSource createMockDataSource() {
            return new MockDataSource(){};
        }

        public MockDriver createMockDriver() {
            return new MockDriver(){};
        }
    }

    public static class TestDriver
    implements Driver {
        public boolean acceptsURL(String url) throws SQLException {
            return false;
        }

        public Connection connect(String url, Properties info) throws SQLException {
            return null;
        }

        public int getMajorVersion() {
            return 0;
        }

        public int getMinorVersion() {
            return 0;
        }

        public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
            return null;
        }

        public boolean jdbcCompliant() {
            return false;
        }

        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return null;
        }
    }
}

