/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.jdbc;

import com.mockrunner.base.VerifyFailedException;
import com.mockrunner.jdbc.JDBCTestModule;
import com.mockrunner.jdbc.ParameterSets;
import com.mockrunner.mock.jdbc.JDBCMockObjectFactory;
import com.mockrunner.mock.jdbc.MockBlob;
import com.mockrunner.mock.jdbc.MockCallableStatement;
import com.mockrunner.mock.jdbc.MockClob;
import com.mockrunner.mock.jdbc.MockPreparedStatement;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.mock.jdbc.MockSavepoint;
import com.mockrunner.mock.jdbc.MockStatement;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public class JDBCTestModuleTest
extends TestCase {
    private JDBCMockObjectFactory mockfactory;
    private JDBCTestModule module;

    protected void setUp() throws Exception {
        super.setUp();
        this.mockfactory = new JDBCMockObjectFactory();
        this.module = new JDBCTestModule(this.mockfactory);
    }

    private void prepareCallableStatements() throws Exception {
        this.mockfactory.getMockConnection().prepareCall("{call getData(?, ?, ?, ?)}");
        this.mockfactory.getMockConnection().prepareCall("{call setData(?, ?, ?, ?)}");
    }

    private void preparePreparedStatements() throws Exception {
        this.mockfactory.getMockConnection().prepareStatement("INSERT INTO TEST (COL1, COL2) VALUES(?, ?)");
        this.mockfactory.getMockConnection().prepareStatement("insert into test (col1, col2, col3) values(?, ?, ?)");
        this.mockfactory.getMockConnection().prepareStatement("update mytable set test = test + ? where id = ?", 1004, 1008, 1);
    }

    private void prepareStatements() throws Exception {
        this.mockfactory.getMockConnection().createStatement();
        this.mockfactory.getMockConnection().createStatement(1004, 1008);
    }

    public void testGetStatements() throws Exception {
        List statements = this.module.getStatements();
        JDBCTestModuleTest.assertNotNull((Object)statements);
        JDBCTestModuleTest.assertEquals((int)0, (int)statements.size());
        JDBCTestModuleTest.assertNull((Object)this.module.getStatement(1));
        this.module.verifyNumberStatements(0);
        this.prepareStatements();
        statements = this.module.getStatements();
        JDBCTestModuleTest.assertNotNull((Object)statements);
        JDBCTestModuleTest.assertEquals((int)2, (int)statements.size());
        JDBCTestModuleTest.assertNotNull((Object)this.module.getStatement(0));
        JDBCTestModuleTest.assertNotNull((Object)this.module.getStatement(1));
        this.module.verifyNumberStatements(2);
    }

    public void testGetPreparedStatementsByIndex() throws Exception {
        List statements = this.module.getPreparedStatements();
        JDBCTestModuleTest.assertNotNull((Object)statements);
        JDBCTestModuleTest.assertEquals((int)0, (int)statements.size());
        JDBCTestModuleTest.assertNull((Object)this.module.getPreparedStatement(1));
        this.module.verifyNumberPreparedStatements(0);
        this.preparePreparedStatements();
        statements = this.module.getPreparedStatements();
        JDBCTestModuleTest.assertNotNull((Object)statements);
        JDBCTestModuleTest.assertEquals((int)3, (int)statements.size());
        this.module.verifyNumberPreparedStatements(3);
    }

    public void testGetPreparedStatementsBySQL() throws Exception {
        this.preparePreparedStatements();
        List statements = this.module.getPreparedStatements("insert");
        JDBCTestModuleTest.assertNotNull((Object)statements);
        JDBCTestModuleTest.assertEquals((int)2, (int)statements.size());
        MockPreparedStatement statement = this.module.getPreparedStatement("insert");
        JDBCTestModuleTest.assertEquals((String)"INSERT INTO TEST (COL1, COL2) VALUES(?, ?)", (String)statement.getSQL());
        this.module.verifyNumberPreparedStatements(1, "update");
        this.module.verifyNumberPreparedStatements(1, "UPDATE");
        this.module.verifyNumberPreparedStatements(2, "insert");
        this.module.verifyNumberPreparedStatements(3);
        this.module.verifyPreparedStatementPresent("update");
        this.module.verifyPreparedStatementNotPresent("select");
        this.module.setCaseSensitive(true);
        statements = this.module.getPreparedStatements("insert");
        JDBCTestModuleTest.assertNotNull((Object)statements);
        JDBCTestModuleTest.assertEquals((int)1, (int)statements.size());
        statement = this.module.getPreparedStatement("insert");
        JDBCTestModuleTest.assertEquals((String)"insert into test (col1, col2, col3) values(?, ?, ?)", (String)statement.getSQL());
        this.module.verifyNumberPreparedStatements(1, "update");
        this.module.verifyNumberPreparedStatements(0, "UPDATE");
        this.module.verifyNumberPreparedStatements(1, "insert");
        this.module.verifyNumberPreparedStatements(1, "INSERT");
        this.module.verifyNumberPreparedStatements(3);
        this.module.setExactMatch(true);
        statements = this.module.getPreparedStatements("insert");
        JDBCTestModuleTest.assertNotNull((Object)statements);
        JDBCTestModuleTest.assertEquals((int)0, (int)statements.size());
        this.module.verifyNumberPreparedStatements(0, "update");
        this.module.verifyNumberPreparedStatements(0, "UPDATE");
        this.module.verifyNumberPreparedStatements(0, "insert");
        this.module.verifyNumberPreparedStatements(0, "INSERT");
        this.module.verifyPreparedStatementNotPresent("update");
        this.module.verifyPreparedStatementPresent("insert into test (col1, col2, col3) values(?, ?, ?)");
    }

    public void testGetPreparedStatementsBySQLRegEx() throws Exception {
        this.module.setUseRegularExpressions(true);
        this.preparePreparedStatements();
        List statements = this.module.getPreparedStatements("insert");
        JDBCTestModuleTest.assertNotNull((Object)statements);
        JDBCTestModuleTest.assertEquals((int)0, (int)statements.size());
        statements = this.module.getPreparedStatements("insert into.*");
        JDBCTestModuleTest.assertEquals((int)2, (int)statements.size());
        this.module.verifyNumberPreparedStatements(0, "update");
        this.module.verifyNumberPreparedStatements(2, "insert (.*) test.*");
        this.module.verifyNumberPreparedStatements(2, "insert (.*) TEST.*");
        this.module.setCaseSensitive(true);
        this.module.verifyNumberPreparedStatements(0, "insert (.*) TEST.*");
    }

    public void testGetPreparedStatementObjects() throws Exception {
        this.preparePreparedStatements();
        MockPreparedStatement statement = this.module.getPreparedStatement("update");
        statement.setInt(1, 3);
        statement.setLong(2, 10000L);
        statement.setNull(3, 1);
        JDBCTestModuleTest.assertEquals((Object)new Integer(3), (Object)statement.getParameter(1));
        JDBCTestModuleTest.assertEquals((Object)new Long(10000L), (Object)statement.getParameter(2));
        JDBCTestModuleTest.assertNull((Object)statement.getParameter(3));
        JDBCTestModuleTest.assertTrue((boolean)statement.getParameterMap().containsKey(new Integer(3)));
        this.module.verifyPreparedStatementParameterPresent(statement, 1);
        this.module.verifyPreparedStatementParameterPresent("update", 3);
        this.module.verifyPreparedStatementParameterNotPresent("update", 4);
        this.module.verifyPreparedStatementParameterNotPresent(0, 1);
        this.module.verifyPreparedStatementParameter(statement, 1, (Object)new Integer(3));
        this.module.verifyPreparedStatementParameter(2, 2, (Object)new Long(10000L));
        this.module.verifyPreparedStatementParameter(statement, 3, null);
        try {
            this.module.verifyPreparedStatementParameter(2, 2, null);
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifyPreparedStatementParameter(statement, 1, null);
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException verifyFailedException) {
            // empty catch block
        }
        statement = this.module.getPreparedStatement("INSERT INTO TEST (COL1, COL2) VALUES(?, ?)");
        statement.setString(1, "test1");
        statement.setString(2, "test2");
        statement.setBytes(3, new byte[]{1, 2, 3});
        statement.setBytes(4, new byte[0]);
        this.module.verifyPreparedStatementParameterPresent(statement, 2);
        this.module.verifyPreparedStatementParameterPresent(statement, 3);
        this.module.verifyPreparedStatementParameterPresent(statement, 4);
        this.module.verifyPreparedStatementParameterNotPresent(statement, 5);
        this.module.verifyPreparedStatementParameter(0, 3, (Object)new byte[]{1, 2, 3});
        this.module.verifyPreparedStatementParameter(0, 4, (Object)new byte[0]);
    }

    public void testGetCallableStatementsByIndex() throws Exception {
        this.module.verifyNumberCallableStatements(0);
        this.prepareCallableStatements();
        this.module.verifyNumberCallableStatements(2);
        List statements = this.module.getCallableStatements();
        JDBCTestModuleTest.assertEquals((String)"{call getData(?, ?, ?, ?)}", (String)((MockCallableStatement)statements.get(0)).getSQL());
        JDBCTestModuleTest.assertEquals((String)"{call setData(?, ?, ?, ?)}", (String)((MockCallableStatement)statements.get(1)).getSQL());
    }

    public void testGetCallableStatementsBySQL() throws Exception {
        this.prepareCallableStatements();
        List statements = this.module.getCallableStatements("call");
        JDBCTestModuleTest.assertTrue((statements.size() == 2 ? 1 : 0) != 0);
        MockCallableStatement statement = this.module.getCallableStatement("CALL");
        JDBCTestModuleTest.assertEquals((String)"{call getData(?, ?, ?, ?)}", (String)statement.getSQL());
        this.module.setCaseSensitive(true);
        statement = this.module.getCallableStatement("CALL");
        JDBCTestModuleTest.assertNull((Object)statement);
        this.module.setCaseSensitive(false);
        this.module.setExactMatch(true);
        statement = this.module.getCallableStatement("CALL");
        JDBCTestModuleTest.assertNull((Object)statement);
        statements = this.module.getCallableStatements("{call setData(?, ?, ?, ?)}");
        JDBCTestModuleTest.assertTrue((statements.size() == 1 ? 1 : 0) != 0);
        this.module.setExactMatch(false);
        this.module.verifyNumberCallableStatements(1, "call getData");
        this.module.verifyNumberCallableStatements(2, "call");
        this.module.verifyCallableStatementPresent("call setData");
        this.module.verifyCallableStatementNotPresent("call setXYZ");
    }

    public void testGetCallableStatementsBySQLRegEx() throws Exception {
        this.module.setUseRegularExpressions(true);
        this.prepareCallableStatements();
        List statements = this.module.getCallableStatements("call");
        JDBCTestModuleTest.assertTrue((statements.size() == 0 ? 1 : 0) != 0);
        MockCallableStatement statement = this.module.getCallableStatement(".*CALL.*");
        JDBCTestModuleTest.assertEquals((String)"{call getData(?, ?, ?, ?)}", (String)statement.getSQL());
        this.module.verifyCallableStatementNotPresent("call setData");
        this.module.verifyCallableStatementPresent("{call setData.*}");
    }

    public void testGetCallableStatementObjects() throws Exception {
        this.prepareCallableStatements();
        MockCallableStatement statement = this.module.getCallableStatement("{call setData(?, ?, ?, ?)}");
        statement.setInt("xyz", 1);
        statement.setString("3", null);
        statement.setString(1, "xyz");
        Map namedParameter = statement.getNamedParameterMap();
        Map indexedParameter = statement.getIndexedParameterMap();
        JDBCTestModuleTest.assertTrue((namedParameter.size() == 2 ? 1 : 0) != 0);
        JDBCTestModuleTest.assertEquals((Object)new Integer(1), namedParameter.get("xyz"));
        JDBCTestModuleTest.assertNull(namedParameter.get("3"));
        JDBCTestModuleTest.assertTrue((indexedParameter.size() == 1 ? 1 : 0) != 0);
        JDBCTestModuleTest.assertEquals((Object)"xyz", indexedParameter.get(new Integer(1)));
        this.module.verifyCallableStatementParameterPresent(1, 1);
        try {
            this.module.verifyCallableStatementParameterNotPresent((CallableStatement)statement, "3");
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        this.module.verifyCallableStatementParameterNotPresent(1, 2);
        this.module.verifyCallableStatementParameterPresent((CallableStatement)statement, "3");
        this.module.verifyCallableStatementParameterNotPresent((CallableStatement)statement, "31");
        this.module.verifyCallableStatementParameter("{call setData(?, ?, ?, ?)}", "xyz", (Object)new Integer(1));
        this.module.verifyCallableStatementParameter(1, 1, (Object)"xyz");
        this.module.verifyCallableStatementParameter(1, "3", null);
        try {
            this.module.verifyCallableStatementParameter("{call setData(?, ?, ?, ?)}", "xyz", null);
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifyCallableStatementParameter(1, 1, null);
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifyCallableStatementParameter(1, 1, (Object)"zzz");
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifyCallableStatementParameter(1, 5, null);
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        statement.setBytes(1, new byte[]{1});
        statement.setBlob(2, (Blob)new MockBlob(new byte[]{3, 4}));
        statement.setClob(3, (Clob)new MockClob("test"));
        this.module.verifyCallableStatementParameter(1, 1, (Object)new byte[]{1});
        this.module.verifyCallableStatementParameter((CallableStatement)statement, 2, (Object)new MockBlob(new byte[]{3, 4}));
        this.module.verifyCallableStatementParameter(1, 3, (Object)new MockClob("test"));
        try {
            this.module.verifyCallableStatementParameter(1, 1, (Object)new byte[]{2});
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
    }

    public void testVerifyCallableStatementOutParameterRegistered() throws Exception {
        this.prepareCallableStatements();
        MockCallableStatement statement = this.module.getCallableStatement("{call getData(?, ?, ?, ?)}");
        statement.registerOutParameter(1, 3);
        statement.registerOutParameter("test", 2004);
        statement.registerOutParameter("xyz", -2);
        this.module.verifyCallableStatementOutParameterRegistered((CallableStatement)statement, 1);
        this.module.verifyCallableStatementOutParameterRegistered((CallableStatement)statement, "test");
        this.module.verifyCallableStatementOutParameterRegistered((CallableStatement)statement, "xyz");
        try {
            this.module.verifyCallableStatementOutParameterRegistered("{call setData(?, ?, ?, ?)}", "xyz");
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifyCallableStatementOutParameterRegistered(1, "test");
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException verifyFailedException) {
            // empty catch block
        }
        this.module.verifyCallableStatementOutParameterRegistered(0, "test");
    }

    public void testGetExecutedSQLStatements() throws Exception {
        this.prepareStatements();
        this.preparePreparedStatements();
        this.prepareCallableStatements();
        MockStatement statement = this.module.getStatement(0);
        statement.execute("select");
        statement.execute("UPDATE");
        MockPreparedStatement preparedStatement = this.module.getPreparedStatement("insert");
        preparedStatement.execute();
        MockCallableStatement callableStatement = this.module.getCallableStatement("call");
        callableStatement.executeUpdate();
        List sqlStatements = this.module.getExecutedSQLStatements();
        JDBCTestModuleTest.assertTrue((sqlStatements.size() == 4 ? 1 : 0) != 0);
        JDBCTestModuleTest.assertTrue((boolean)sqlStatements.contains("select"));
        JDBCTestModuleTest.assertTrue((boolean)sqlStatements.contains("UPDATE"));
        JDBCTestModuleTest.assertTrue((boolean)sqlStatements.contains("INSERT INTO TEST (COL1, COL2) VALUES(?, ?)"));
        JDBCTestModuleTest.assertTrue((boolean)sqlStatements.contains("{call getData(?, ?, ?, ?)}"));
        this.module.verifySQLStatementExecuted("select");
        this.module.verifySQLStatementExecuted("update");
        this.module.verifySQLStatementExecuted("INSERT");
        this.module.verifySQLStatementExecuted("{call");
        this.module.verifySQLStatementNotExecuted("{call}");
        this.module.setCaseSensitive(true);
        this.module.verifySQLStatementExecuted("UPDATE");
        this.module.verifySQLStatementNotExecuted("update");
        this.module.setExactMatch(true);
        this.module.verifySQLStatementExecuted("{call getData(?, ?, ?, ?)}");
        this.module.verifySQLStatementNotExecuted("call");
        this.module.setCaseSensitive(false);
        this.module.verifySQLStatementExecuted("{CALL getData(?, ?, ?, ?)}");
    }

    public void testGetExecutedSQLStatementsRegEx() throws Exception {
        this.module.setUseRegularExpressions(true);
        this.prepareStatements();
        this.preparePreparedStatements();
        this.prepareCallableStatements();
        MockStatement statement = this.module.getStatement(0);
        statement.execute("select");
        statement.execute("UPDATE");
        MockPreparedStatement preparedStatement = this.module.getPreparedStatement("insert.*");
        preparedStatement.execute();
        MockCallableStatement callableStatement = this.module.getCallableStatement("{call.*");
        callableStatement.executeUpdate();
        this.module.verifySQLStatementExecuted("select");
        this.module.verifySQLStatementExecuted("update.*");
        this.module.verifySQLStatementExecuted("INSERT into .*");
        this.module.verifySQLStatementExecuted("{call.*");
        this.module.verifySQLStatementNotExecuted("{call}");
        this.module.setCaseSensitive(true);
        this.module.verifySQLStatementExecuted("UPDATE.*");
        this.module.verifySQLStatementNotExecuted("update");
        this.module.setExactMatch(true);
        this.module.verifySQLStatementNotExecuted("UPDATE.*");
        this.module.verifySQLStatementExecuted("UPDATE");
    }

    public void testGetReturnedResultSets() throws Exception {
        this.prepareStatements();
        this.preparePreparedStatements();
        this.prepareCallableStatements();
        MockResultSet resultSet1 = this.module.getStatementResultSetHandler().createResultSet("1");
        MockResultSet resultSet2 = this.module.getStatementResultSetHandler().createResultSet("2");
        MockResultSet resultSet3 = this.module.getStatementResultSetHandler().createResultSet("3");
        MockResultSet resultSet4 = this.module.getStatementResultSetHandler().createResultSet("4");
        MockResultSet resultSet5 = this.module.getStatementResultSetHandler().createResultSet("5");
        MockResultSet resultSet6 = this.module.getStatementResultSetHandler().createResultSet("6");
        MockResultSet resultSet7 = this.module.getStatementResultSetHandler().createResultSet("7");
        this.module.getStatementResultSetHandler().prepareGlobalResultSet(resultSet1);
        this.module.getStatementResultSetHandler().prepareResultSet("select id", resultSet2);
        this.module.getStatementResultSetHandler().prepareResultSets("select xyz", new MockResultSet[]{resultSet3, resultSet5});
        this.module.getPreparedStatementResultSetHandler().prepareResultSet("select name", resultSet4, new String[]{"test"});
        this.module.getCallableStatementResultSetHandler().prepareResultSet("call set", resultSet5);
        this.module.getCallableStatementResultSetHandler().prepareResultSets("call set", new MockResultSet[]{resultSet6, resultSet7, resultSet1}, new String[]{"xyz"});
        MockStatement statement = this.module.getStatement(0);
        statement.executeQuery("select name");
        statement.executeQuery("select id");
        statement.executeQuery("select xyz");
        List list = this.module.getReturnedResultSets();
        JDBCTestModuleTest.assertEquals((int)3, (int)list.size());
        JDBCTestModuleTest.assertEquals((String)"1", (String)((MockResultSet)list.get(0)).getId());
        JDBCTestModuleTest.assertEquals((String)"2", (String)((MockResultSet)list.get(1)).getId());
        JDBCTestModuleTest.assertEquals((String)"3", (String)((MockResultSet[])list.get(2))[0].getId());
        JDBCTestModuleTest.assertEquals((String)"5", (String)((MockResultSet[])list.get(2))[1].getId());
        MockPreparedStatement preparedStatement = (MockPreparedStatement)this.mockfactory.getMockConnection().prepareStatement("SELECT NAME");
        preparedStatement.setString(1, "test");
        preparedStatement.executeQuery();
        list = this.module.getReturnedResultSets();
        JDBCTestModuleTest.assertEquals((int)4, (int)list.size());
        JDBCTestModuleTest.assertEquals((String)"4", (String)((MockResultSet)list.get(3)).getId());
        MockCallableStatement callableStatement = this.module.getCallableStatement("call set");
        callableStatement.executeQuery();
        list = this.module.getReturnedResultSets();
        JDBCTestModuleTest.assertEquals((int)5, (int)list.size());
        JDBCTestModuleTest.assertEquals((String)"5", (String)((MockResultSet)list.get(4)).getId());
        callableStatement.setString(1, "xyz");
        callableStatement.executeQuery();
        list = this.module.getReturnedResultSets();
        JDBCTestModuleTest.assertEquals((int)6, (int)list.size());
        JDBCTestModuleTest.assertEquals((String)"6", (String)((MockResultSet[])list.get(5))[0].getId());
        JDBCTestModuleTest.assertEquals((String)"7", (String)((MockResultSet[])list.get(5))[1].getId());
        JDBCTestModuleTest.assertEquals((String)"1", (String)((MockResultSet[])list.get(5))[2].getId());
        list = this.module.getReturnedResultSets("1");
        JDBCTestModuleTest.assertEquals((int)2, (int)list.size());
        MockResultSet returned1 = (MockResultSet)list.get(0);
        MockResultSet returned2 = (MockResultSet)list.get(1);
        JDBCTestModuleTest.assertEquals((String)"1", (String)returned1.getId());
        JDBCTestModuleTest.assertEquals((String)"1", (String)returned2.getId());
        JDBCTestModuleTest.assertNotSame((Object)returned1, (Object)returned2);
        JDBCTestModuleTest.assertNotSame((Object)returned1, (Object)resultSet1);
        MockResultSet returned = this.module.getReturnedResultSet("1");
        JDBCTestModuleTest.assertEquals((String)"1", (String)returned.getId());
        JDBCTestModuleTest.assertSame((Object)returned1, (Object)returned);
    }

    public void testReturnedResultSetsClosed() throws Exception {
        this.prepareStatements();
        this.preparePreparedStatements();
        this.prepareCallableStatements();
        MockResultSet resultSet1 = this.module.getStatementResultSetHandler().createResultSet("1");
        MockResultSet resultSet2 = this.module.getStatementResultSetHandler().createResultSet("2");
        MockResultSet resultSet3 = this.module.getStatementResultSetHandler().createResultSet("3");
        MockResultSet resultSet4 = this.module.getStatementResultSetHandler().createResultSet("4");
        MockResultSet resultSet5 = this.module.getStatementResultSetHandler().createResultSet("5");
        this.module.getStatementResultSetHandler().prepareGlobalResultSet(resultSet1);
        this.module.getStatementResultSetHandler().prepareResultSet("select id", resultSet2);
        this.module.getStatementResultSetHandler().prepareResultSet("select xyz", resultSet3);
        this.module.getPreparedStatementResultSetHandler().prepareResultSet("select name", resultSet4, new String[]{"test"});
        this.module.getCallableStatementResultSetHandler().prepareResultSet("call set", resultSet5, new String[]{"xyz"});
        MockStatement statement = this.module.getStatement(0);
        statement.executeQuery("select name");
        statement.executeQuery("select id");
        List list = this.module.getReturnedResultSets();
        JDBCTestModuleTest.assertEquals((int)2, (int)list.size());
        JDBCTestModuleTest.assertEquals((String)"1", (String)((MockResultSet)list.get(0)).getId());
        JDBCTestModuleTest.assertEquals((String)"2", (String)((MockResultSet)list.get(1)).getId());
        MockPreparedStatement preparedStatement = this.module.getPreparedStatement("insert");
        preparedStatement.execute();
        list = this.module.getReturnedResultSets();
        JDBCTestModuleTest.assertEquals((int)2, (int)list.size());
        JDBCTestModuleTest.assertEquals((String)"1", (String)((MockResultSet)list.get(0)).getId());
        JDBCTestModuleTest.assertEquals((String)"2", (String)((MockResultSet)list.get(1)).getId());
        preparedStatement = (MockPreparedStatement)this.mockfactory.getMockConnection().prepareStatement("SELECT NAME");
        preparedStatement.setString(1, "test");
        preparedStatement.executeQuery();
        list = this.module.getReturnedResultSets();
        JDBCTestModuleTest.assertEquals((int)3, (int)list.size());
        JDBCTestModuleTest.assertEquals((String)"1", (String)((MockResultSet)list.get(0)).getId());
        JDBCTestModuleTest.assertEquals((String)"2", (String)((MockResultSet)list.get(1)).getId());
        JDBCTestModuleTest.assertEquals((String)"4", (String)((MockResultSet)list.get(2)).getId());
        MockCallableStatement callableStatement = this.module.getCallableStatement("call set");
        callableStatement.setString(1, "test");
        callableStatement.executeQuery();
        list = this.module.getReturnedResultSets();
        JDBCTestModuleTest.assertEquals((int)3, (int)list.size());
        JDBCTestModuleTest.assertEquals((String)"1", (String)((MockResultSet)list.get(0)).getId());
        JDBCTestModuleTest.assertEquals((String)"2", (String)((MockResultSet)list.get(1)).getId());
        JDBCTestModuleTest.assertEquals((String)"4", (String)((MockResultSet)list.get(2)).getId());
        callableStatement.setString(1, "xyz");
        callableStatement.executeQuery();
        list = this.module.getReturnedResultSets();
        JDBCTestModuleTest.assertEquals((int)4, (int)list.size());
        JDBCTestModuleTest.assertEquals((String)"1", (String)((MockResultSet)list.get(0)).getId());
        JDBCTestModuleTest.assertEquals((String)"2", (String)((MockResultSet)list.get(1)).getId());
        JDBCTestModuleTest.assertEquals((String)"4", (String)((MockResultSet)list.get(2)).getId());
        JDBCTestModuleTest.assertEquals((String)"5", (String)((MockResultSet)list.get(3)).getId());
        ((MockResultSet)list.get(0)).close();
        this.module.verifyResultSetClosed("1");
        try {
            this.module.verifyResultSetClosed("2");
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifyAllResultSetsClosed();
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        ((MockResultSet)list.get(1)).close();
        ((MockResultSet)list.get(2)).close();
        ((MockResultSet)list.get(3)).close();
        this.module.verifyAllResultSetsClosed();
    }

    public void testMultipleReturnedResultSetsClosed() throws Exception {
        this.prepareStatements();
        this.preparePreparedStatements();
        this.prepareCallableStatements();
        MockResultSet resultSet1 = this.module.getStatementResultSetHandler().createResultSet("1");
        MockResultSet resultSet2 = this.module.getStatementResultSetHandler().createResultSet("2");
        MockResultSet resultSet3 = this.module.getStatementResultSetHandler().createResultSet("3");
        MockResultSet resultSet4 = this.module.getStatementResultSetHandler().createResultSet("4");
        MockResultSet resultSet5 = this.module.getStatementResultSetHandler().createResultSet("5");
        MockResultSet resultSet6 = this.module.getStatementResultSetHandler().createResultSet("6");
        MockResultSet resultSet7 = this.module.getStatementResultSetHandler().createResultSet("7");
        this.module.getStatementResultSetHandler().prepareGlobalResultSet(resultSet1);
        this.module.getStatementResultSetHandler().prepareResultSet("select id", resultSet2);
        this.module.getStatementResultSetHandler().prepareResultSets("select xyz", new MockResultSet[]{resultSet3, resultSet5});
        this.module.getPreparedStatementResultSetHandler().prepareResultSet("select name", resultSet4, new String[]{"test"});
        this.module.getCallableStatementResultSetHandler().prepareResultSet("call set", resultSet5);
        this.module.getCallableStatementResultSetHandler().prepareResultSets("call set", new MockResultSet[]{resultSet6, resultSet7, resultSet1}, new String[]{"xyz"});
        MockStatement statement = this.module.getStatement(0);
        statement.executeQuery("select name");
        statement.executeQuery("select id");
        statement.executeQuery("select xyz");
        MockPreparedStatement preparedStatement = (MockPreparedStatement)this.mockfactory.getMockConnection().prepareStatement("SELECT NAME");
        preparedStatement.setString(1, "test");
        preparedStatement.executeQuery();
        MockCallableStatement callableStatement = this.module.getCallableStatement("call set");
        callableStatement.executeQuery();
        callableStatement.setString(1, "xyz");
        callableStatement.executeQuery();
        try {
            this.module.verifyAllStatementsClosed();
            JDBCTestModuleTest.fail();
        }
        catch (Exception exc) {
            // empty catch block
        }
        List list = this.module.getReturnedResultSets();
        for (int ii = 0; ii < list.size() - 1; ++ii) {
            Object object = list.get(ii);
            if (object instanceof MockResultSet) {
                ((MockResultSet)object).close();
                continue;
            }
            MockResultSet[] resultSets = (MockResultSet[])object;
            for (int yy = 0; yy < resultSets.length; ++yy) {
                resultSets[yy].close();
            }
        }
        try {
            this.module.verifyAllStatementsClosed();
            JDBCTestModuleTest.fail();
        }
        catch (Exception exc) {
            // empty catch block
        }
        MockResultSet[] resultSets = (MockResultSet[])list.get(list.size() - 1);
        for (int ii = 0; ii < resultSets.length; ++ii) {
            resultSets[ii].close();
        }
        this.module.verifyAllResultSetsClosed();
    }

    public void testStatementsClosed() throws Exception {
        this.prepareStatements();
        this.preparePreparedStatements();
        this.prepareCallableStatements();
        MockStatement statement = this.module.getStatement(0);
        MockPreparedStatement preparedStatement = this.module.getPreparedStatement("update");
        statement.close();
        preparedStatement.close();
        this.module.verifyStatementClosed(0);
        this.module.verifyPreparedStatementClosed("update");
        try {
            this.module.verifyAllStatementsClosed();
            JDBCTestModuleTest.fail();
        }
        catch (Exception exc) {
            // empty catch block
        }
        ArrayList statements = new ArrayList();
        statements.addAll(this.module.getStatements());
        statements.addAll(this.module.getPreparedStatements());
        statements.addAll(this.module.getCallableStatements());
        for (int ii = 0; ii < statements.size(); ++ii) {
            ((MockStatement)statements.get(ii)).close();
        }
        this.module.verifyAllStatementsClosed();
        this.mockfactory.getMockConnection().close();
        this.module.verifyConnectionClosed();
    }

    public void testSavepoints() throws Exception {
        this.mockfactory.getMockConnection().setSavepoint();
        this.mockfactory.getMockConnection().setSavepoint("test");
        Savepoint savepoint2 = this.mockfactory.getMockConnection().setSavepoint("xyz");
        Savepoint savepoint3 = this.mockfactory.getMockConnection().setSavepoint();
        this.module.verifySavepointNotReleased(0);
        this.module.verifySavepointNotReleased(1);
        this.module.verifySavepointNotReleased(2);
        this.module.verifySavepointNotReleased(3);
        this.module.verifySavepointNotRolledBack(0);
        this.module.verifySavepointNotRolledBack("test");
        this.module.verifySavepointNotRolledBack(2);
        this.module.verifySavepointNotRolledBack(3);
        this.mockfactory.getMockConnection().releaseSavepoint(savepoint2);
        this.mockfactory.getMockConnection().rollback(savepoint3);
        this.module.verifySavepointNotReleased(0);
        this.module.verifySavepointNotReleased(1);
        this.module.verifySavepointReleased("xyz");
        this.module.verifySavepointNotReleased(3);
        this.module.verifySavepointNotRolledBack(0);
        this.module.verifySavepointNotRolledBack(1);
        this.module.verifySavepointNotRolledBack("xyz");
        this.module.verifySavepointRolledBack(3);
        try {
            this.module.verifySavepointReleased("test");
            JDBCTestModuleTest.fail();
        }
        catch (Exception exc) {
            // empty catch block
        }
        try {
            this.module.verifySavepointNotRolledBack(3);
            JDBCTestModuleTest.fail();
        }
        catch (Exception exc) {
            // empty catch block
        }
        List savepoints = this.module.getSavepoints();
        int[] ids = new int[4];
        int ii = 0;
        while (ii < savepoints.size()) {
            int n = ii++;
            ids[n] = ids[n] + 1;
        }
        JDBCTestModuleTest.assertTrue((ids[0] == 1 ? 1 : 0) != 0);
        JDBCTestModuleTest.assertTrue((ids[1] == 1 ? 1 : 0) != 0);
        JDBCTestModuleTest.assertTrue((ids[2] == 1 ? 1 : 0) != 0);
        JDBCTestModuleTest.assertTrue((ids[3] == 1 ? 1 : 0) != 0);
        MockSavepoint savepoint = this.module.getSavepoint("xyz");
        JDBCTestModuleTest.assertTrue((savepoint == savepoint2 ? 1 : 0) != 0);
    }

    public void testVerifyNumberCommitsAndRollbacks() throws Exception {
        try {
            this.module.verifyCommitted();
            JDBCTestModuleTest.fail();
        }
        catch (Exception exc) {
            // empty catch block
        }
        try {
            this.module.verifyRolledBack();
            JDBCTestModuleTest.fail();
        }
        catch (Exception exc) {
            // empty catch block
        }
        Savepoint savepoint = this.mockfactory.getMockConnection().setSavepoint();
        this.mockfactory.getMockConnection().commit();
        this.mockfactory.getMockConnection().rollback();
        this.mockfactory.getMockConnection().rollback(savepoint);
        this.module.verifyCommitted();
        this.module.verifyRolledBack();
        this.module.verifyNumberCommits(1);
        this.module.verifyNumberRollbacks(2);
    }

    public void testVerifyResultSet() {
        MockResultSet resultSet1 = this.module.getStatementResultSetHandler().createResultSet("test");
        resultSet1.addRow(new Integer[]{new Integer(1), new Integer(2), new Integer(3)});
        resultSet1.addRow(new Integer[]{new Integer(4), new Integer(5), new Integer(6)});
        resultSet1.addRow(new Integer[]{new Integer(7), new Integer(8), new Integer(9)});
        this.module.getStatementResultSetHandler().addReturnedResultSet(resultSet1);
        MockResultSet resultSet2 = this.module.getStatementResultSetHandler().createResultSet("xyz");
        resultSet2.addColumn("column", new String[]{"1", "2", "3"});
        this.module.getStatementResultSetHandler().addReturnedResultSet(resultSet2);
        this.module.verifyResultSetRow("test", 2, (Object[])new Integer[]{new Integer(4), new Integer(5), new Integer(6)});
        try {
            this.module.verifyResultSetRow(resultSet1, 3, (Object[])new Integer[]{new Integer(4), new Integer(5), new Integer(6)});
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        this.module.verifyResultSetColumn("test", 1, (Object[])new Integer[]{new Integer(1), new Integer(4), new Integer(7)});
        this.module.verifyResultSetColumn(resultSet2, 1, (Object[])new String[]{"1", "2", "3"});
        this.module.verifyResultSetColumn(resultSet2, "column", (Object[])new String[]{"1", "2", "3"});
        this.module.verifyResultSetRow("xyz", 3, (Object[])new String[]{"3"});
        try {
            this.module.verifyResultSetRow(resultSet2, 3, (Object[])new String[]{"3", "4"});
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifyResultSetColumn("xyz", "testColumn", (Object[])new String[]{"1"});
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifyResultSetColumn("xyz", 2, (Object[])new String[]{"1", "2", "3"});
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifyResultSetRow(resultSet2, 5, (Object[])new String[]{"1", "2", "3"});
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifyResultSetEquals(resultSet1, resultSet2);
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException verifyFailedException) {
            // empty catch block
        }
        this.module.verifyResultSetEquals(resultSet1, resultSet1);
        this.module.verifyResultSetEquals(resultSet2, resultSet2);
        resultSet2 = this.module.getStatementResultSetHandler().createResultSet("test2");
        resultSet2.addRow(new Integer[]{new Integer(1), new Integer(2), new Integer(3)});
        resultSet2.addRow(new Integer[]{new Integer(4), new Integer(5), new Integer(6)});
        resultSet2.addRow(new Integer[]{new Integer(7), new Integer(8), new Integer(9)});
        this.module.getStatementResultSetHandler().addReturnedResultSet(resultSet2);
        this.module.getStatementResultSetHandler().addReturnedResultSet(resultSet1);
        this.module.verifyResultSetEquals(resultSet1, resultSet2);
        this.module.verifyResultSetEquals("test", resultSet2);
        this.module.verifyResultSetEquals("test2", resultSet1);
    }

    public void testVerifyResultSetRowModified() throws Exception {
        MockResultSet resultSet = this.module.getStatementResultSetHandler().createResultSet("test");
        resultSet.addRow(new Integer[]{new Integer(1), new Integer(2), new Integer(3)});
        resultSet.addRow(new Integer[]{new Integer(4), new Integer(5), new Integer(6)});
        resultSet.addRow(new Integer[]{new Integer(7), new Integer(8), new Integer(9)});
        this.module.getStatementResultSetHandler().prepareResultSet("select", resultSet);
        Statement statement = this.mockfactory.getMockConnection().createStatement(1005, 1008);
        MockResultSet returnedResultSet = (MockResultSet)statement.executeQuery("select");
        resultSet = (MockResultSet)this.module.getStatementResultSetHandler().getReturnedResultSets().get(0);
        this.module.verifyResultSetRowNotDeleted(resultSet, 1);
        this.module.verifyResultSetRowNotDeleted("test", 2);
        this.module.verifyResultSetRowNotInserted("test", 2);
        this.module.verifyResultSetRowNotUpdated(resultSet, 3);
        try {
            this.module.verifyResultSetRowUpdated(resultSet, 1);
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        resultSet.setResultSetConcurrency(1008);
        returnedResultSet.next();
        returnedResultSet.updateRow();
        this.module.verifyResultSetRowUpdated(resultSet, 1);
        returnedResultSet.next();
        returnedResultSet.deleteRow();
        this.module.verifyResultSetRowDeleted(resultSet, 2);
        returnedResultSet.next();
        returnedResultSet.moveToInsertRow();
        returnedResultSet.updateString(1, "test");
        returnedResultSet.insertRow();
        returnedResultSet.moveToCurrentRow();
        this.module.verifyResultSetRowInserted("test", 3);
        returnedResultSet.first();
        returnedResultSet.moveToInsertRow();
        returnedResultSet.updateString(1, "test");
        returnedResultSet.insertRow();
        returnedResultSet.moveToCurrentRow();
        this.module.verifyResultSetRowInserted("test", 1);
        this.module.verifyResultSetRowDeleted(resultSet, 3);
        this.module.verifyResultSetRowNotUpdated(resultSet, 4);
    }

    public void testGetExecutedSQLStatementParameter() throws Exception {
        this.prepareStatements();
        this.preparePreparedStatements();
        this.prepareCallableStatements();
        this.module.getPreparedStatement(0).setString(1, "test");
        this.module.getPreparedStatement(0).setShort(2, (short)2);
        this.module.getPreparedStatement(1).setBytes(1, new byte[]{1});
        this.module.getCallableStatement(1).setBoolean("name", false);
        this.module.getStatement(0).execute("select mydata");
        this.module.getStatement(1).execute("select mydata");
        this.module.getPreparedStatement(0).execute();
        this.module.getPreparedStatement(1).execute();
        this.module.getPreparedStatement(2).execute();
        this.module.getCallableStatement(0).execute();
        this.module.getCallableStatement(1).execute();
        Map parameterMap = this.module.getExecutedSQLStatementParameterMap();
        JDBCTestModuleTest.assertEquals((int)5, (int)parameterMap.size());
        Map preparedStatementMap1 = ((ParameterSets)parameterMap.get("INSERT INTO TEST (COL1, COL2) VALUES(?, ?)")).getParameterSet(0);
        JDBCTestModuleTest.assertEquals((int)2, (int)preparedStatementMap1.size());
        JDBCTestModuleTest.assertEquals((Object)"test", preparedStatementMap1.get(new Integer(1)));
        JDBCTestModuleTest.assertEquals((Object)new Short(2), preparedStatementMap1.get(new Integer(2)));
        Map preparedStatementMap2 = ((ParameterSets)parameterMap.get("insert into test (col1, col2, col3) values(?, ?, ?)")).getParameterSet(0);
        JDBCTestModuleTest.assertEquals((int)1, (int)preparedStatementMap2.size());
        JDBCTestModuleTest.assertTrue((boolean)Arrays.equals(new byte[]{1}, (byte[])preparedStatementMap2.get(new Integer(1))));
        Map preparedStatementMap3 = ((ParameterSets)parameterMap.get("update mytable set test = test + ? where id = ?")).getParameterSet(0);
        JDBCTestModuleTest.assertEquals((int)0, (int)preparedStatementMap3.size());
        Map callableStatementMap1 = ((ParameterSets)parameterMap.get("{call getData(?, ?, ?, ?)}")).getParameterSet(0);
        JDBCTestModuleTest.assertEquals((int)0, (int)callableStatementMap1.size());
        Map callableStatementMap2 = ((ParameterSets)parameterMap.get("{call setData(?, ?, ?, ?)}")).getParameterSet(0);
        JDBCTestModuleTest.assertEquals((int)1, (int)callableStatementMap2.size());
        JDBCTestModuleTest.assertEquals((Object)Boolean.FALSE, callableStatementMap2.get("name"));
    }

    public void testGetExecutedSQLStatementParameterSets() throws Exception {
        this.preparePreparedStatements();
        this.prepareCallableStatements();
        this.module.getPreparedStatement(0).setString(1, "test");
        this.module.getPreparedStatement(0).setShort(2, (short)2);
        this.module.getPreparedStatement(1).setBytes(1, new byte[]{1});
        this.module.getCallableStatement(1).setBoolean("name", false);
        this.module.getPreparedStatement(0).execute();
        this.module.getPreparedStatement(1).execute();
        this.module.getPreparedStatement(2).execute();
        this.module.getCallableStatement(0).execute();
        this.module.getCallableStatement(1).execute();
        this.module.getPreparedStatement(0).setString(1, "test1");
        this.module.getPreparedStatement(0).setShort(2, (short)3);
        this.module.getPreparedStatement(0).execute();
        ParameterSets sets1 = this.module.getExecutedSQLStatementParameterSets("INSERT INTO TEST (COL1, COL2)");
        JDBCTestModuleTest.assertEquals((int)2, (int)sets1.getNumberParameterSets());
        Map parameterSet1 = sets1.getParameterSet(0);
        JDBCTestModuleTest.assertEquals((int)2, (int)parameterSet1.size());
        JDBCTestModuleTest.assertEquals((Object)"test", parameterSet1.get(new Integer(1)));
        JDBCTestModuleTest.assertEquals((Object)new Short(2), parameterSet1.get(new Integer(2)));
        Map parameterSet2 = sets1.getParameterSet(1);
        JDBCTestModuleTest.assertEquals((int)2, (int)parameterSet2.size());
        JDBCTestModuleTest.assertEquals((Object)"test1", parameterSet2.get(new Integer(1)));
        JDBCTestModuleTest.assertEquals((Object)new Short(3), parameterSet2.get(new Integer(2)));
        this.module.setUseRegularExpressions(true);
        ParameterSets sets2 = this.module.getExecutedSQLStatementParameterSets("insert into test \\(col1, col2, col3\\) .*");
        JDBCTestModuleTest.assertEquals((int)1, (int)sets2.getNumberParameterSets());
        parameterSet1 = sets2.getParameterSet(0);
        JDBCTestModuleTest.assertEquals((int)1, (int)parameterSet1.size());
        JDBCTestModuleTest.assertTrue((boolean)Arrays.equals(new byte[]{1}, (byte[])parameterSet1.get(new Integer(1))));
        ParameterSets sets3 = this.module.getExecutedSQLStatementParameterSets("{call setData\\(\\?, \\?, \\?, \\?\\)}");
        JDBCTestModuleTest.assertEquals((int)1, (int)sets3.getNumberParameterSets());
        parameterSet1 = sets3.getParameterSet(0);
        JDBCTestModuleTest.assertEquals((int)1, (int)parameterSet1.size());
        JDBCTestModuleTest.assertEquals((Object)Boolean.FALSE, parameterSet1.get("name"));
        ParameterSets sets4 = this.module.getExecutedSQLStatementParameterSets("{call getData\\(\\?, \\?, \\?, \\?\\)}");
        JDBCTestModuleTest.assertEquals((int)1, (int)sets4.getNumberParameterSets());
        parameterSet1 = sets4.getParameterSet(0);
        JDBCTestModuleTest.assertEquals((int)0, (int)parameterSet1.size());
        JDBCTestModuleTest.assertNull((Object)this.module.getExecutedSQLStatementParameterSets("{call xyz"));
    }

    public void testSQLStatementParameterNoParameterSets() throws Exception {
        this.prepareStatements();
        this.module.getStatement(0).execute("test");
        try {
            this.module.verifySQLStatementParameterNumber("test", 0, 0);
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        this.preparePreparedStatements();
        this.module.getPreparedStatement(0).execute();
        try {
            this.module.verifySQLStatementParameterNumber("INSERT INTO TEST (COL1, COL2) VALUES(?,", 1, 0);
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifySQLStatementParameter("INSERT INTO TEST (COL1, COL2) VALUES(?,", 1, new HashMap());
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException verifyFailedException) {
            // empty catch block
        }
    }

    public void testSQLStatementParameterNumber() throws Exception {
        this.preparePreparedStatements();
        this.prepareCallableStatements();
        this.module.getPreparedStatement(0).setString(1, "test");
        this.module.getPreparedStatement(0).setString(2, "test");
        this.module.getCallableStatement(0).setString("name", "test");
        this.module.getCallableStatement(1).setString(1, "test");
        this.module.getPreparedStatement(0).execute();
        this.module.getPreparedStatement(1).execute();
        this.module.getPreparedStatement(2).execute();
        this.module.getCallableStatement(0).execute();
        this.module.getCallableStatement(1).execute();
        this.module.verifySQLStatementParameterNumber("INSERT INTO TEST (COL1, COL2) VALUES(?,", 0, 2);
        this.module.verifySQLStatementParameterNumber("insert into test (col1, col2, col3) values(?, ?, ?)", 0, 0);
        this.module.verifySQLStatementParameterNumber("update mytable set test = test + ? where id = ?", 0, 0);
        this.module.verifySQLStatementParameterNumber("{call getData(?, ?, ?, ?)}", 0, 1);
        this.module.verifySQLStatementParameterNumber("{call setData(?, ", 0, 1);
        try {
            this.module.verifySQLStatementParameterNumber("{call getData(?, ?, ?, ?)}", 0, 3);
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifySQLStatementParameterNumber("insert into test (col1, col2, col3) values(?, ?, ?)", 0, 1);
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifySQLStatementParameterNumber("xyz", 0, 0);
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException verifyFailedException) {
            // empty catch block
        }
    }

    public void testSQLStatementParameterPreparedStatement() throws Exception {
        this.preparePreparedStatements();
        this.module.getPreparedStatement(1).setString(1, "test1");
        this.module.getPreparedStatement(1).setInt(2, 3);
        this.module.getPreparedStatement(0).execute();
        this.module.getPreparedStatement(1).execute();
        this.module.getPreparedStatement(2).execute();
        HashMap emptyMap = new HashMap();
        HashMap<Integer, Object> okTestMap = new HashMap<Integer, Object>();
        okTestMap.put(new Integer(1), "test1");
        okTestMap.put(new Integer(2), new Integer(3));
        HashMap<Integer, Object> failureTestMap1 = new HashMap<Integer, Object>();
        failureTestMap1.put(new Integer(1), "test1");
        failureTestMap1.put(new Integer(2), new Integer(2));
        HashMap<Integer, Object> failureTestMap2 = new HashMap<Integer, Object>();
        failureTestMap2.put(new Integer(1), "test1");
        failureTestMap2.put(new Integer(2), new Integer(3));
        failureTestMap2.put(new Integer(3), new Integer(3));
        this.module.verifySQLStatementParameter("update mytable set test = test", 0, emptyMap);
        try {
            this.module.setUseRegularExpressions(true);
            this.module.verifySQLStatementParameter("update mytable set test = test", 0, emptyMap);
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        this.module.verifySQLStatementParameter("update mytable set test = test.*", 0, emptyMap);
        this.module.setUseRegularExpressions(false);
        this.module.verifySQLStatementParameter("insert into test (col1, col2, col3)", 0, okTestMap);
        this.module.verifySQLStatementParameter("insert into test (col1, col2, col3)", 0, 2, (Object)new Integer(3));
        try {
            this.module.verifySQLStatementParameter("insert into test (col1, col2, col3) values(?, ?, ?)", 0, failureTestMap1);
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifySQLStatementParameter("insert into test (col1, col2, col3) values(?, ?, ?)", 0, 1, (Object)"test2");
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifySQLStatementParameter("insert into test (col1, col2, col3) values(?, ?, ?)", 0, failureTestMap2);
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifySQLStatementParameter("INSERT INTO TEST (COL1, COL2) VALUES(?, ?)", 0, okTestMap);
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
    }

    public void testSQLStatementNullParameterPreparedStatement() throws Exception {
        this.preparePreparedStatements();
        this.module.getPreparedStatement(0).setString(1, null);
        this.module.getPreparedStatement(0).execute();
        this.module.verifySQLStatementParameter("INSERT INTO TEST (COL1, COL2) VALUES(?, ?)", 0, 1, null);
        try {
            this.module.verifySQLStatementParameter("INSERT INTO TEST (COL1, COL2) VALUES(?, ?)", 0, 1, (Object)"test");
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException verifyFailedException) {
            // empty catch block
        }
    }

    public void testSQLStatementParameterCallableStatement() throws Exception {
        this.prepareCallableStatements();
        this.module.getCallableStatement(0).setString(1, "test1");
        this.module.getCallableStatement(0).setBytes(2, new byte[]{1});
        this.module.getCallableStatement(0).setInt("name", 1);
        this.module.getCallableStatement(0).execute();
        this.module.getCallableStatement(1).execute();
        this.module.verifySQLStatementParameter("{call getData(?, ?", 0, 1, (Object)"test1");
        this.module.setUseRegularExpressions(true);
        this.module.verifySQLStatementParameter(".*getData\\(\\?, \\?.*", 0, 1, (Object)"test1");
        this.module.setUseRegularExpressions(false);
        try {
            this.module.verifySQLStatementParameter(".*getData\\(\\?, \\?.*", 0, 1, (Object)"test1");
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        this.module.verifySQLStatementParameter("{call getData(?, ?, ?, ?)}", 0, 2, (Object)new byte[]{1});
        this.module.verifySQLStatementParameter("{call getData(?, ?, ?, ?)}", 0, "name", (Object)new Integer(1));
        try {
            this.module.verifySQLStatementParameter("{call getData(?, ?, ?, ?)}", 0, 2, (Object)new byte[]{1, 2});
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifySQLStatementParameter("{call setData(?, ?, ?, ?)}", 0, 1, (Object)"");
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifySQLStatementParameter("select", 0, 1, (Object)"");
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        this.module.setCaseSensitive(true);
        try {
            this.module.verifySQLStatementParameter("{CALL getData(?, ?", 0, 1, (Object)"test1");
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException verifyFailedException) {
            // empty catch block
        }
    }

    public void testSQLStatementNullParameterCallableStatement() throws Exception {
        this.prepareCallableStatements();
        this.module.getCallableStatement(0).setString("1", null);
        this.module.getCallableStatement(0).execute();
        this.module.verifySQLStatementParameter("{call getData(?, ?, ?, ?)}", 0, "1", null);
        try {
            this.module.verifySQLStatementParameter("{call getData(?, ?, ?, ?)}", 0, "1", (Object)"test");
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException verifyFailedException) {
            // empty catch block
        }
    }

    public void testSQLStatementParameterMultipleParameterSets() throws Exception {
        this.prepareCallableStatements();
        this.module.getCallableStatement(0).setString(1, "test1");
        this.module.getCallableStatement(0).execute();
        this.module.getCallableStatement(0).setString(1, "xyz");
        this.module.getCallableStatement(0).setBoolean("name", true);
        this.module.getCallableStatement(0).execute();
        this.module.getCallableStatement(0).execute();
        this.module.verifySQLStatementParameterNumber("{call getData(?, ?, ?, ?)}", 0, 1);
        this.module.verifySQLStatementParameterNumber("{call getData(?, ?, ?, ?)}", 1, 2);
        this.module.verifySQLStatementParameterNumber("{call getData(?, ?, ?, ?)}", 2, 2);
        this.module.setUseRegularExpressions(true);
        this.module.verifySQLStatementParameterNumber("{call getData\\(\\?, \\?, \\?, \\?\\)}", 2, 2);
        this.module.verifySQLStatementParameterNumber(".call getData.*}", 2, 2);
        this.module.setUseRegularExpressions(false);
        this.module.verifySQLStatementParameter("{call getData(?, ?, ?, ?)}", 1, 1, (Object)"xyz");
        this.module.verifySQLStatementParameter("{call getData(?, ?, ?, ?)}", 1, "name", (Object)Boolean.TRUE);
        HashMap<Integer, String> testMap = new HashMap<Integer, String>();
        testMap.put(new Integer(1), "test1");
        this.module.verifySQLStatementParameter("{call getData(?, ?, ?, ?)}", 0, testMap);
        try {
            this.module.verifySQLStatementParameterNumber("{call getData(?, ?, ?, ?)}", 2, 0);
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifySQLStatementParameter("{call getData(?, ?, ?, ?)}", 0, new HashMap());
            JDBCTestModuleTest.fail();
        }
        catch (VerifyFailedException verifyFailedException) {
            // empty catch block
        }
    }

    public void testSQLStatementParameterPreparedStatementBatchParameterSets() throws Exception {
        MockPreparedStatement preparedStatement = (MockPreparedStatement)this.mockfactory.getMockConnection().prepareStatement("insert into test");
        preparedStatement.setString(1, "test1");
        preparedStatement.setInt(2, 3);
        preparedStatement.addBatch();
        preparedStatement.setString(1, "test2");
        preparedStatement.setInt(2, 4);
        preparedStatement.addBatch();
        preparedStatement.executeBatch();
        this.module.verifySQLStatementParameter("insert into test", 0, 1, (Object)"test1");
        this.module.verifySQLStatementParameter("insert into test", 0, 2, (Object)new Integer(3));
        this.module.verifySQLStatementParameter("insert into test", 1, 1, (Object)"test2");
        this.module.verifySQLStatementParameter("insert into test", 1, 2, (Object)new Integer(4));
        HashMap<Integer, Object> testMap = new HashMap<Integer, Object>();
        testMap.put(new Integer(1), "test1");
        testMap.put(new Integer(2), new Integer(3));
        this.module.verifySQLStatementParameter("insert into test", 0, testMap);
        testMap = new HashMap();
        testMap.put(new Integer(1), "test2");
        testMap.put(new Integer(2), new Integer(4));
        this.module.verifySQLStatementParameter("insert into test", 1, testMap);
    }

    public void testSQLStatementParameterCallableStatementBatchParameterSets() throws Exception {
        MockCallableStatement callableStatement = (MockCallableStatement)this.mockfactory.getMockConnection().prepareCall("call getData");
        callableStatement.setString("xyz1", "test1");
        callableStatement.setLong(1, 3L);
        callableStatement.addBatch();
        callableStatement.setString(1, "test2");
        callableStatement.setInt("xyz1", 4);
        callableStatement.setInt("xyz2", 7);
        callableStatement.addBatch();
        callableStatement.executeBatch();
        this.module.verifySQLStatementParameter("call getData", 0, "xyz1", (Object)"test1");
        this.module.verifySQLStatementParameter("call getData", 0, 1, (Object)new Long(3L));
        this.module.verifySQLStatementParameter("call getData", 1, "xyz1", (Object)new Integer(4));
        this.module.verifySQLStatementParameter("call getData", 1, "xyz2", (Object)new Integer(7));
        this.module.verifySQLStatementParameter("call getData", 1, 1, (Object)"test2");
        HashMap<Object, Object> testMap = new HashMap<Object, Object>();
        testMap.put("xyz1", "test1");
        testMap.put(new Integer(1), new Long(3L));
        this.module.verifySQLStatementParameter("call getData", 0, testMap);
        testMap = new HashMap();
        testMap.put("xyz1", new Integer(4));
        testMap.put("xyz2", new Integer(7));
        testMap.put(new Integer(1), "test2");
        this.module.verifySQLStatementParameter("call getData", 1, testMap);
    }

    public void testPreparedStatementsAndCallableStatementsSQLOrdered() throws Exception {
        this.preparePreparedStatements();
        MockPreparedStatement preparedStatement = this.module.getPreparedStatement("insert");
        JDBCTestModuleTest.assertSame(this.module.getPreparedStatementResultSetHandler().getPreparedStatements().get(0), (Object)preparedStatement);
        this.prepareCallableStatements();
        MockCallableStatement callableStatement = this.module.getCallableStatement("call");
        JDBCTestModuleTest.assertSame(this.module.getCallableStatementResultSetHandler().getCallableStatements().get(0), (Object)callableStatement);
    }
}

