/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.jdbc;

import com.mockrunner.mock.jdbc.MockBlob;
import com.mockrunner.util.common.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Arrays;
import junit.framework.TestCase;

public class MockBlobTest
extends TestCase {
    private MockBlob blob;

    protected void setUp() throws Exception {
        super.setUp();
        this.blob = new MockBlob(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11});
    }

    public void testGetBytes() throws Exception {
        byte[] data = this.blob.getBytes(1L, 3);
        MockBlobTest.assertTrue((boolean)Arrays.equals(data, new byte[]{1, 2, 3}));
        data = this.blob.getBytes(5L, 25);
        MockBlobTest.assertTrue((boolean)Arrays.equals(data, new byte[]{5, 6, 7, 8, 9, 10, 11}));
        data = this.blob.getBytes(5L, 2);
        MockBlobTest.assertTrue((boolean)Arrays.equals(data, new byte[]{5, 6}));
        data = this.blob.getBytes(1L, 12);
        MockBlobTest.assertTrue((boolean)Arrays.equals(data, new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}));
        MockBlobTest.assertTrue((this.blob.getBytes(5L, 0).length == 0 ? 1 : 0) != 0);
        MockBlobTest.assertTrue((new MockBlob(new byte[0]).getBytes(1L, 0).length == 0 ? 1 : 0) != 0);
        try {
            this.blob.getBytes(1L, -1);
            MockBlobTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetBinaryStream() throws Exception {
        InputStream stream = this.blob.getBinaryStream();
        MockBlobTest.assertTrue((boolean)StreamUtil.compareStreams((InputStream)stream, (InputStream)new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11})));
        stream = this.blob.getBinaryStream(1L, 3L);
        MockBlobTest.assertTrue((boolean)StreamUtil.compareStreams((InputStream)stream, (InputStream)new ByteArrayInputStream(new byte[]{1, 2, 3})));
        stream = this.blob.getBinaryStream(7L, 45L);
        MockBlobTest.assertTrue((boolean)StreamUtil.compareStreams((InputStream)stream, (InputStream)new ByteArrayInputStream(new byte[]{7, 8, 9, 10, 11})));
        this.blob = new MockBlob(new byte[0]);
        stream = this.blob.getBinaryStream();
        MockBlobTest.assertTrue((boolean)StreamUtil.compareStreams((InputStream)stream, (InputStream)new ByteArrayInputStream(new byte[0])));
        try {
            this.blob.getBinaryStream(1L, -2L);
            MockBlobTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPosition() throws Exception {
        byte[] searchBytes = new byte[]{8, 9};
        MockBlobTest.assertEquals((long)8L, (long)this.blob.position(searchBytes, 1L));
        searchBytes = new byte[]{12};
        MockBlobTest.assertEquals((long)-1L, (long)this.blob.position(searchBytes, 1L));
        MockBlob searchBlob = new MockBlob(new byte[]{4, 5, 6});
        MockBlobTest.assertEquals((long)4L, (long)this.blob.position(searchBlob, 1L));
    }

    public void testUpdateData() throws Exception {
        this.blob.setBytes(11L, new byte[]{12});
        byte[] data = this.blob.getBytes(1L, 11);
        MockBlobTest.assertEquals((int)12, (int)data[10]);
        this.blob.setBytes(14L, new byte[]{12});
        MockBlobTest.assertTrue((this.blob.length() == 14L ? 1 : 0) != 0);
        data = this.blob.getBytes(1L, 14);
        MockBlobTest.assertEquals((int)12, (int)data[10]);
        MockBlobTest.assertEquals((int)0, (int)data[11]);
        MockBlobTest.assertEquals((int)0, (int)data[12]);
        MockBlobTest.assertEquals((int)12, (int)data[13]);
        OutputStream stream = this.blob.setBinaryStream(2L);
        stream.write(3);
        data = this.blob.getBytes(1L, 14);
        MockBlobTest.assertEquals((int)1, (int)data[0]);
        MockBlobTest.assertEquals((int)3, (int)data[1]);
        MockBlobTest.assertEquals((int)3, (int)data[2]);
        stream.write(new byte[]{4, 5, 6});
        data = this.blob.getBytes(1L, 14);
        MockBlobTest.assertEquals((int)1, (int)data[0]);
        MockBlobTest.assertEquals((int)3, (int)data[1]);
        MockBlobTest.assertEquals((int)4, (int)data[2]);
        MockBlobTest.assertEquals((int)5, (int)data[3]);
        MockBlobTest.assertEquals((int)6, (int)data[4]);
        stream = this.blob.setBinaryStream(1L);
        OutputStream anotherAtream = this.blob.setBinaryStream(16L);
        stream.write(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15});
        anotherAtream.write(16);
        data = this.blob.getBytes(1L, 16);
        MockBlobTest.assertTrue((boolean)Arrays.equals(data, new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}));
    }

    public void testFree() throws Exception {
        MockBlobTest.assertFalse((boolean)this.blob.wasFreeCalled());
        this.blob.free();
        MockBlobTest.assertTrue((boolean)this.blob.wasFreeCalled());
        try {
            this.blob.getBytes(1L, 0);
            MockBlobTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        try {
            this.blob.truncate(5L);
            MockBlobTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        try {
            this.blob.setBytes(1L, new byte[0], 2, 3);
            MockBlobTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        MockBlob copy = (MockBlob)this.blob.clone();
        MockBlobTest.assertTrue((boolean)copy.wasFreeCalled());
    }

    public void testEquals() throws Exception {
        MockBlob blob1 = new MockBlob(new byte[]{1, 2, 3});
        MockBlobTest.assertFalse((boolean)blob1.equals(null));
        MockBlobTest.assertTrue((boolean)blob1.equals(blob1));
        MockBlob blob2 = new MockBlob(new byte[]{1, 2, 3, 4});
        MockBlobTest.assertFalse((boolean)blob1.equals(blob2));
        MockBlobTest.assertFalse((boolean)blob2.equals(blob1));
        blob2 = new MockBlob(new byte[]{1, 2, 3});
        MockBlobTest.assertTrue((boolean)blob1.equals(blob2));
        MockBlobTest.assertTrue((boolean)blob2.equals(blob1));
        MockBlobTest.assertEquals((int)blob1.hashCode(), (int)blob2.hashCode());
        blob2.free();
        MockBlobTest.assertFalse((boolean)blob1.equals(blob2));
        MockBlobTest.assertFalse((boolean)blob2.equals(blob1));
    }

    public void testClone() throws Exception {
        MockBlob cloneBlob = (MockBlob)this.blob.clone();
        MockBlobTest.assertTrue((this.blob.length() == cloneBlob.length() ? 1 : 0) != 0);
        this.blob.setBytes(1L, new byte[]{2});
        byte[] data = this.blob.getBytes(1L, 11);
        MockBlobTest.assertTrue((boolean)Arrays.equals(data, new byte[]{2, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}));
        data = cloneBlob.getBytes(1L, 11);
        MockBlobTest.assertTrue((boolean)Arrays.equals(data, new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}));
    }

    public void testToString() throws Exception {
        MockBlob blob = new MockBlob(new byte[0]);
        MockBlobTest.assertEquals((String)"Blob data: []", (String)blob.toString());
        blob = new MockBlob(new byte[]{1, 2, 3});
        MockBlobTest.assertEquals((String)"Blob data: [1, 2, 3]", (String)blob.toString());
    }
}

