/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.jdbc;

import com.mockrunner.mock.jdbc.MockClob;
import com.mockrunner.util.common.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.SQLException;
import junit.framework.TestCase;

public class MockClobTest
extends TestCase {
    private MockClob clob;

    protected void setUp() throws Exception {
        super.setUp();
        this.clob = new MockClob("This is a Test Clob");
    }

    public void testSubString() throws Exception {
        MockClobTest.assertEquals((String)" is a Test Clob", (String)this.clob.getSubString(5L, 15));
        MockClobTest.assertEquals((String)"This is a Test Clob", (String)this.clob.getSubString(1L, 19));
        MockClobTest.assertEquals((String)"This is a Test Clob", (String)this.clob.getSubString(1L, 25));
        MockClobTest.assertEquals((String)"Th", (String)this.clob.getSubString(1L, 2));
        MockClobTest.assertEquals((String)"C", (String)this.clob.getSubString(16L, 1));
        MockClobTest.assertEquals((String)"", (String)this.clob.getSubString(16L, 0));
        try {
            this.clob.getSubString(5L, -1);
            MockClobTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetStream() throws Exception {
        MockClobTest.assertTrue((boolean)StreamUtil.compareReaders((Reader)this.clob.getCharacterStream(), (Reader)new StringReader("This is a Test Clob")));
        MockClobTest.assertTrue((boolean)StreamUtil.compareStreams((InputStream)this.clob.getAsciiStream(), (InputStream)new ByteArrayInputStream("This is a Test Clob".getBytes("ISO-8859-1"))));
        MockClobTest.assertTrue((boolean)StreamUtil.compareReaders((Reader)this.clob.getCharacterStream(6L, 15L), (Reader)new StringReader("is a Test Clob")));
        MockClobTest.assertTrue((boolean)StreamUtil.compareReaders((Reader)this.clob.getCharacterStream(6L, 16L), (Reader)new StringReader("is a Test Clob")));
        MockClobTest.assertTrue((boolean)StreamUtil.compareReaders((Reader)this.clob.getCharacterStream(1L, 4L), (Reader)new StringReader("This")));
        MockClobTest.assertTrue((boolean)StreamUtil.compareReaders((Reader)this.clob.getCharacterStream(1L, 0L), (Reader)new StringReader("")));
        try {
            this.clob.getSubString(1L, -1);
            MockClobTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPosition() throws Exception {
        MockClobTest.assertEquals((long)16L, (long)this.clob.position("Clob", 0L));
        MockClobTest.assertEquals((long)16L, (long)this.clob.position(new MockClob("Clob"), 5L));
        MockClobTest.assertEquals((long)-1L, (long)this.clob.position(new MockClob("XYZ"), 5L));
        MockClobTest.assertEquals((long)1L, (long)this.clob.position("T", 1L));
        MockClobTest.assertEquals((long)11L, (long)this.clob.position("T", 2L));
        MockClobTest.assertEquals((long)1L, (long)this.clob.position(this.clob, 1L));
    }

    public void testUpdateData() throws Exception {
        this.clob.setString(11L, "XYZZ");
        MockClobTest.assertEquals((String)"This is a XYZZ Clob", (String)this.clob.getSubString(1L, 19));
        this.clob.setString(11L, "Test Mock Clob");
        MockClobTest.assertEquals((String)"This is a Test Mock Clob", (String)this.clob.getSubString(1L, 24));
        this.clob.setString(1L, "XYZ This", 4, 4);
        MockClobTest.assertEquals((String)"This is a Test Mock Clob", (String)this.clob.getSubString(1L, 24));
        OutputStream stream = this.clob.setAsciiStream(1L);
        stream.write(new byte[]{65, 66, 67, 68});
        MockClobTest.assertEquals((String)"ABCD is a Test Mock Clob", (String)this.clob.getSubString(1L, 24));
        Writer writer = this.clob.setCharacterStream(5L);
        writer.write("FFG");
        stream.write(69);
        MockClobTest.assertEquals((String)"ABCDEFG a Test Mock Clob", (String)this.clob.getSubString(1L, 24));
        writer = this.clob.setCharacterStream(1L);
        writer.write("This is a Test ClobThis is a Test Clob");
        MockClobTest.assertEquals((String)"This is a Test ClobThis is a Test Clob", (String)this.clob.getSubString(1L, 38));
    }

    public void testFree() throws Exception {
        MockClobTest.assertFalse((boolean)this.clob.wasFreeCalled());
        this.clob.free();
        MockClobTest.assertTrue((boolean)this.clob.wasFreeCalled());
        try {
            this.clob.getSubString(1L, 2);
            MockClobTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        try {
            this.clob.getAsciiStream();
            MockClobTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        try {
            this.clob.position("", 1L);
            MockClobTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        MockClob copy = (MockClob)this.clob.clone();
        MockClobTest.assertTrue((boolean)copy.wasFreeCalled());
    }

    public void testEquals() throws Exception {
        MockClob clob1 = new MockClob("This is a Test Clob");
        MockClobTest.assertFalse((boolean)clob1.equals(null));
        MockClobTest.assertTrue((boolean)clob1.equals(clob1));
        MockClob clob2 = new MockClob("This is another Test Clob");
        MockClobTest.assertFalse((boolean)clob1.equals(clob2));
        MockClobTest.assertFalse((boolean)clob2.equals(clob1));
        clob2 = new MockClob("This is a Test Clob");
        MockClobTest.assertTrue((boolean)clob1.equals(clob2));
        MockClobTest.assertTrue((boolean)clob2.equals(clob1));
        MockClobTest.assertEquals((int)clob1.hashCode(), (int)clob2.hashCode());
        clob1.free();
        MockClobTest.assertFalse((boolean)clob1.equals(clob2));
        MockClobTest.assertFalse((boolean)clob2.equals(clob1));
    }

    public void testClone() throws Exception {
        MockClob cloneClob = (MockClob)this.clob.clone();
        this.clob.setString(1L, "Test");
        MockClobTest.assertEquals((String)"Test is a Test Clob", (String)this.clob.getSubString(1L, 19));
        MockClobTest.assertEquals((String)"This is a Test Clob", (String)cloneClob.getSubString(1L, 19));
    }

    public void testToString() throws Exception {
        MockClob clob = new MockClob("");
        MockClobTest.assertEquals((String)"Clob data: ", (String)clob.toString());
        clob = new MockClob("test");
        MockClobTest.assertEquals((String)"Clob data: test", (String)clob.toString());
    }
}

