/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.jdbc;

import com.mockrunner.jdbc.ParameterUtil;
import com.mockrunner.mock.jdbc.MockArray;
import com.mockrunner.mock.jdbc.MockBlob;
import com.mockrunner.mock.jdbc.MockClob;
import com.mockrunner.mock.jdbc.MockRef;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.mock.jdbc.MockStruct;
import com.mockrunner.util.common.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Date;
import junit.framework.TestCase;

public class ParameterUtilTest
extends TestCase {
    public void testCompareParameter() {
        ParameterUtilTest.assertTrue((boolean)ParameterUtil.compareParameter(null, null));
        ParameterUtilTest.assertFalse((boolean)ParameterUtil.compareParameter("test", null));
        ParameterUtilTest.assertTrue((boolean)ParameterUtil.compareParameter("test", "test"));
        ParameterUtilTest.assertFalse((boolean)ParameterUtil.compareParameter(new Double(1.0), new Double(2.0)));
        ParameterUtilTest.assertTrue((boolean)ParameterUtil.compareParameter(new byte[]{1, 2, 3}, new byte[]{1, 2, 3}));
        ParameterUtilTest.assertFalse((boolean)ParameterUtil.compareParameter(new byte[]{1, 2, 4}, new byte[]{1, 2, 3}));
        ParameterUtilTest.assertTrue((boolean)ParameterUtil.compareParameter(new ByteArrayInputStream(new byte[]{1, 2, 3}), new ByteArrayInputStream(new byte[]{1, 2, 3})));
        ParameterUtilTest.assertTrue((boolean)ParameterUtil.compareParameter(new StringReader("xyz"), new StringReader("xyz")));
        ParameterUtilTest.assertFalse((boolean)ParameterUtil.compareParameter(new StringReader("xyz"), new StringReader("")));
        ParameterUtilTest.assertFalse((boolean)ParameterUtil.compareParameter(new Object(), new Object()));
        ParameterUtilTest.assertTrue((boolean)ParameterUtil.compareParameter(new MockRef("test"), new MockRef("test")));
        ParameterUtilTest.assertFalse((boolean)ParameterUtil.compareParameter(new MockRef(""), new MockRef("xyz")));
        ParameterUtilTest.assertTrue((boolean)ParameterUtil.compareParameter(new MockArray(new String[]{"", ""}), new MockArray(new String[]{"", ""})));
        ParameterUtilTest.assertFalse((boolean)ParameterUtil.compareParameter(new MockArray(new String[]{"", ""}), new MockArray(new int[]{1, 1})));
        ParameterUtilTest.assertTrue((boolean)ParameterUtil.compareParameter(new MockArray(new Object[]{"1", new Integer(2)}), new MockArray(new Object[]{"1", new Integer(2)})));
        ParameterUtilTest.assertFalse((boolean)ParameterUtil.compareParameter(new MockArray(new Object[]{new Integer(2), "1"}), new MockArray(new Object[]{"1", new Integer(2)})));
        ParameterUtilTest.assertTrue((boolean)ParameterUtil.compareParameter(new MockBlob(new byte[]{1, 1, 1}), new MockBlob(new byte[]{1, 1, 1})));
        ParameterUtilTest.assertFalse((boolean)ParameterUtil.compareParameter(new MockBlob(new byte[]{1, 1, 1}), new MockBlob(new byte[]{1, 1})));
        ParameterUtilTest.assertTrue((boolean)ParameterUtil.compareParameter(new MockBlob(new byte[0]), new MockBlob(new byte[0])));
        ParameterUtilTest.assertFalse((boolean)ParameterUtil.compareParameter(new MockBlob(new byte[0]), new MockBlob(new byte[]{2})));
        ParameterUtilTest.assertFalse((boolean)ParameterUtil.compareParameter(new MockBlob(new byte[]{1, 2, 3}), new MockBlob(new byte[]{1, 2, 4})));
        ParameterUtilTest.assertTrue((boolean)ParameterUtil.compareParameter(new MockClob("123"), new MockClob("123")));
        ParameterUtilTest.assertTrue((boolean)ParameterUtil.compareParameter(new MockClob(""), new MockClob("")));
        ParameterUtilTest.assertFalse((boolean)ParameterUtil.compareParameter(new MockClob("1"), new MockClob("")));
        ParameterUtilTest.assertTrue((boolean)ParameterUtil.compareParameter(new MockStruct(""), new MockStruct("")));
        ParameterUtilTest.assertTrue((boolean)ParameterUtil.compareParameter(new MockStruct("123"), new MockStruct("123")));
        ParameterUtilTest.assertFalse((boolean)ParameterUtil.compareParameter(new MockStruct("123"), new MockStruct("")));
        ParameterUtilTest.assertFalse((boolean)ParameterUtil.compareParameter(new String[]{"1", "2", "4"}, new String[]{"1", "2", "3"}));
        ParameterUtilTest.assertTrue((boolean)ParameterUtil.compareParameter(new String[]{"1", "2", "3"}, new String[]{"1", "2", "3"}));
        ParameterUtilTest.assertTrue((boolean)ParameterUtil.compareParameter(new int[]{1}, new int[]{1}));
        MockStruct struct = new MockStruct("123");
        struct.addAttribute("test");
        ParameterUtilTest.assertTrue((boolean)ParameterUtil.compareParameter(struct, struct));
        ParameterUtilTest.assertFalse((boolean)ParameterUtil.compareParameter(struct, new MockStruct("123")));
        MockStruct anotherStruct = new MockStruct("123");
        anotherStruct.addAttribute("test");
        ParameterUtilTest.assertTrue((boolean)ParameterUtil.compareParameter(struct, anotherStruct));
        anotherStruct.addAttribute(new Integer(2));
        ParameterUtilTest.assertFalse((boolean)ParameterUtil.compareParameter(struct, anotherStruct));
        struct.addAttribute(new Integer(2));
        ParameterUtilTest.assertTrue((boolean)ParameterUtil.compareParameter(struct, anotherStruct));
        MockResultSet resultSet1 = new MockResultSet("id");
        resultSet1.addRow(new Object[]{"1", new Integer(1)});
        resultSet1.addRow(new Object[]{"2", new Integer(2)});
        resultSet1.addRow(new Object[]{"3", new Integer(3)});
        MockResultSet resultSet2 = new MockResultSet("id");
        resultSet2.addRow(new Object[]{"1", new Integer(1)});
        resultSet2.addRow(new Object[]{"2", new Integer(2)});
        resultSet2.addRow(new Object[]{"3", new Integer(3)});
        ParameterUtilTest.assertTrue((boolean)ParameterUtil.compareParameter(resultSet1, resultSet1));
        ParameterUtilTest.assertTrue((boolean)ParameterUtil.compareParameter(resultSet1, resultSet2));
        resultSet2.addRow(new Object[]{"4", new Integer(4)});
        ParameterUtilTest.assertFalse((boolean)ParameterUtil.compareParameter(resultSet1, resultSet2));
    }

    public void testCopyParameter() {
        String testString = new String("Test");
        String copyString = (String)ParameterUtil.copyParameter(testString);
        ParameterUtilTest.assertTrue((testString == copyString ? 1 : 0) != 0);
        byte[] testArray = new byte[]{1, 2, 3};
        byte[] copyArray = (byte[])ParameterUtil.copyParameter(testArray);
        ParameterUtilTest.assertFalse((testArray == copyArray ? 1 : 0) != 0);
        ParameterUtilTest.assertTrue((boolean)Arrays.equals(testArray, copyArray));
        StringReader testReader = new StringReader("Test");
        Reader copyReader = (Reader)ParameterUtil.copyParameter(testReader);
        ParameterUtilTest.assertFalse((testReader == copyReader ? 1 : 0) != 0);
        ParameterUtilTest.assertTrue((boolean)StreamUtil.compareReaders((Reader)testReader, (Reader)copyReader));
        ByteArrayInputStream testStream = new ByteArrayInputStream(new byte[]{1, 2, 3});
        InputStream copyStream = (InputStream)ParameterUtil.copyParameter(testStream);
        ParameterUtilTest.assertFalse((testStream == copyStream ? 1 : 0) != 0);
        ParameterUtilTest.assertTrue((boolean)StreamUtil.compareStreams((InputStream)testStream, (InputStream)copyStream));
        MockClob testClob = new MockClob("Test");
        MockClob copyClob = (MockClob)ParameterUtil.copyParameter(testClob);
        ParameterUtilTest.assertFalse((testClob == copyClob ? 1 : 0) != 0);
        ParameterUtilTest.assertTrue((boolean)ParameterUtil.compareParameter(testClob, copyClob));
        MockArray testMockArray = new MockArray(new String[]{"", ""});
        MockArray copyMockArray = (MockArray)ParameterUtil.copyParameter(testMockArray);
        ParameterUtilTest.assertFalse((testMockArray == copyMockArray ? 1 : 0) != 0);
        ParameterUtilTest.assertTrue((boolean)ParameterUtil.compareParameter(testMockArray, copyMockArray));
        Date testDate = new Date();
        Date copyDate = (Date)ParameterUtil.copyParameter(testDate);
        ParameterUtilTest.assertNotSame((Object)testDate, (Object)copyDate);
        ParameterUtilTest.assertEquals((Object)testDate, (Object)copyDate);
        TestParameter parameter = new TestParameter();
        TestParameter copyParameter = (TestParameter)ParameterUtil.copyParameter(parameter);
        ParameterUtilTest.assertSame((Object)parameter, (Object)copyParameter);
    }

    public static class TestParameter
    implements Cloneable {
        public Object clone() throws CloneNotSupportedException {
            throw new RuntimeException("OOPPSS");
        }
    }
}

