/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.jdbc;

import com.mockrunner.jdbc.StringValuesTable;
import junit.framework.TestCase;

public class StringValuesTableTest
extends TestCase {
    private StringValuesTable stringValuesTable;
    private String tableName;
    private String[] columnNames;
    private String[][] stringMatrix;

    public void setUp() throws Exception {
        super.setUp();
        this.tableName = "initech-employees";
        this.columnNames = new String[]{"id", "name", "address"};
        this.stringMatrix = new String[][]{{"1", "gibbons", "peter"}, {"2", "lumbergh", "bill"}, {"3", "waddams", "milton"}};
        this.stringValuesTable = new StringValuesTable(this.tableName, this.columnNames, this.stringMatrix);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.columnNames = null;
        this.stringMatrix = null;
        this.stringValuesTable = null;
    }

    public void testConstructors() throws Exception {
        try {
            this.stringValuesTable = new StringValuesTable(null, this.columnNames, this.stringMatrix);
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.stringValuesTable = new StringValuesTable("", this.columnNames, this.stringMatrix);
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.stringValuesTable = new StringValuesTable(" ", this.columnNames, this.stringMatrix);
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.stringValuesTable = new StringValuesTable(this.tableName, this.columnNames, null);
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.stringValuesTable = new StringValuesTable(this.tableName, new String[]{"id", null, "lastname"}, this.stringMatrix);
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.stringValuesTable = new StringValuesTable(this.tableName, new String[]{"id", "lastname"}, this.stringMatrix);
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.stringValuesTable = new StringValuesTable(this.tableName, new String[]{"id", "id", "lastname"}, this.stringMatrix);
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.stringValuesTable = new StringValuesTable(this.tableName, this.columnNames, new String[][]{{"1", "gibbons", "peter"}, {"2", "lumbergh"}, {"3", "waddams", "milton"}});
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.stringValuesTable = new StringValuesTable(this.tableName, null, new String[][]{{"1", "gibbons", "peter"}, {"2", "lumbergh"}, {"3", "waddams", "milton"}});
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.stringValuesTable = new StringValuesTable(this.tableName, this.columnNames, new String[][]{{"1", "gibbons", "peter"}, {"2", "lumbergh", null}, {"3", "waddams", "milton"}});
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.stringValuesTable = new StringValuesTable(this.tableName, null, new String[][]{{"1", "gibbons", "peter"}, {"2", "lumbergh", null}, {"3", "waddams", "milton"}});
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.stringValuesTable = new StringValuesTable(this.tableName, null, new String[0][0]);
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetColumnByName() throws Exception {
        try {
            this.stringValuesTable.getColumn(null);
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.stringValuesTable.getColumn("");
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        for (int column = 0; column < this.columnNames.length; ++column) {
            String[] values = this.stringValuesTable.getColumn(this.columnNames[column]);
            for (int row = 0; row < values.length; ++row) {
                StringValuesTableTest.assertEquals((String)values[row], (String)this.stringMatrix[row][column]);
            }
        }
        this.stringValuesTable = new StringValuesTable(this.tableName, null, this.stringMatrix);
        try {
            this.stringValuesTable.getColumn("id");
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        this.stringValuesTable = new StringValuesTable(this.tableName, this.stringMatrix);
        try {
            this.stringValuesTable.getColumn("id");
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetColumnByNumber() throws Exception {
        try {
            this.stringValuesTable.getColumn(0);
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.stringValuesTable.getColumn(-1);
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.stringValuesTable.getColumn(this.columnNames.length + 1);
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        for (int column = 1; column <= this.columnNames.length; ++column) {
            String[] values = this.stringValuesTable.getColumn(column);
            for (int row = 0; row < values.length; ++row) {
                StringValuesTableTest.assertEquals((String)values[row], (String)this.stringMatrix[row][column - 1]);
            }
        }
    }

    public void testGetColumnNames() throws Exception {
        String[] columnNames = this.stringValuesTable.getColumnNames();
        StringValuesTableTest.assertEquals((int)columnNames.length, (int)columnNames.length);
        for (int i = 0; i < columnNames.length; ++i) {
            StringValuesTableTest.assertEquals((String)columnNames[i], (String)columnNames[i]);
        }
        this.stringValuesTable = new StringValuesTable(this.tableName, null, this.stringMatrix);
        StringValuesTableTest.assertTrue((this.stringValuesTable.getColumnNames().length == 0 ? 1 : 0) != 0);
        this.stringValuesTable = new StringValuesTable(this.tableName, this.stringMatrix);
        StringValuesTableTest.assertTrue((this.stringValuesTable.getColumnNames().length == 0 ? 1 : 0) != 0);
    }

    public void testGetItemColumnName() throws Exception {
        try {
            this.stringValuesTable.getItem(1, null);
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.stringValuesTable.getItem(1, "");
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.stringValuesTable.getItem(-1, this.columnNames[0]);
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        for (int row = 1; row <= this.stringMatrix.length; ++row) {
            for (int column = 1; column <= this.columnNames.length; ++column) {
                StringValuesTableTest.assertEquals((String)this.stringMatrix[row - 1][column - 1], (String)this.stringValuesTable.getItem(row, this.columnNames[column - 1]));
            }
        }
    }

    public void testGetItemColumnNumber() throws Exception {
        try {
            this.stringValuesTable.getItem(1, -1);
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.stringValuesTable.getItem(1, 0);
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.stringValuesTable.getItem(-1, 1);
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        for (int row = 1; row <= this.stringMatrix.length; ++row) {
            for (int column = 1; column <= this.columnNames.length; ++column) {
                StringValuesTableTest.assertEquals((String)this.stringMatrix[row - 1][column - 1], (String)this.stringValuesTable.getItem(row, column));
            }
        }
    }

    public void testGetName() throws Exception {
        StringValuesTableTest.assertEquals((String)this.tableName, (String)this.stringValuesTable.getName());
    }

    public void testGetNumberOfColumns() throws Exception {
        StringValuesTableTest.assertEquals((int)this.columnNames.length, (int)this.stringValuesTable.getNumberOfColumns());
        this.stringValuesTable = new StringValuesTable(this.tableName, null, this.stringMatrix);
        StringValuesTableTest.assertEquals((int)this.stringMatrix[0].length, (int)this.stringValuesTable.getNumberOfColumns());
        this.stringValuesTable = new StringValuesTable(this.tableName, this.stringMatrix);
        StringValuesTableTest.assertEquals((int)this.stringMatrix[0].length, (int)this.stringValuesTable.getNumberOfColumns());
    }

    public void testGetNumberOfRows() throws Exception {
        StringValuesTableTest.assertEquals((int)this.stringMatrix.length, (int)this.stringValuesTable.getNumberOfRows());
    }

    public void testGetRow() throws Exception {
        try {
            this.stringValuesTable.getRow(0);
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.stringValuesTable.getRow(-1);
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.stringValuesTable.getColumn(this.stringMatrix.length + 1);
            StringValuesTableTest.fail((String)"an IllegalArgumentException should have thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        for (int row = 1; row <= this.stringMatrix.length; ++row) {
            String[] values = this.stringValuesTable.getRow(row);
            for (int column = 0; column < values.length; ++column) {
                StringValuesTableTest.assertEquals((String)this.stringMatrix[row - 1][column], (String)values[column]);
            }
        }
    }

    public void testIsValidColumnName() throws Exception {
        StringValuesTableTest.assertFalse((boolean)this.stringValuesTable.isValidColumnName(null));
        StringValuesTableTest.assertFalse((boolean)this.stringValuesTable.isValidColumnName(""));
        StringValuesTableTest.assertFalse((boolean)this.stringValuesTable.isValidColumnName(this.columnNames[0] + "foo"));
        for (int ii = 0; ii < this.columnNames.length; ++ii) {
            StringValuesTableTest.assertTrue((boolean)this.stringValuesTable.isValidColumnName(this.columnNames[ii]));
        }
    }

    public void testIsValidColumnNumber() throws Exception {
        StringValuesTableTest.assertFalse((boolean)this.stringValuesTable.isValidColumnNumber(0));
        StringValuesTableTest.assertFalse((boolean)this.stringValuesTable.isValidColumnNumber(-1));
        StringValuesTableTest.assertFalse((boolean)this.stringValuesTable.isValidColumnNumber(this.columnNames.length + 1));
        for (int ii = 1; ii <= this.stringValuesTable.getColumnNames().length; ++ii) {
            StringValuesTableTest.assertTrue((boolean)this.stringValuesTable.isValidColumnNumber(ii));
        }
    }

    public void testIsValidRowNumber() throws Exception {
        StringValuesTableTest.assertFalse((boolean)this.stringValuesTable.isValidRowNumber(0));
        StringValuesTableTest.assertFalse((boolean)this.stringValuesTable.isValidRowNumber(-1));
        StringValuesTableTest.assertFalse((boolean)this.stringValuesTable.isValidRowNumber(this.stringMatrix.length + 1));
        for (int ii = 1; ii <= this.stringValuesTable.getNumberOfRows(); ++ii) {
            StringValuesTableTest.assertTrue((boolean)this.stringValuesTable.isValidRowNumber(ii));
        }
    }
}

