/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.jdbc.CallableStatementResultSetHandler;
import com.mockrunner.jdbc.PreparedStatementResultSetHandler;
import com.mockrunner.jdbc.StatementResultSetHandler;
import com.mockrunner.mock.jdbc.MockArray;
import com.mockrunner.mock.jdbc.MockBlob;
import com.mockrunner.mock.jdbc.MockCallableStatement;
import com.mockrunner.mock.jdbc.MockClob;
import com.mockrunner.mock.jdbc.MockDatabaseMetaData;
import com.mockrunner.mock.jdbc.MockNClob;
import com.mockrunner.mock.jdbc.MockPreparedStatement;
import com.mockrunner.mock.jdbc.MockSQLXML;
import com.mockrunner.mock.jdbc.MockSavepoint;
import com.mockrunner.mock.jdbc.MockStatement;
import com.mockrunner.mock.jdbc.MockStruct;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class MockConnection
implements Connection {
    private StatementResultSetHandler statementHandler;
    private PreparedStatementResultSetHandler preparedStatementHandler;
    private CallableStatementResultSetHandler callableStatementHandler;
    private DatabaseMetaData metaData;
    private Map<Integer, MockSavepoint> savepoints;
    private int savepointCount;
    private boolean closed;
    private boolean autoCommit;
    private boolean readOnly;
    private int holdability;
    private int level;
    private Map<String, Class<?>> typeMap = Collections.EMPTY_MAP;
    private String catalog;
    private String schema;
    private int numberCommits;
    private int numberRollbacks;
    private Properties clientInfo;
    private int networkTimeout;

    public MockConnection() {
        this(new StatementResultSetHandler(), new PreparedStatementResultSetHandler(), new CallableStatementResultSetHandler());
    }

    public MockConnection(StatementResultSetHandler statementHandler, PreparedStatementResultSetHandler preparedStatementHandler, CallableStatementResultSetHandler callableStatementHandler) {
        this.statementHandler = statementHandler;
        this.preparedStatementHandler = preparedStatementHandler;
        this.callableStatementHandler = callableStatementHandler;
        this.metaData = new MockDatabaseMetaData();
        ((MockDatabaseMetaData)this.metaData).setConnection(this);
        this.closed = false;
        this.autoCommit = false;
        this.readOnly = false;
        this.holdability = 1;
        try {
            this.level = this.metaData.getDefaultTransactionIsolation();
        }
        catch (SQLException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
        this.savepointCount = 0;
        this.catalog = null;
        this.numberCommits = 0;
        this.numberRollbacks = 0;
        this.clientInfo = new Properties();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.networkTimeout = milliseconds;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.networkTimeout;
    }

    public void setMetaData(DatabaseMetaData metaData) throws SQLException {
        if (metaData != null && metaData instanceof MockDatabaseMetaData) {
            ((MockDatabaseMetaData)metaData).setConnection(this);
        }
        this.metaData = metaData;
    }

    public int getNumberCommits() {
        return this.numberCommits;
    }

    public int getNumberRollbacks() {
        return this.numberRollbacks;
    }

    public Map<Integer, MockSavepoint> getSavepointMap() {
        if (this.savepoints == null) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(this.savepoints);
    }

    public void resetNumberCommits() {
        this.numberCommits = 0;
    }

    public void resetNumberRollbacks() {
        this.numberRollbacks = 0;
    }

    public void resetSavepointMap() {
        if (this.savepoints != null) {
            this.savepoints.clear();
        }
    }

    public StatementResultSetHandler getStatementResultSetHandler() {
        return this.statementHandler;
    }

    public PreparedStatementResultSetHandler getPreparedStatementResultSetHandler() {
        return this.preparedStatementHandler;
    }

    public CallableStatementResultSetHandler getCallableStatementResultSetHandler() {
        return this.callableStatementHandler;
    }

    @Override
    public Statement createStatement() throws SQLException {
        MockStatement statement = new MockStatement(this);
        this.getStatementResultSetHandler().addStatement(statement);
        return statement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        MockStatement statement = new MockStatement(this, resultSetType, resultSetConcurrency);
        this.getStatementResultSetHandler().addStatement(statement);
        return statement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        MockStatement statement = new MockStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.getStatementResultSetHandler().addStatement(statement);
        return statement;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        MockCallableStatement statement = new MockCallableStatement(this, sql);
        this.getCallableStatementResultSetHandler().addCallableStatement(statement);
        return statement;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        MockCallableStatement statement = new MockCallableStatement((Connection)this, sql, resultSetType, resultSetConcurrency);
        this.getCallableStatementResultSetHandler().addCallableStatement(statement);
        return statement;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        MockCallableStatement statement = new MockCallableStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.getCallableStatementResultSetHandler().addCallableStatement(statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        MockPreparedStatement statement = new MockPreparedStatement(this, sql);
        this.getPreparedStatementResultSetHandler().addPreparedStatement(statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        MockPreparedStatement statement = new MockPreparedStatement((Connection)this, sql, resultSetType, resultSetConcurrency);
        this.getPreparedStatementResultSetHandler().addPreparedStatement(statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        MockPreparedStatement statement = new MockPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.getPreparedStatementResultSetHandler().addPreparedStatement(statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.verifyAutoGeneratedKeysParameter(autoGeneratedKeys);
        MockPreparedStatement statement = new MockPreparedStatement((Connection)this, sql, autoGeneratedKeys == 1);
        this.getPreparedStatementResultSetHandler().addPreparedStatement(statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql, 1);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return new MockBlob(new byte[0]);
    }

    @Override
    public Clob createClob() throws SQLException {
        return new MockClob("");
    }

    @Override
    public NClob createNClob() throws SQLException {
        return new MockNClob("");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return new MockSQLXML();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        MockArray array = new MockArray(elements);
        array.setBaseTypeName(typeName);
        return array;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return new MockStruct(typeName, attributes);
    }

    private void verifyAutoGeneratedKeysParameter(int autoGeneratedKeys) throws SQLException {
        if (1 != autoGeneratedKeys && 2 != autoGeneratedKeys) {
            throw new SQLException("autoGeneratedKeys must be either Statement.RETURN_GENERATED_KEYS or Statement.NO_GENERATED_KEYS");
        }
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.catalog;
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.holdability;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.level;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.typeMap;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.clientInfo);
        return properties;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.clientInfo.getProperty(name);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return !this.isClosed();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.catalog = catalog;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.holdability = holdability;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.setSavepoint("");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        if (this.savepoints == null) {
            this.savepoints = new HashMap<Integer, MockSavepoint>();
        }
        MockSavepoint savePoint = new MockSavepoint(name, this.savepointCount);
        this.savepoints.put(savePoint.getSavepointId(), savePoint);
        ++this.savepointCount;
        return savePoint;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.level = level;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> typeMap) throws SQLException {
        this.typeMap = typeMap;
    }

    @Override
    public void setClientInfo(Properties properties) {
        this.clientInfo.clear();
        this.clientInfo.putAll((Map<?, ?>)properties);
    }

    @Override
    public void setClientInfo(String name, String value) {
        this.clientInfo.setProperty(name, value);
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (this.savepoints == null) {
            throw new SQLException("No savepoints set!");
        }
        MockSavepoint currentSavepoint = this.savepoints.get(savepoint.getSavepointId());
        if (currentSavepoint.isReleased()) {
            throw new SQLException("Savepoint with id " + currentSavepoint.getSavepointId() + " and name " + currentSavepoint.getSavepointName() + " is released");
        }
        currentSavepoint.setReleased(true);
    }

    @Override
    public void commit() throws SQLException {
        ++this.numberCommits;
    }

    @Override
    public void rollback() throws SQLException {
        ++this.numberRollbacks;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.savepoints == null) {
            throw new SQLException("No savepoints set!");
        }
        MockSavepoint currentSavepoint = this.savepoints.get(savepoint.getSavepointId());
        if (currentSavepoint.isReleased()) {
            throw new SQLException("Savepoint with id " + currentSavepoint.getSavepointId() + " and name " + currentSavepoint.getSavepointName() + " is released");
        }
        currentSavepoint.setRolledBack(true);
        ++this.numberRollbacks;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("No object found for " + iface);
    }
}

