/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.xlsx.impl;

import com.monitorjbl.xlsx.exceptions.NotSupportedException;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class StreamingCell
implements Cell {
    public static final String NUMERIC_REGEX = "-?\\d+(\\.\\d+)?";
    private int columnIndex;
    private int rowIndex;
    private Object contents;
    private Row row;

    public StreamingCell(int columnIndex, int rowIndex) {
        this.columnIndex = columnIndex;
        this.rowIndex = rowIndex;
    }

    public Object getContents() {
        return this.contents;
    }

    public void setContents(Object contents) {
        this.contents = contents;
    }

    public void setRow(Row row) {
        this.row = row;
    }

    static boolean isNumeric(String str) {
        return str.matches(NUMERIC_REGEX);
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public Row getRow() {
        return this.row;
    }

    public int getCellType() {
        if (this.contents == null) {
            return 3;
        }
        if (StreamingCell.isNumeric(this.contents.toString())) {
            return 0;
        }
        return 1;
    }

    public String getStringCellValue() {
        return (String)this.contents;
    }

    public double getNumericCellValue() {
        return Double.parseDouble((String)this.contents);
    }

    public Date getDateCellValue() {
        return HSSFDateUtil.getJavaDate((double)this.getNumericCellValue());
    }

    public void setCellType(int cellType) {
        throw new NotSupportedException();
    }

    public Sheet getSheet() {
        throw new NotSupportedException();
    }

    public int getCachedFormulaResultType() {
        throw new NotSupportedException();
    }

    public void setCellValue(double value) {
        throw new NotSupportedException();
    }

    public void setCellValue(Date value) {
        throw new NotSupportedException();
    }

    public void setCellValue(Calendar value) {
        throw new NotSupportedException();
    }

    public void setCellValue(RichTextString value) {
        throw new NotSupportedException();
    }

    public void setCellValue(String value) {
        throw new NotSupportedException();
    }

    public void setCellFormula(String formula) throws FormulaParseException {
        throw new NotSupportedException();
    }

    public String getCellFormula() {
        throw new NotSupportedException();
    }

    public RichTextString getRichStringCellValue() {
        throw new NotSupportedException();
    }

    public void setCellValue(boolean value) {
        throw new NotSupportedException();
    }

    public void setCellErrorValue(byte value) {
        throw new NotSupportedException();
    }

    public boolean getBooleanCellValue() {
        return false;
    }

    public byte getErrorCellValue() {
        throw new NotSupportedException();
    }

    public void setCellStyle(CellStyle style) {
        throw new NotSupportedException();
    }

    public CellStyle getCellStyle() {
        throw new NotSupportedException();
    }

    public void setAsActiveCell() {
        throw new NotSupportedException();
    }

    public void setCellComment(Comment comment) {
        throw new NotSupportedException();
    }

    public Comment getCellComment() {
        throw new NotSupportedException();
    }

    public void removeCellComment() {
        throw new NotSupportedException();
    }

    public Hyperlink getHyperlink() {
        throw new NotSupportedException();
    }

    public void setHyperlink(Hyperlink link) {
        throw new NotSupportedException();
    }

    public CellRangeAddress getArrayFormulaRange() {
        throw new NotSupportedException();
    }

    public boolean isPartOfArrayFormulaGroup() {
        throw new NotSupportedException();
    }
}

