/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.url;

import com.networknt.url.QueryString;
import com.networknt.utility.CharUtils;
import com.networknt.utility.RegExUtils;
import com.networknt.utility.StringUtils;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;

public class HttpURL
implements Serializable {
    private static final long serialVersionUID = -8886393027925815099L;
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final int DEFAULT_HTTPS_PORT = 443;
    public static final String PROTOCOL_HTTP = "http";
    public static final String PROTOCOL_HTTPS = "https";
    private QueryString queryString;
    private String host;
    private int port = -1;
    private String path;
    private String protocol;
    private final String encoding;
    private String fragment;

    public HttpURL() {
        this("", null);
    }

    public HttpURL(URL url) {
        this(url.toString());
    }

    public HttpURL(String url) {
        this(url, null);
    }

    public HttpURL(URL url, String encoding) {
        this(url.toString(), encoding);
    }

    public HttpURL(String url, String encoding) {
        this.encoding = StringUtils.isBlank((CharSequence)encoding) ? StandardCharsets.UTF_8.toString() : encoding;
        String u = StringUtils.trimToEmpty((String)url);
        if (u.matches("[a-zA-Z][a-zA-Z0-9\\+\\-\\.]*:.*")) {
            URL urlwrap;
            try {
                urlwrap = new URL(u);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Could not interpret URL: " + u, e);
            }
            this.protocol = StringUtils.substringBefore((String)u, (String)":");
            this.host = urlwrap.getHost();
            this.port = urlwrap.getPort();
            if (this.port < 0) {
                if (u.toLowerCase().startsWith(PROTOCOL_HTTPS)) {
                    this.port = 443;
                } else if (u.toLowerCase().startsWith(PROTOCOL_HTTP)) {
                    this.port = 80;
                }
            }
            this.path = urlwrap.getPath();
            this.fragment = urlwrap.getRef();
        } else {
            this.path = u.replaceFirst("^(.*?)([\\?\\#])(.*)", "$1");
            if (u.contains("#")) {
                this.fragment = u.replaceFirst("^(.*?)(\\#)(.*)", "$3");
            }
        }
        if (u.contains("?")) {
            this.queryString = new QueryString(u, encoding);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public QueryString getQueryString() {
        return this.queryString;
    }

    public void setQueryString(QueryString queryString) {
        this.queryString = queryString;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public boolean isSecure() {
        return this.getProtocol().equalsIgnoreCase(PROTOCOL_HTTPS);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getFragment() {
        return this.fragment;
    }

    public void setFragment(String fragment) {
        this.fragment = fragment;
    }

    public String getLastPathSegment() {
        if (StringUtils.isBlank((CharSequence)this.path)) {
            return "";
        }
        String segment = this.path;
        segment = StringUtils.substringAfterLast((String)segment, (String)"/");
        return segment;
    }

    public URL toURL() {
        String url = this.toString();
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot convert to URL: " + url, e);
        }
    }

    public String getRoot() {
        return HttpURL.getRoot(this.toString());
    }

    public URI toURI() {
        String url = this.toString();
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Cannot convert to URI: " + url, e);
        }
    }

    public static URL toURL(String url) {
        return new HttpURL(url).toURL();
    }

    public static URI toURI(String url) {
        return new HttpURL(url).toURI();
    }

    public static String getRoot(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        return RegExUtils.replacePattern((String)url, (String)"(.*?://.*?)([/?#].*)", (String)"$1");
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.protocol)) {
            b.append(this.protocol);
            b.append("://");
        }
        if (StringUtils.isNotBlank((CharSequence)this.host)) {
            b.append(this.host);
        }
        if (!this.isPortDefault() && this.port != -1) {
            b.append(':');
            b.append(this.port);
        }
        if (StringUtils.isNotBlank((CharSequence)this.path)) {
            if (b.length() > 0 && !this.path.startsWith("/")) {
                b.append('/');
            }
            b.append(HttpURL.encodePath(this.path));
        }
        if (this.queryString != null && !this.queryString.isEmpty()) {
            b.append(this.queryString.toString());
        }
        if (this.fragment != null) {
            b.append("#");
            b.append(HttpURL.encodePath(this.fragment));
        }
        return b.toString();
    }

    public boolean isPortDefault() {
        return PROTOCOL_HTTPS.equalsIgnoreCase(this.protocol) && this.port == 443 || PROTOCOL_HTTP.equalsIgnoreCase(this.protocol) && this.port == 80;
    }

    public static String encodeQueryString(String queryString) {
        if (StringUtils.isBlank((CharSequence)queryString)) {
            return queryString;
        }
        return new QueryString(queryString).toString();
    }

    public static String encodePath(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return path;
        }
        StringBuilder sb = new StringBuilder();
        for (char ch : path.toCharArray()) {
            byte[] bytes;
            if (ch == ' ') {
                sb.append("%20");
                continue;
            }
            if (CharUtils.isAsciiAlphanumeric((char)ch) || ".-_~!$&'()*+,;=:@/%".indexOf(ch) != -1) {
                sb.append(ch);
                continue;
            }
            for (byte b : bytes = Character.toString(ch).getBytes(StandardCharsets.UTF_8)) {
                sb.append('%');
                int upper = b >> 4 & 0xF;
                sb.append(Integer.toHexString(upper).toUpperCase(Locale.US));
                int lower = b & 0xF;
                sb.append(Integer.toHexString(lower).toUpperCase(Locale.US));
            }
        }
        return sb.toString();
    }

    public static String toAbsolute(String baseURL, String relativeURL) {
        String relURL = relativeURL;
        if (relURL.startsWith("//")) {
            return StringUtils.substringBefore((String)baseURL, (String)"//") + "//" + StringUtils.substringAfter((String)relURL, (String)"//");
        }
        if (relURL.startsWith("/")) {
            return HttpURL.getRoot(baseURL) + relURL;
        }
        if (relURL.startsWith("?") || relURL.startsWith("#")) {
            return baseURL.replaceFirst("(.*?)([\\?\\#])(.*)", "$1") + relURL;
        }
        if (!relURL.contains("://")) {
            String base = baseURL.replaceFirst("(.*?)([\\?\\#])(.*)", "$1");
            if (StringUtils.countMatches((CharSequence)base, (char)'/') > 2) {
                base = base.replaceFirst("(.*/)(.*)", "$1");
            }
            relURL = base.endsWith("/") ? base + relURL : base + "/" + relURL;
        }
        return relURL;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpURL httpURL = (HttpURL)o;
        return this.port == httpURL.port && Objects.equals(this.host, httpURL.host) && Objects.equals(this.path, httpURL.path) && Objects.equals(this.protocol, httpURL.protocol) && Objects.equals(this.encoding, httpURL.encoding) && Objects.equals(this.fragment, httpURL.fragment);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.path, this.protocol, this.encoding, this.fragment);
    }
}

