/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.networknt.jsonoverlay.Builder;
import com.networknt.jsonoverlay.IJsonOverlay;
import com.networknt.jsonoverlay.MinSharingJsonNodeFactory;
import com.networknt.jsonoverlay.OverlayFactory;
import com.networknt.jsonoverlay.PositionInfo;
import com.networknt.jsonoverlay.RefOverlay;
import com.networknt.jsonoverlay.Reference;
import com.networknt.jsonoverlay.ReferenceManager;
import com.networknt.jsonoverlay.SerializationOptions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;

public abstract class JsonOverlay<V>
implements IJsonOverlay<V> {
    protected static final ObjectMapper mapper = new ObjectMapper();
    protected V value = null;
    protected JsonOverlay<?> parent;
    protected JsonNode json;
    protected final ReferenceManager refMgr;
    protected final OverlayFactory<V> factory;
    private String pathInParent = null;
    private boolean present;
    private RefOverlay<V> refOverlay = null;
    private Reference creatingRef = null;
    private Optional<PositionInfo> positionInfo = null;
    private static JsonNodeFactory fac = MinSharingJsonNodeFactory.instance;

    protected JsonOverlay(V value, JsonOverlay<?> parent, OverlayFactory<V> factory, ReferenceManager refMgr) {
        this.json = null;
        this.value = value;
        this.parent = parent;
        this.factory = factory;
        this.refMgr = refMgr;
        this.present = value != null;
    }

    protected JsonOverlay(JsonNode json, JsonOverlay<?> parent, OverlayFactory<V> factory, ReferenceManager refMgr) {
        this.json = json;
        if (Reference.isReferenceNode(json)) {
            this.refOverlay = new RefOverlay<V>(json, parent, factory, refMgr);
        } else {
            this.value = this._fromJson(json);
        }
        this.parent = parent;
        this.factory = factory;
        this.refMgr = refMgr;
        this.present = !json.isMissingNode();
    }

    public JsonOverlay<V> create() {
        return this.builder().build();
    }

    public Builder<V> builder() {
        return new Builder(this._getFactory(), this);
    }

    V _get() {
        return this._get(true);
    }

    V _get(boolean elaborate) {
        if (this._isValidRef()) {
            return this.refOverlay._get(elaborate);
        }
        if (this._isReference()) {
            return null;
        }
        if (elaborate) {
            this._ensureElaborated();
        }
        return this.value;
    }

    void _set(V value) {
        this.value = value;
        this.present = value != null;
        this.refOverlay = null;
    }

    JsonOverlay<V> _copy() {
        return this.factory.create(this._get(), null, this.refMgr);
    }

    boolean _isReference() {
        return this.refOverlay != null;
    }

    private boolean _isValidRef() {
        return this.refOverlay != null ? this.refOverlay._getReference().isValid() : false;
    }

    RefOverlay<V> _getRefOverlay() {
        return this.refOverlay;
    }

    Reference _getReference() {
        return this.refOverlay != null ? this.refOverlay._getReference() : null;
    }

    void _setReference(RefOverlay<V> refOverlay) {
        this.refOverlay = refOverlay;
    }

    public Reference _getCreatingRef() {
        return this.creatingRef;
    }

    public void _setCreatingRef(Reference creatingRef) {
        this.creatingRef = creatingRef;
    }

    boolean _isPresent() {
        return (this._isValidRef() ? this.refOverlay.getOverlay() : this).present;
    }

    JsonOverlay<?> _getParent() {
        return this._getParent(true);
    }

    JsonOverlay<?> _getParent(boolean followRef) {
        return (followRef && this._isValidRef() ? this.refOverlay.getOverlay() : this).parent;
    }

    JsonOverlay<?> _getRoot() {
        if (this._isValidRef()) {
            return this.refOverlay.getOverlay()._getRoot();
        }
        JsonOverlay<?> result = this;
        while (result._getParent() != null) {
            result = result._getParent();
        }
        return result;
    }

    JsonOverlay<?> _getModel() {
        if (this._isValidRef()) {
            return this.refOverlay.getOverlay()._getModel();
        }
        JsonOverlay<?> modelPart = this._getModelType() != null ? this : null;
        JsonOverlay<?> result = this;
        while (result._getParent() != null) {
            result = result._getParent();
            modelPart = modelPart == null && result._getModelType() != null ? result : null;
        }
        return modelPart != null && modelPart._getModelType().isAssignableFrom(result.getClass()) ? result : null;
    }

    protected Class<?> _getModelType() {
        return this._isValidRef() ? this.refOverlay.getOverlay()._getModelType() : null;
    }

    JsonOverlay<?> _find(JsonPointer path) {
        return path.matches() ? this.thisOrRefTarget() : this._findInternal(path);
    }

    JsonOverlay<?> _find(String path) {
        return this._find(JsonPointer.compile((String)path));
    }

    protected abstract JsonOverlay<?> _findInternal(JsonPointer var1);

    String _getPathFromRoot() {
        if (this.parent != null) {
            if (this.pathInParent.isEmpty()) {
                return this.parent._getPathFromRoot();
            }
            String parentPath = this.parent._getPathFromRoot();
            return parentPath != null ? parentPath + "/" + this.encodePointerPart(this.pathInParent) : null;
        }
        if (this.creatingRef != null) {
            return this.creatingRef.getFragment();
        }
        return null;
    }

    private String encodePointerPart(String part) {
        if (part.startsWith("components/")) {
            return part;
        }
        return part.replaceAll("~", "~0").replaceAll("/", "~1");
    }

    String _getJsonReference() {
        return this._getJsonReference(false);
    }

    String _getJsonReference(boolean forRef) {
        if (this.creatingRef != null) {
            return this.creatingRef.getNormalizedRef();
        }
        if (this._isReference() && this.refOverlay._getReference().isValid() && !forRef) {
            return this.refOverlay.getOverlay()._getJsonReference(false);
        }
        if (this.parent != null) {
            String ref = this.parent._getJsonReference();
            return ref + (ref.contains("#") ? "" : "#") + "/" + this.pathInParent;
        }
        return "#";
    }

    String _getDocumentUrl(boolean forRef) {
        String jsonRef = this._getJsonReference(forRef);
        String docUrl = jsonRef.contains("#") ? jsonRef.substring(0, jsonRef.indexOf("#")) : jsonRef;
        return docUrl.isEmpty() ? null : docUrl;
    }

    protected abstract V _fromJson(JsonNode var1);

    protected void _setParent(JsonOverlay<?> parent) {
        this.parent = parent;
    }

    JsonNode _toJson() {
        return this._toJson(SerializationOptions.EMPTY);
    }

    JsonNode _toJson(SerializationOptions options) {
        if (this._isReference()) {
            if (!options.isFollowRefs() || this.refOverlay._getReference().isInvalid()) {
                ObjectNode obj = JsonOverlay._jsonObject();
                obj.put("$ref", this.refOverlay._getReference().getRefString());
                return obj;
            }
            return this.refOverlay.getOverlay()._toJson(options);
        }
        return this._toJsonInternal(options);
    }

    JsonNode _toJson(SerializationOptions.Option ... options) {
        return this._toJson(new SerializationOptions(options));
    }

    protected abstract JsonNode _toJsonInternal(SerializationOptions var1);

    JsonNode _getParsedJson() {
        return this.json;
    }

    private JsonOverlay<V> thisOrRefTarget() {
        if (this.refOverlay == null || this.refOverlay._getReference().isInvalid()) {
            return this;
        }
        return this.refOverlay.getOverlay();
    }

    protected void _elaborate(boolean atCreation) {
    }

    protected boolean _isElaborated() {
        return true;
    }

    protected void _ensureElaborated() {
        if (!this._isElaborated() && this.refOverlay == null) {
            this._elaborate(false);
        }
    }

    String _getPathInParent() {
        return this.pathInParent;
    }

    void _setPathInParent(String pathInParent) {
        this.pathInParent = pathInParent;
    }

    Optional<PositionInfo> _getPositionInfo() {
        if (this.positionInfo == null) {
            JsonPointer ptr = JsonPointer.compile((String)this._getPathFromRoot());
            this.positionInfo = this.refMgr.getPositionInfo(ptr);
            this.positionInfo.ifPresent(info -> info.setDocumentUrl(this._getDocumentUrl(true)));
        }
        return this.positionInfo;
    }

    protected abstract OverlayFactory<?> _getFactory();

    public String toString() {
        return this._toJson().toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JsonOverlay) {
            JsonOverlay castObj = (JsonOverlay)obj;
            return this.value != null ? this.value.equals(castObj.value) : castObj.value == null;
        }
        return false;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    protected static ObjectNode _jsonObject() {
        return fac.objectNode();
    }

    protected static ArrayNode _jsonArray() {
        return fac.arrayNode();
    }

    protected static TextNode _jsonScalar(String s) {
        return fac.textNode(s);
    }

    protected static ValueNode _jsonScalar(int n) {
        return fac.numberNode(n);
    }

    protected static ValueNode _jsonScalar(long n) {
        return fac.numberNode(n);
    }

    protected static ValueNode _jsonScalar(short n) {
        return fac.numberNode(n);
    }

    protected static ValueNode _jsonScalar(byte n) {
        return fac.numberNode(n);
    }

    protected static ValueNode _jsonScalar(double n) {
        return fac.numberNode(n);
    }

    protected static ValueNode _jsonScalar(float n) {
        return fac.numberNode(n);
    }

    protected static ValueNode _jsonScalar(BigInteger n) {
        return fac.numberNode(n);
    }

    protected static ValueNode _jsonScalar(BigDecimal n) {
        return fac.numberNode(n);
    }

    protected static ValueNode _jsonBoolean(boolean b) {
        return fac.booleanNode(b);
    }

    protected static MissingNode _jsonMissing() {
        return MissingNode.getInstance();
    }

    protected static NullNode _jsonNull() {
        return fac.nullNode();
    }
}

