/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.jsonoverlay.JsonOverlay;
import com.networknt.jsonoverlay.OverlayFactory;
import com.networknt.jsonoverlay.ReferenceManager;
import com.networknt.jsonoverlay.SerializationOptions;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public final class MapOverlay<V>
extends JsonOverlay<Map<String, V>> {
    private final OverlayFactory<V> valueFactory;
    private final Pattern keyPattern;
    private Map<String, JsonOverlay<V>> overlays = new LinkedHashMap<String, JsonOverlay<V>>();
    private boolean elaborated = false;

    private MapOverlay(JsonNode json, JsonOverlay<?> parent, OverlayFactory<Map<String, V>> factory, ReferenceManager refMgr) {
        super(json, parent, factory, refMgr);
        MapOverlayFactory mapOverlayFactory = (MapOverlayFactory)factory;
        this.valueFactory = mapOverlayFactory.getValueFactory();
        String keyPattern = mapOverlayFactory.getKeyPattern();
        this.keyPattern = keyPattern != null ? Pattern.compile(keyPattern) : null;
    }

    private MapOverlay(Map<String, V> value, JsonOverlay<?> parent, OverlayFactory<Map<String, V>> factory, ReferenceManager refMgr) {
        super(new LinkedHashMap<String, V>(value), parent, factory, refMgr);
        MapOverlayFactory mapOverlayFactory = (MapOverlayFactory)factory;
        this.valueFactory = mapOverlayFactory.getValueFactory();
        String keyPattern = mapOverlayFactory.getKeyPattern();
        this.keyPattern = keyPattern != null ? Pattern.compile(keyPattern) : null;
    }

    @Override
    protected JsonOverlay<?> _findInternal(JsonPointer path) {
        String key = path.getMatchingProperty();
        return this.overlays.containsKey(key) ? this.overlays.get(key)._find(path.tail()) : null;
    }

    @Override
    protected Map<String, V> _fromJson(JsonNode json) {
        return new LinkedHashMap<String, V>(){
            private static final long serialVersionUID = 1L;

            public MapOverlay<V> getOverlay() {
                return MapOverlay.this;
            }
        };
    }

    @Override
    protected JsonNode _toJsonInternal(SerializationOptions options) {
        ObjectNode obj = MapOverlay._jsonObject();
        for (Map.Entry<String, JsonOverlay<V>> entry : this.overlays.entrySet()) {
            obj.set(entry.getKey(), entry.getValue()._toJson(options.minus(SerializationOptions.Option.KEEP_ONE_EMPTY)));
        }
        return obj.size() > 0 || options.isKeepThisEmpty() ? obj : MapOverlay._jsonMissing();
    }

    @Override
    protected boolean _isElaborated() {
        return this.elaborated;
    }

    @Override
    protected void _elaborate(boolean atCreation) {
        if (this.json != null) {
            this.fillWithJson();
        } else {
            this.fillWithValues();
        }
        this.elaborated = true;
    }

    private void fillWithJson() {
        ((Map)this.value).clear();
        this.overlays.clear();
        Iterator iter = this.json.fields();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (this.keyPattern != null && !this.keyPattern.matcher((CharSequence)entry.getKey()).matches()) continue;
            JsonOverlay<V> valOverlay = this.valueFactory.create((JsonNode)entry.getValue(), (JsonOverlay<?>)this, this.refMgr);
            this.overlays.put((String)entry.getKey(), (JsonOverlay<JsonOverlay<V>>)valOverlay);
            valOverlay._setPathInParent((String)entry.getKey());
            ((Map)this.value).put(entry.getKey(), valOverlay._get(false));
        }
    }

    private void fillWithValues() {
        this.overlays.clear();
        for (Map.Entry entry : ((Map)this.value).entrySet()) {
            JsonOverlay valOverlay = this.valueOverlayFor(entry.getValue());
            this.overlays.put((String)entry.getKey(), valOverlay);
            valOverlay._setPathInParent((String)entry.getKey());
        }
    }

    private JsonOverlay<V> valueOverlayFor(V val) {
        return this.valueFactory.create(val, this, this.refMgr);
    }

    public V get(String key) {
        JsonOverlay<V> valOverlay = this.overlays.get(key);
        return valOverlay != null ? (V)valOverlay._get() : null;
    }

    JsonOverlay<V> _getOverlay(String key) {
        return this.overlays.get(key);
    }

    public Set<String> keySet() {
        return ((Map)this.value).keySet();
    }

    public void set(String key, V val) {
        ((Map)this.value).put(key, val);
        this.overlays.put(key, this.valueOverlayFor(val));
    }

    public void remove(String key) {
        ((Map)this.value).remove(key);
        this.overlays.remove(key);
    }

    public int size() {
        return this.overlays.size();
    }

    @Override
    public boolean equals(Object obj) {
        return this.equals(obj, false);
    }

    public boolean equals(Object obj, boolean sameOrder) {
        if (obj instanceof MapOverlay) {
            MapOverlay castObj = (MapOverlay)obj;
            return this.overlays.equals(castObj.overlays) && (!sameOrder || this.checkOrder(castObj));
        }
        return false;
    }

    private boolean checkOrder(MapOverlay<?> other) {
        Iterator<String> myKeys = this.overlays.keySet().iterator();
        Iterator<String> theirKeys = other.overlays.keySet().iterator();
        while (myKeys.hasNext() && theirKeys.hasNext()) {
            if (myKeys.next().equals(theirKeys.next())) continue;
            return false;
        }
        return !myKeys.hasNext() && !theirKeys.hasNext();
    }

    @Override
    public int hashCode() {
        return this.overlays.hashCode();
    }

    public static <V> OverlayFactory<Map<String, V>> getFactory(OverlayFactory<V> valueFactory, String keyPattern) {
        return new MapOverlayFactory<V>(valueFactory, keyPattern);
    }

    @Override
    protected OverlayFactory<Map<String, V>> _getFactory() {
        return this.factory;
    }

    private static class MapOverlayFactory<V>
    extends OverlayFactory<Map<String, V>> {
        private final OverlayFactory<V> valueFactory;
        private final String keyPattern;

        public MapOverlayFactory(OverlayFactory<V> valueFactory, String keyPattern) {
            this.valueFactory = valueFactory;
            this.keyPattern = keyPattern;
        }

        @Override
        public String getSignature() {
            return String.format("map[%s|%s]", this.valueFactory.getSignature(), this.keyPattern != null ? this.keyPattern : "*");
        }

        @Override
        protected Class<? extends JsonOverlay<? super Map<String, V>>> getOverlayClass() {
            Class<MapOverlay> overlayClass;
            Class<MapOverlay> castClass = overlayClass = MapOverlay.class;
            return castClass;
        }

        @Override
        protected JsonOverlay<Map<String, V>> _create(Map<String, V> value, JsonOverlay<?> parent, ReferenceManager refMgr) {
            return new MapOverlay(value, parent, (OverlayFactory)this, refMgr);
        }

        @Override
        protected JsonOverlay<Map<String, V>> _create(JsonNode json, JsonOverlay<?> parent, ReferenceManager refMgr) {
            return new MapOverlay(json, parent, (OverlayFactory)this, refMgr);
        }

        public String getKeyPattern() {
            return this.keyPattern;
        }

        public OverlayFactory<V> getValueFactory() {
            return this.valueFactory;
        }
    }
}

