/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.PathType;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnevaluatedItemsValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(UnevaluatedItemsValidator.class);
    private final JsonSchema schema;
    private final boolean disabled;

    public UnevaluatedItemsValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.UNEVALUATED_ITEMS, validationContext);
        this.disabled = validationContext.getConfig().isUnevaluatedItemsAnalysisDisabled();
        if (!schemaNode.isObject() && !schemaNode.isBoolean()) {
            throw new IllegalArgumentException("The value of 'unevaluatedItems' MUST be a valid JSON Schema.");
        }
        this.schema = validationContext.newSchema(schemaPath, schemaNode, parentSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        if (this.disabled || !node.isArray()) {
            return Collections.emptySet();
        }
        UnevaluatedItemsValidator.debug(logger, node, rootNode, at);
        CollectorContext collectorContext = CollectorContext.getInstance();
        collectorContext.exitDynamicScope();
        try {
            Set<String> allPaths = this.allPaths(node, at);
            if (this.schemaNode.isBoolean() && this.schemaNode.asBoolean()) {
                collectorContext.getEvaluatedItems().addAll(allPaths);
                Set<ValidationMessage> set = Collections.emptySet();
                return set;
            }
            Set<String> unevaluatedPaths = UnevaluatedItemsValidator.unevaluatedPaths(allPaths);
            if (this.schemaNode.isBoolean() && !this.schemaNode.asBoolean() && !unevaluatedPaths.isEmpty()) {
                Set<ValidationMessage> set = this.reportUnevaluatedPaths(unevaluatedPaths);
                return set;
            }
            HashSet<String> failingPaths = new HashSet<String>();
            unevaluatedPaths.forEach(path -> {
                String pointer = this.getPathType().convertToJsonPointer((String)path);
                JsonNode property = rootNode.at(pointer);
                if (!this.schema.validate(property, rootNode, (String)path).isEmpty()) {
                    failingPaths.add((String)path);
                }
            });
            if (!failingPaths.isEmpty()) {
                Set<ValidationMessage> set = this.reportUnevaluatedPaths(failingPaths);
                return set;
            }
            collectorContext.getEvaluatedItems().addAll(allPaths);
            Set<ValidationMessage> set = Collections.emptySet();
            return set;
        }
        finally {
            collectorContext.enterDynamicScope();
        }
    }

    private Set<String> allPaths(JsonNode node, String at) {
        PathType pathType = this.getPathType();
        HashSet<String> collector = new HashSet<String>();
        int size = node.size();
        for (int i = 0; i < size; ++i) {
            String path = pathType.append(at, i);
            collector.add(path);
        }
        return collector;
    }

    private Set<ValidationMessage> reportUnevaluatedPaths(Set<String> unevaluatedPaths) {
        ArrayList<String> paths = new ArrayList<String>(unevaluatedPaths);
        paths.sort(String.CASE_INSENSITIVE_ORDER);
        return Collections.singleton(this.buildValidationMessage(String.join((CharSequence)"\n  ", paths), new String[0]));
    }

    private static Set<String> unevaluatedPaths(Set<String> allPaths) {
        HashSet<String> unevaluatedProperties = new HashSet<String>(allPaths);
        unevaluatedProperties.removeAll(CollectorContext.getInstance().getEvaluatedItems());
        return unevaluatedProperties;
    }
}

