/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jwt.proc;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.BadJWEException;
import com.nimbusds.jose.proc.BadJWSException;
import com.nimbusds.jose.proc.BaseJOSEProcessor;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.JWTClaimsVerifier;
import com.nimbusds.jwt.proc.JWTProcessor;
import java.security.Key;
import java.text.ParseException;
import java.util.List;
import java.util.ListIterator;

public class DefaultJWTProcessor<C extends SecurityContext>
extends BaseJOSEProcessor<C>
implements JWTProcessor<ReadOnlyJWTClaimsSet, C> {
    private JWTClaimsVerifier claimsVerifier;

    public JWTClaimsVerifier getJWTClaimsVerifier() {
        return this.claimsVerifier;
    }

    public void setJWTClaimsVerifier(JWTClaimsVerifier claimsVerifier) {
        this.claimsVerifier = claimsVerifier;
    }

    private ReadOnlyJWTClaimsSet verifyAndReturnClaims(JWT jwt) throws BadJWTException {
        ReadOnlyJWTClaimsSet claimsSet;
        try {
            claimsSet = jwt.getJWTClaimsSet();
        }
        catch (ParseException e) {
            throw new BadJWTException(e.getMessage(), e);
        }
        if (this.claimsVerifier != null) {
            this.claimsVerifier.verify(claimsSet);
        }
        return claimsSet;
    }

    @Override
    public ReadOnlyJWTClaimsSet process(String jwtString, C context) throws ParseException, BadJOSEException, JOSEException {
        JWT jwt = JWTParser.parse(jwtString);
        if (jwt instanceof SignedJWT) {
            return this.process((SignedJWT)jwt, (SecurityContext)context);
        }
        if (jwt instanceof EncryptedJWT) {
            return this.process((EncryptedJWT)jwt, (SecurityContext)context);
        }
        if (jwt instanceof PlainJWT) {
            return this.process((PlainJWT)jwt, (SecurityContext)context);
        }
        throw new JOSEException("Unexpected JWT object type: " + jwt.getClass());
    }

    @Override
    public ReadOnlyJWTClaimsSet process(PlainJWT plainJWT, C context) throws BadJOSEException, JOSEException {
        this.verifyAndReturnClaims(plainJWT);
        throw new BadJOSEException("Unsecured (plain) JWTs are rejected, extend class to handle");
    }

    @Override
    public ReadOnlyJWTClaimsSet process(SignedJWT signedJWT, C context) throws BadJOSEException, JOSEException {
        if (this.getJWSKeySelector() == null) {
            throw new BadJOSEException("Signed JWT rejected: No JWS key selector is configured");
        }
        if (this.getJWSVerifierFactory() == null) {
            throw new JOSEException("No JWS verifier is configured");
        }
        List<Key> keyCandidates = this.getJWSKeySelector().selectJWSKeys(signedJWT.getHeader(), context);
        if (keyCandidates == null || keyCandidates.isEmpty()) {
            throw new BadJOSEException("Signed JWT rejected: No matching key(s) found");
        }
        ListIterator<Key> it = keyCandidates.listIterator();
        while (it.hasNext()) {
            JWSVerifier verifier = this.getJWSVerifierFactory().createJWSVerifier(signedJWT.getHeader(), it.next());
            if (verifier == null) continue;
            boolean validSignature = signedJWT.verify(verifier);
            if (validSignature) {
                return this.verifyAndReturnClaims(signedJWT);
            }
            if (it.hasNext()) continue;
            throw new BadJWSException("Signed JWT rejected: Invalid signature");
        }
        throw new BadJOSEException("JWS object rejected: No matching verifier(s) found");
    }

    @Override
    public ReadOnlyJWTClaimsSet process(EncryptedJWT encryptedJWT, C context) throws BadJOSEException, JOSEException {
        if (this.getJWEKeySelector() == null) {
            throw new BadJOSEException("Encrypted JWT rejected: No JWE key selector is configured");
        }
        if (this.getJWEDecrypterFactory() == null) {
            throw new JOSEException("No JWE decrypter is configured");
        }
        List<Key> keyCandidates = this.getJWEKeySelector().selectJWEKeys(encryptedJWT.getHeader(), context);
        if (keyCandidates == null || keyCandidates.isEmpty()) {
            throw new BadJOSEException("Encrypted JWT rejected: No matching key(s) found");
        }
        ListIterator<Key> it = keyCandidates.listIterator();
        while (it.hasNext()) {
            JWEDecrypter decrypter = this.getJWEDecrypterFactory().createJWEDecrypter(encryptedJWT.getHeader(), it.next());
            if (decrypter == null) continue;
            try {
                encryptedJWT.decrypt(decrypter);
            }
            catch (JOSEException e) {
                if (it.hasNext()) continue;
                throw new BadJWEException("Encrypted JWT rejected: " + e.getMessage(), e);
            }
            if ("JWT".equalsIgnoreCase(encryptedJWT.getHeader().getContentType())) {
                SignedJWT nestedJWT = encryptedJWT.getPayload().toSignedJWT();
                if (nestedJWT == null) {
                    throw new BadJWTException("The payload is not a nested JWT");
                }
                return this.process(nestedJWT, (SecurityContext)context);
            }
            return this.verifyAndReturnClaims(encryptedJWT);
        }
        throw new BadJOSEException("Encrypted JWT rejected: No matching decrypter(s) found");
    }
}

