/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ByteUtils {
    public static byte[] concat(byte[] ... byteArrays) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (byte[] bytes : byteArrays) {
                if (bytes == null) continue;
                baos.write(bytes);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static byte[] subArray(byte[] byteArray, int beginIndex, int length) {
        byte[] subArray = new byte[length];
        System.arraycopy(byteArray, beginIndex, subArray, 0, subArray.length);
        return subArray;
    }

    public static int bitLength(int byteLength) {
        return byteLength * 8;
    }

    public static int bitLength(byte[] byteArray) {
        if (byteArray == null) {
            return 0;
        }
        return ByteUtils.bitLength(byteArray.length);
    }

    public static int byteLength(int bitLength) {
        return bitLength / 8;
    }
}

