/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObject;
import com.nimbusds.jose.JSONSerializable;
import com.nimbusds.jose.JWECryptoParts;
import com.nimbusds.jose.JWEDecrypterMulti;
import com.nimbusds.jose.JWEEncrypterMulti;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWERecipient;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONArrayUtils;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

@ThreadSafe
public class JWEObjectJSON
extends JOSEObject
implements JSONSerializable {
    private static final long serialVersionUID = 1L;
    private JWEHeader header;
    private List<JWERecipient> recipients;
    private Base64URL iv;
    private Base64URL cipherText;
    private Base64URL authTag;
    private State state;

    public JWEObjectJSON(JWEHeader header, Payload payload) {
        this.header = header;
        if (payload == null) {
            throw new IllegalArgumentException("The payload must not be null");
        }
        this.setPayload(payload);
        this.recipients = null;
        this.cipherText = null;
        this.state = State.UNENCRYPTED;
    }

    public JWEObjectJSON(Base64URL header, List<JWERecipient> recipients, Base64URL iv, Base64URL ciphertext, Base64URL tag) throws ParseException {
        if (header == null) {
            throw new IllegalArgumentException("The header must not be null");
        }
        try {
            this.header = JWEHeader.parse(header);
        }
        catch (ParseException e) {
            throw new ParseException("Invalid JWE header: " + e.getMessage(), 0);
        }
        this.recipients = recipients == null || recipients.isEmpty() ? null : recipients;
        this.iv = iv == null || iv.toString().isEmpty() ? null : iv;
        if (ciphertext == null) {
            throw new IllegalArgumentException("The ciphertext must not be null");
        }
        this.cipherText = ciphertext;
        this.authTag = tag == null || tag.toString().isEmpty() ? null : tag;
        this.state = State.ENCRYPTED;
    }

    @Override
    public JWEHeader getHeader() {
        return this.header;
    }

    public List<JWERecipient> getRecipients() {
        return this.recipients;
    }

    public Base64URL getIV() {
        return this.iv;
    }

    public Base64URL getCipherText() {
        return this.cipherText;
    }

    public Base64URL getAuthTag() {
        return this.authTag;
    }

    public State getState() {
        return this.state;
    }

    private void ensureUnencryptedState() {
        if (this.state != State.UNENCRYPTED) {
            throw new IllegalStateException("The JWE object must be in an unencrypted state");
        }
    }

    private void ensureEncryptedState() {
        if (this.state != State.ENCRYPTED) {
            throw new IllegalStateException("The JWE object must be in an encrypted state");
        }
    }

    private void ensureEncryptedOrDecryptedState() {
        if (this.state != State.ENCRYPTED && this.state != State.DECRYPTED) {
            throw new IllegalStateException("The JWE object must be in an encrypted or decrypted state");
        }
    }

    private void ensureJWEEncrypterSupport(JWEEncrypterMulti encrypter) throws JOSEException {
        if (!encrypter.supportedJWEAlgorithms().contains(this.getHeader().getAlgorithm())) {
            throw new JOSEException("The " + this.getHeader().getAlgorithm() + " algorithm is not supported by the JWE encrypter: Supported algorithms: " + encrypter.supportedJWEAlgorithms());
        }
        if (!encrypter.supportedEncryptionMethods().contains(this.getHeader().getEncryptionMethod())) {
            throw new JOSEException("The " + this.getHeader().getEncryptionMethod() + " encryption method or key size is not supported by the JWE encrypter: Supported methods: " + encrypter.supportedEncryptionMethods());
        }
    }

    public synchronized void encrypt(JWEEncrypterMulti encrypter) throws JOSEException {
        JWECryptoParts parts;
        this.ensureUnencryptedState();
        this.ensureJWEEncrypterSupport(encrypter);
        try {
            parts = encrypter.encrypt(this.getHeader(), this.getPayload().toBytes());
        }
        catch (JOSEException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JOSEException(e.getMessage(), e);
        }
        if (parts.getHeader() != null) {
            this.header = parts.getHeader();
        }
        this.recipients = parts.getRecipients();
        this.iv = parts.getInitializationVector();
        this.cipherText = parts.getCipherText();
        this.authTag = parts.getAuthenticationTag();
        this.state = State.ENCRYPTED;
    }

    public synchronized void decrypt(JWEDecrypterMulti decrypter) throws JOSEException {
        this.ensureEncryptedState();
        try {
            this.setPayload(new Payload(decrypter.decrypt(this.getHeader(), this.getRecipients(), this.getIV(), this.getCipherText(), this.getAuthTag())));
        }
        catch (JOSEException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JOSEException(e.getMessage(), e);
        }
        this.state = State.DECRYPTED;
    }

    @Override
    public String serialize() {
        this.ensureEncryptedOrDecryptedState();
        return JSONObjectUtils.toJSONString(this.toGeneralJSONObject());
    }

    public static JWEObjectJSON parse(String s) throws ParseException {
        Map<String, Object> json = JSONObjectUtils.parse(s);
        return JWEObjectJSON.parse(json);
    }

    public static JWEObjectJSON parse(Map<String, Object> jsonObject) throws ParseException {
        return new JWEObjectJSON(JSONObjectUtils.getBase64URL(jsonObject, "protected"), JWERecipient.parse(JSONObjectUtils.getJSONObjectArray(jsonObject, "recipients")), JSONObjectUtils.getBase64URL(jsonObject, "iv"), JSONObjectUtils.getBase64URL(jsonObject, "ciphertext"), JSONObjectUtils.getBase64URL(jsonObject, "tag"));
    }

    @Override
    public Map<String, Object> toGeneralJSONObject() {
        this.ensureEncryptedOrDecryptedState();
        List<Object> recipients = JSONArrayUtils.newJSONArray();
        for (JWERecipient recipient : this.getRecipients()) {
            recipients.add(recipient.toJSONObject());
        }
        Map<String, Object> json = JSONObjectUtils.newJSONObject();
        json.put("iv", this.getIV().toString());
        json.put("recipients", recipients);
        json.put("tag", this.getAuthTag().toString());
        json.put("protected", this.getHeader().toBase64URL().toString());
        json.put("ciphertext", this.getCipherText().toString());
        return json;
    }

    @Override
    public Map<String, Object> toFlattenedJSONObject() {
        throw new NotImplementedException();
    }

    public static enum State {
        UNENCRYPTED,
        ENCRYPTED,
        DECRYPTED;

    }
}

