/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto.impl;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWECryptoParts;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWERecipient;
import com.nimbusds.jose.UnprotectedHeader;
import com.nimbusds.jose.crypto.impl.AESKW;
import com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import com.nimbusds.jose.crypto.impl.BaseJWEProvider;
import com.nimbusds.jose.crypto.impl.ConcatKDF;
import com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import com.nimbusds.jose.crypto.impl.ECDH;
import com.nimbusds.jose.crypto.impl.ECDH1PU;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.SecretKey;

public abstract class ECDH1PUCryptoProvider
extends BaseJWEProvider {
    public static final Set<JWEAlgorithm> SUPPORTED_ALGORITHMS;
    public static final Set<EncryptionMethod> SUPPORTED_ENCRYPTION_METHODS;
    private final Curve curve;
    private final ConcatKDF concatKDF;

    protected ECDH1PUCryptoProvider(Curve curve) throws JOSEException {
        super(SUPPORTED_ALGORITHMS, ContentCryptoProvider.SUPPORTED_ENCRYPTION_METHODS);
        Curve definedCurve;
        Curve curve2 = definedCurve = curve != null ? curve : new Curve("unknown");
        if (!this.supportedEllipticCurves().contains(curve)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedEllipticCurve(definedCurve, this.supportedEllipticCurves()));
        }
        this.curve = curve;
        this.concatKDF = new ConcatKDF("SHA-256");
    }

    protected ConcatKDF getConcatKDF() {
        return this.concatKDF;
    }

    public abstract Set<Curve> supportedEllipticCurves();

    public Curve getCurve() {
        return this.curve;
    }

    protected JWECryptoParts encryptWithZ(JWEHeader header, SecretKey Z, byte[] clearText, SecretKey contentEncryptionKey) throws JOSEException {
        JWEAlgorithm alg = header.getAlgorithm();
        ECDH.AlgorithmMode algMode = ECDH1PU.resolveAlgorithmMode(alg);
        EncryptionMethod enc = header.getEncryptionMethod();
        if (algMode.equals((Object)ECDH.AlgorithmMode.DIRECT)) {
            this.getConcatKDF().getJCAContext().setProvider(this.getJCAContext().getMACProvider());
            SecretKey cek = ECDH1PU.deriveSharedKey(header, Z, this.getConcatKDF());
            return ContentCryptoProvider.encrypt(header, clearText, cek, null, this.getJCAContext());
        }
        if (algMode.equals((Object)ECDH.AlgorithmMode.KW)) {
            if (!EncryptionMethod.Family.AES_CBC_HMAC_SHA.contains(enc)) {
                throw new JOSEException(AlgorithmSupportMessage.unsupportedEncryptionMethod(header.getEncryptionMethod(), EncryptionMethod.Family.AES_CBC_HMAC_SHA));
            }
            SecretKey cek = contentEncryptionKey != null ? contentEncryptionKey : ContentCryptoProvider.generateCEK(enc, this.getJCAContext().getSecureRandom());
            JWECryptoParts encrypted = ContentCryptoProvider.encrypt(header, clearText, cek, null, this.getJCAContext());
            SecretKey sharedKey = ECDH1PU.deriveSharedKey(header, Z, encrypted.getAuthenticationTag(), this.getConcatKDF());
            Base64URL encryptedKey = Base64URL.encode(AESKW.wrapCEK(cek, sharedKey, this.getJCAContext().getKeyEncryptionProvider()));
            return new JWECryptoParts(header, encryptedKey, encrypted.getInitializationVector(), encrypted.getCipherText(), encrypted.getAuthenticationTag());
        }
        throw new JOSEException("Unexpected JWE ECDH algorithm mode: " + (Object)((Object)algMode));
    }

    protected byte[] decryptWithZ(JWEHeader header, SecretKey Z, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL authTag) throws JOSEException {
        SecretKey cek;
        JWEAlgorithm alg = header.getAlgorithm();
        ECDH.AlgorithmMode algMode = ECDH1PU.resolveAlgorithmMode(alg);
        this.getConcatKDF().getJCAContext().setProvider(this.getJCAContext().getMACProvider());
        if (algMode.equals((Object)ECDH.AlgorithmMode.DIRECT)) {
            cek = ECDH1PU.deriveSharedKey(header, Z, this.getConcatKDF());
        } else if (algMode.equals((Object)ECDH.AlgorithmMode.KW)) {
            if (encryptedKey == null) {
                throw new JOSEException("Missing JWE encrypted key");
            }
            SecretKey sharedKey = ECDH1PU.deriveSharedKey(header, Z, authTag, this.getConcatKDF());
            cek = AESKW.unwrapCEK(sharedKey, encryptedKey.decode(), this.getJCAContext().getKeyEncryptionProvider());
        } else {
            throw new JOSEException("Unexpected JWE ECDH algorithm mode: " + (Object)((Object)algMode));
        }
        return ContentCryptoProvider.decrypt(header, null, iv, cipherText, authTag, cek, this.getJCAContext());
    }

    protected JWECryptoParts encryptMulti(JWEHeader header, List<Pair<UnprotectedHeader, SecretKey>> sharedSecrets, byte[] clearText) throws JOSEException {
        ECDH.AlgorithmMode algMode = ECDH1PU.resolveAlgorithmMode(header.getAlgorithm());
        SecretKey cek = ContentCryptoProvider.generateCEK(header.getEncryptionMethod(), this.getJCAContext().getSecureRandom());
        ArrayList<JWERecipient> recipients = new ArrayList<JWERecipient>();
        boolean encrypted = false;
        JWECryptoParts parts = null;
        for (Pair<UnprotectedHeader, SecretKey> rs : sharedSecrets) {
            Base64URL encryptedKey = null;
            if (!encrypted) {
                parts = this.encryptWithZ(header, rs.getRight(), clearText, cek);
                encryptedKey = parts.getEncryptedKey();
                encrypted = true;
            } else if (algMode.equals((Object)ECDH.AlgorithmMode.KW)) {
                SecretKey sharedKey = ECDH1PU.deriveSharedKey(header, rs.getRight(), parts.getAuthenticationTag(), this.getConcatKDF());
                encryptedKey = Base64URL.encode(AESKW.wrapCEK(cek, sharedKey, this.getJCAContext().getKeyEncryptionProvider()));
            }
            if (encryptedKey == null) continue;
            recipients.add(new JWERecipient(rs.getLeft(), encryptedKey));
        }
        if (parts == null) {
            throw new JOSEException("Content MUST be encrypted");
        }
        return new JWECryptoParts(parts.getHeader(), Collections.unmodifiableList(recipients), parts.getInitializationVector(), parts.getCipherText(), parts.getAuthenticationTag());
    }

    protected byte[] decryptMulti(JWEHeader header, List<Pair<UnprotectedHeader, SecretKey>> sharedSecrets, List<JWERecipient> recipients, Base64URL iv, Base64URL cipherText, Base64URL authTag) throws JOSEException {
        byte[] result = null;
        for (Pair<UnprotectedHeader, SecretKey> rs : sharedSecrets) {
            String kid = rs.getLeft().getKeyID();
            Base64URL encryptedKey = null;
            if (recipients != null) {
                for (JWERecipient recipient : recipients) {
                    if (recipient.getHeader() == null || !kid.equals(recipient.getHeader().getKeyID())) continue;
                    encryptedKey = recipient.getEncryptedKey();
                    break;
                }
            }
            result = this.decryptWithZ(header, rs.getRight(), encryptedKey, iv, cipherText, authTag);
        }
        return result;
    }

    static {
        SUPPORTED_ENCRYPTION_METHODS = ContentCryptoProvider.SUPPORTED_ENCRYPTION_METHODS;
        LinkedHashSet<JWEAlgorithm> algs = new LinkedHashSet<JWEAlgorithm>();
        algs.add(JWEAlgorithm.ECDH_1PU);
        algs.add(JWEAlgorithm.ECDH_1PU_A128KW);
        algs.add(JWEAlgorithm.ECDH_1PU_A192KW);
        algs.add(JWEAlgorithm.ECDH_1PU_A256KW);
        SUPPORTED_ALGORITHMS = Collections.unmodifiableSet(algs);
    }
}

