/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class ClientCredentialsGrant
extends AuthorizationGrant {
    public static final GrantType GRANT_TYPE = GrantType.CLIENT_CREDENTIALS;
    private final Scope scope;

    public ClientCredentialsGrant(Scope scope) {
        super(GRANT_TYPE);
        this.scope = scope;
    }

    public Scope getScope() {
        return this.scope;
    }

    @Override
    public Map<String, String> toParameters() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("grant_type", GRANT_TYPE.getValue());
        if (this.scope != null) {
            params.put("scope", this.scope.toString());
        }
        return params;
    }

    public static ClientCredentialsGrant parse(Map<String, String> params) throws ParseException {
        String grantTypeString = params.get("grant_type");
        if (grantTypeString == null) {
            throw new ParseException("Missing \"grant_type\" parameter", OAuth2Error.INVALID_REQUEST);
        }
        GrantType grantType = new GrantType(grantTypeString);
        if (!grantType.equals(GRANT_TYPE)) {
            throw new ParseException("The \"grant_type\" must be " + GRANT_TYPE, OAuth2Error.INVALID_GRANT);
        }
        String scopeValue = params.get("scope");
        Scope scope = null;
        if (scopeValue != null) {
            scope = Scope.parse(scopeValue);
        }
        return new ClientCredentialsGrant(scope);
    }
}

