/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import com.nimbusds.openid.connect.sdk.OIDCAuthorizationErrorResponse;
import com.nimbusds.openid.connect.sdk.OIDCAuthorizationResponse;
import com.nimbusds.openid.connect.sdk.OIDCAuthorizationSuccessResponse;
import java.net.URL;
import java.util.Map;

public class OIDCAuthorizationResponseParser {
    public static OIDCAuthorizationResponse parse(URL redirectURI, Map<String, String> params) throws ParseException {
        if (params.containsKey("error")) {
            return OIDCAuthorizationErrorResponse.parse(redirectURI, params);
        }
        return OIDCAuthorizationSuccessResponse.parse(redirectURI, params);
    }

    public static OIDCAuthorizationResponse parse(URL uri) throws ParseException {
        String paramString = null;
        if (uri.getQuery() != null) {
            paramString = uri.getQuery();
        } else if (uri.getRef() != null) {
            paramString = uri.getRef();
        } else {
            throw new ParseException("Missing authorization response parameters");
        }
        Map<String, String> params = URLUtils.parseParameters(paramString);
        if (params == null) {
            throw new ParseException("Missing or invalid authorization response parameters");
        }
        return OIDCAuthorizationResponseParser.parse(URLUtils.getBaseURL(uri), params);
    }

    public static OIDCAuthorizationResponse parse(HTTPResponse httpResponse) throws ParseException {
        if (httpResponse.getStatusCode() != 302) {
            throw new ParseException("Unexpected HTTP status code, must be 302 (Found): " + httpResponse.getStatusCode());
        }
        URL location = httpResponse.getLocation();
        if (location == null) {
            throw new ParseException("Missing redirect URL / HTTP Location header");
        }
        return OIDCAuthorizationResponseParser.parse(location);
    }

    private OIDCAuthorizationResponseParser() {
    }
}

