/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.op;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagException;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.Display;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.claims.ClaimType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minidev.json.JSONObject;

public class OIDCProviderMetadata {
    public static final String VERSION = "3.0";
    private final Issuer issuer;
    private URL authzEndpoint;
    private URL tokenEndpoint;
    private URL userInfoEndpoint;
    private URL regEndpoint;
    private URL checkSessionIframe;
    private URL endSessionEndpoint;
    private final URL jwkSetURI;
    private Scope scope;
    private List<ResponseType> rts;
    private List<GrantType> gts;
    private List<ACR> acrValues;
    private final List<SubjectType> subjectTypes;
    private List<ClientAuthenticationMethod> tokenEndpointAuthMethods;
    private List<JWSAlgorithm> tokenEndpointJWSAlgs;
    private List<JWSAlgorithm> requestObjectJWSAlgs;
    private List<JWEAlgorithm> requestObjectJWEAlgs;
    private List<EncryptionMethod> requestObjectJWEEncs;
    private List<JWSAlgorithm> idTokenJWSAlgs;
    private List<JWEAlgorithm> idTokenJWEAlgs;
    private List<EncryptionMethod> idTokenJWEEncs;
    private List<JWSAlgorithm> userInfoJWSAlgs;
    private List<JWEAlgorithm> userInfoJWEAlgs;
    private List<EncryptionMethod> userInfoJWEEncs;
    private List<Display> displays;
    private List<ClaimType> claimTypes;
    private List<String> claims;
    private List<LangTag> claimsLocales;
    private List<LangTag> uiLocales;
    private URL serviceDocsURL;
    private URL policyURI;
    private URL tosURI;
    private boolean claimsParamSupported;
    private boolean requestParamSupported;
    private boolean requestURIParamSupported;
    private boolean requireRequestURIReg;

    public OIDCProviderMetadata(Issuer issuer, List<SubjectType> subjectTypes, URL jwkSetURI) {
        URL url;
        try {
            url = new URL(issuer.getValue());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The issuer identifier must be a URL: " + e.getMessage(), e);
        }
        if (url.getQuery() != null) {
            throw new IllegalArgumentException("The issuer URL must be without a query component");
        }
        if (url.getRef() != null) {
            throw new IllegalArgumentException("The issuer URL must be without a fragment component ");
        }
        this.issuer = issuer;
        if (subjectTypes.size() < 1) {
            throw new IllegalArgumentException("At least one supported subject type must be specified");
        }
        this.subjectTypes = subjectTypes;
        if (jwkSetURI == null) {
            throw new IllegalArgumentException("The public JWK set URI must not be null");
        }
        this.jwkSetURI = jwkSetURI;
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public URL getAuthorizationEndpointURL() {
        return this.authzEndpoint;
    }

    public void setAuthorizationEndpointURL(URL authzEndpoint) {
        this.authzEndpoint = authzEndpoint;
    }

    public URL getTokenEndpointURL() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpointURL(URL tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public URL getUserInfoEndpointURL() {
        return this.userInfoEndpoint;
    }

    public void setUserInfoEndpointURL(URL userInfoEndpoint) {
        this.userInfoEndpoint = userInfoEndpoint;
    }

    public URL getRegistrationEndpointURL() {
        return this.regEndpoint;
    }

    public void setRegistrationEndpointURL(URL regEndpoint) {
        this.regEndpoint = regEndpoint;
    }

    public URL getCheckSessionIframeURL() {
        return this.checkSessionIframe;
    }

    public void setCheckSessionIframeURL(URL checkSessionIframe) {
        this.checkSessionIframe = checkSessionIframe;
    }

    public URL getEndSessionEndpointURL() {
        return this.endSessionEndpoint;
    }

    public void setEndSessionEndpointURL(URL endSessionEndpoint) {
        this.endSessionEndpoint = endSessionEndpoint;
    }

    public URL getJWKSetURI() {
        return this.jwkSetURI;
    }

    public Scope getScopes() {
        return this.scope;
    }

    public void setScopes(Scope scope) {
        this.scope = scope;
    }

    public List<ResponseType> getResponseTypes() {
        return this.rts;
    }

    public void setResponseTypes(List<ResponseType> rts) {
        this.rts = rts;
    }

    public List<GrantType> getGrantTypes() {
        return this.gts;
    }

    public void setGrantTypes(List<GrantType> gts) {
        this.gts = gts;
    }

    public List<ACR> getACRs() {
        return this.acrValues;
    }

    public void setACRs(List<ACR> acrValues) {
        this.acrValues = acrValues;
    }

    public List<SubjectType> getSubjectTypes() {
        return this.subjectTypes;
    }

    public List<ClientAuthenticationMethod> getTokenEndpointAuthMethods() {
        return this.tokenEndpointAuthMethods;
    }

    public void setTokenEndpointAuthMethods(List<ClientAuthenticationMethod> tokenEndpointAuthMethods) {
        this.tokenEndpointAuthMethods = tokenEndpointAuthMethods;
    }

    public List<JWSAlgorithm> getTokenEndpointJWSAlgs() {
        return this.tokenEndpointJWSAlgs;
    }

    public void setTokenEndpointJWSAlgs(List<JWSAlgorithm> tokenEndpointJWSAlgs) {
        this.tokenEndpointJWSAlgs = tokenEndpointJWSAlgs;
    }

    public List<JWSAlgorithm> getRequestObjectJWSAlgs() {
        return this.requestObjectJWSAlgs;
    }

    public void setRequestObjectJWSAlgs(List<JWSAlgorithm> requestObjectJWSAlgs) {
        this.requestObjectJWSAlgs = requestObjectJWSAlgs;
    }

    public List<JWEAlgorithm> getRequestObjectJWEAlgs() {
        return this.requestObjectJWEAlgs;
    }

    public void setRequestObjectJWEAlgs(List<JWEAlgorithm> requestObjectJWEAlgs) {
        this.requestObjectJWEAlgs = requestObjectJWEAlgs;
    }

    public List<EncryptionMethod> getRequestObjectJWEEncs() {
        return this.requestObjectJWEEncs;
    }

    public void setRequestObjectJWEEncs(List<EncryptionMethod> requestObjectJWEEncs) {
        this.requestObjectJWEEncs = requestObjectJWEEncs;
    }

    public List<JWSAlgorithm> getIDTokenJWSAlgs() {
        return this.idTokenJWSAlgs;
    }

    public void setIdTokenJWSAlgs(List<JWSAlgorithm> idTokenJWSAlgs) {
        this.idTokenJWSAlgs = idTokenJWSAlgs;
    }

    public List<JWEAlgorithm> getIDTokenJWEAlgs() {
        return this.idTokenJWEAlgs;
    }

    public void setIdTokenJWEAlgs(List<JWEAlgorithm> idTokenJWEAlgs) {
        this.idTokenJWEAlgs = idTokenJWEAlgs;
    }

    public List<EncryptionMethod> getIDTokenJWEEncs() {
        return this.idTokenJWEEncs;
    }

    public void setIdTokenJWEEncs(List<EncryptionMethod> idTokenJWEEncs) {
        this.idTokenJWEEncs = idTokenJWEEncs;
    }

    public List<JWSAlgorithm> getUserInfoJWSAlgs() {
        return this.userInfoJWSAlgs;
    }

    public void setUserInfoJWSAlgs(List<JWSAlgorithm> userInfoJWSAlgs) {
        this.userInfoJWSAlgs = userInfoJWSAlgs;
    }

    public List<JWEAlgorithm> getUserInfoJWEAlgs() {
        return this.userInfoJWEAlgs;
    }

    public void setUserInfoJWEAlgs(List<JWEAlgorithm> userInfoJWEAlgs) {
        this.userInfoJWEAlgs = userInfoJWEAlgs;
    }

    public List<EncryptionMethod> getUserInfoJWEEncs() {
        return this.userInfoJWEEncs;
    }

    public void setUserInfoJWEEncs(List<EncryptionMethod> userInfoJWEEncs) {
        this.userInfoJWEEncs = userInfoJWEEncs;
    }

    public List<Display> getDisplays() {
        return this.displays;
    }

    public void setDisplays(List<Display> displays) {
        this.displays = displays;
    }

    public List<ClaimType> getClaimTypes() {
        return this.claimTypes;
    }

    public void setClaimTypes(List<ClaimType> claimTypes) {
        this.claimTypes = claimTypes;
    }

    public List<String> getClaims() {
        return this.claims;
    }

    public void setClaims(List<String> claims) {
        this.claims = claims;
    }

    public List<LangTag> getClaimsLocales() {
        return this.claimsLocales;
    }

    public void setClaimLocales(List<LangTag> claimsLocales) {
        this.claimsLocales = claimsLocales;
    }

    public List<LangTag> getUILocales() {
        return this.uiLocales;
    }

    public void setUILocales(List<LangTag> uiLocales) {
        this.uiLocales = uiLocales;
    }

    public URL getServiceDocsURL() {
        return this.serviceDocsURL;
    }

    public void setServiceDocsURL(URL serviceDocsURL) {
        this.serviceDocsURL = serviceDocsURL;
    }

    public URL getPolicyURI() {
        return this.policyURI;
    }

    public void setPolicyURI(URL policyURI) {
        this.policyURI = policyURI;
    }

    public URL getTermsOfServiceURI() {
        return this.tosURI;
    }

    public void setTermsOfServiceURI(URL tosURI) {
        this.tosURI = tosURI;
    }

    public boolean supportsClaimsParam() {
        return this.claimsParamSupported;
    }

    public void setSupportsClaimsParams(boolean claimsParamSupported) {
        this.claimsParamSupported = claimsParamSupported;
    }

    public boolean supportsRequestParam() {
        return this.requestParamSupported;
    }

    public void setSupportsRequestParams(boolean requestParamSupported) {
        this.requestParamSupported = requestParamSupported;
    }

    public boolean supportsRequestURIParam() {
        return this.requestURIParamSupported;
    }

    public void setSupportsRequestURIParam(boolean requestURIParamSupported) {
        this.requestURIParamSupported = requestURIParamSupported;
    }

    public boolean requiresRequestURIRegistration() {
        return this.requireRequestURIReg;
    }

    public void setRequiresRequestURIRegistration(boolean requireRequestURIReg) {
        this.requireRequestURIReg = requireRequestURIReg;
    }

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        o.put((Object)"version", (Object)VERSION);
        o.put((Object)"issuer", (Object)this.issuer.getValue());
        ArrayList<String> stringList = new ArrayList<String>(this.subjectTypes.size());
        for (SubjectType subjectType : this.subjectTypes) {
            stringList.add(subjectType.toString());
        }
        o.put((Object)"subject_types_supported", stringList);
        o.put((Object)"jwks_uri", (Object)this.jwkSetURI.toString());
        if (this.authzEndpoint != null) {
            o.put((Object)"authorization_endpoint", (Object)this.authzEndpoint.toString());
        }
        if (this.tokenEndpoint != null) {
            o.put((Object)"token_endpoint", (Object)this.tokenEndpoint.toString());
        }
        if (this.userInfoEndpoint != null) {
            o.put((Object)"userinfo_endpoint", (Object)this.userInfoEndpoint.toString());
        }
        if (this.regEndpoint != null) {
            o.put((Object)"registration_endpoint", (Object)this.regEndpoint.toString());
        }
        if (this.checkSessionIframe != null) {
            o.put((Object)"check_session_iframe", (Object)this.checkSessionIframe.toString());
        }
        if (this.endSessionEndpoint != null) {
            o.put((Object)"end_session_endpoint", (Object)this.endSessionEndpoint.toString());
        }
        if (this.scope != null) {
            o.put((Object)"scopes_supported", this.scope.toStringList());
        }
        if (this.rts != null) {
            stringList = new ArrayList(this.rts.size());
            for (ResponseType responseType : this.rts) {
                stringList.add(responseType.toString());
            }
            o.put((Object)"response_types_supported", stringList);
        }
        if (this.gts != null) {
            stringList = new ArrayList(this.gts.size());
            for (GrantType grantType : this.gts) {
                stringList.add(grantType.toString());
            }
            o.put((Object)"grant_types_supported", stringList);
        }
        if (this.acrValues != null) {
            stringList = new ArrayList(this.acrValues.size());
            for (ACR aCR : this.acrValues) {
                stringList.add(aCR.getValue());
            }
            o.put((Object)"acr_values_supported", stringList);
        }
        if (this.tokenEndpointAuthMethods != null) {
            stringList = new ArrayList(this.tokenEndpointAuthMethods.size());
            for (ClientAuthenticationMethod clientAuthenticationMethod : this.tokenEndpointAuthMethods) {
                stringList.add(clientAuthenticationMethod.getValue());
            }
            o.put((Object)"token_endpoint_auth_methods_supported", stringList);
        }
        if (this.tokenEndpointJWSAlgs != null) {
            stringList = new ArrayList(this.tokenEndpointJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.tokenEndpointJWSAlgs) {
                stringList.add(jWSAlgorithm.getName());
            }
            o.put((Object)"token_endpoint_auth_signing_alg_values_supported", stringList);
        }
        if (this.requestObjectJWSAlgs != null) {
            stringList = new ArrayList(this.requestObjectJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.requestObjectJWSAlgs) {
                stringList.add(jWSAlgorithm.getName());
            }
            o.put((Object)"request_object_signing_alg_values_supported", stringList);
        }
        if (this.requestObjectJWEAlgs != null) {
            stringList = new ArrayList(this.requestObjectJWEAlgs.size());
            for (JWEAlgorithm jWEAlgorithm : this.requestObjectJWEAlgs) {
                stringList.add(jWEAlgorithm.getName());
            }
            o.put((Object)"request_object_encryption_alg_values_supported", stringList);
        }
        if (this.requestObjectJWEEncs != null) {
            stringList = new ArrayList(this.requestObjectJWEEncs.size());
            for (EncryptionMethod encryptionMethod : this.requestObjectJWEEncs) {
                stringList.add(encryptionMethod.getName());
            }
            o.put((Object)"request_object_encryption_enc_values_supported", stringList);
        }
        if (this.idTokenJWSAlgs != null) {
            stringList = new ArrayList(this.idTokenJWEAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.idTokenJWSAlgs) {
                stringList.add(jWSAlgorithm.getName());
            }
            o.put((Object)"id_token_signing_alg_values_supported", stringList);
        }
        if (this.idTokenJWEAlgs != null) {
            stringList = new ArrayList(this.idTokenJWEAlgs.size());
            for (JWEAlgorithm jWEAlgorithm : this.idTokenJWEAlgs) {
                stringList.add(jWEAlgorithm.getName());
            }
            o.put((Object)"id_token_encryption_alg_values_supported", stringList);
        }
        if (this.idTokenJWEEncs != null) {
            stringList = new ArrayList(this.idTokenJWEEncs.size());
            for (EncryptionMethod encryptionMethod : this.idTokenJWEEncs) {
                stringList.add(encryptionMethod.getName());
            }
            o.put((Object)"id_token_encryption_enc_values_supported", stringList);
        }
        if (this.userInfoJWSAlgs != null) {
            stringList = new ArrayList(this.userInfoJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.userInfoJWSAlgs) {
                stringList.add(jWSAlgorithm.getName());
            }
            o.put((Object)"userinfo_signing_alg_values_supported", stringList);
        }
        if (this.userInfoJWEAlgs != null) {
            stringList = new ArrayList(this.userInfoJWEAlgs.size());
            for (JWEAlgorithm jWEAlgorithm : this.userInfoJWEAlgs) {
                stringList.add(jWEAlgorithm.getName());
            }
            o.put((Object)"userinfo_encryption_alg_values_supported", stringList);
        }
        if (this.userInfoJWEEncs != null) {
            stringList = new ArrayList(this.userInfoJWEEncs.size());
            for (EncryptionMethod encryptionMethod : this.userInfoJWEEncs) {
                stringList.add(encryptionMethod.getName());
            }
            o.put((Object)"userinfo_encryption_enc_values_supported", stringList);
        }
        if (this.displays != null) {
            stringList = new ArrayList(this.displays.size());
            for (Display display : this.displays) {
                stringList.add(display.toString());
            }
            o.put((Object)"display_values_supported", stringList);
        }
        if (this.claimTypes != null) {
            stringList = new ArrayList(this.claimTypes.size());
            for (ClaimType claimType : this.claimTypes) {
                stringList.add(claimType.toString());
            }
            o.put((Object)"claim_types_supported", stringList);
        }
        if (this.claims != null) {
            o.put((Object)"claims_supported", this.claims);
        }
        if (this.claimsLocales != null) {
            stringList = new ArrayList(this.claimsLocales.size());
            for (LangTag langTag : this.claimsLocales) {
                stringList.add(langTag.toString());
            }
            o.put((Object)"claims_locales_supported", stringList);
        }
        if (this.uiLocales != null) {
            stringList = new ArrayList(this.uiLocales.size());
            for (LangTag langTag : this.uiLocales) {
                stringList.add(langTag.toString());
            }
            o.put((Object)"ui_locales_supported", stringList);
        }
        if (this.serviceDocsURL != null) {
            o.put((Object)"service_documentation", (Object)this.serviceDocsURL.toString());
        }
        if (this.policyURI != null) {
            o.put((Object)"op_policy_uri", (Object)this.policyURI.toString());
        }
        if (this.tosURI != null) {
            o.put((Object)"op_tos_uri", (Object)this.tosURI.toString());
        }
        o.put((Object)"claims_parameter_supported", (Object)this.claimsParamSupported);
        o.put((Object)"request_parameter_supported", (Object)this.requestParamSupported);
        o.put((Object)"request_uri_parameter_supported", (Object)this.requestURIParamSupported);
        o.put((Object)"require_request_uri_registration", (Object)this.requireRequestURIReg);
        return o;
    }

    public static OIDCProviderMetadata parse(JSONObject jsonObject) throws ParseException {
        String version = JSONObjectUtils.getString(jsonObject, "version");
        if (!version.equals(VERSION)) {
            throw new ParseException("The version must be \"3.0\"");
        }
        ArrayList<SubjectType> subjectTypes = new ArrayList<SubjectType>();
        for (String v : JSONObjectUtils.getStringArray(jsonObject, "subject_types_supported")) {
            subjectTypes.add(SubjectType.parse(v));
        }
        Issuer issuer = new Issuer(JSONObjectUtils.getURL(jsonObject, "issuer").toString());
        URL jwkSetURI = JSONObjectUtils.getURL(jsonObject, "jwks_uri");
        OIDCProviderMetadata op = new OIDCProviderMetadata(issuer, Collections.unmodifiableList(subjectTypes), jwkSetURI);
        if (jsonObject.containsKey((Object)"authorization_endpoint")) {
            op.authzEndpoint = JSONObjectUtils.getURL(jsonObject, "authorization_endpoint");
        }
        if (jsonObject.containsKey((Object)"token_endpoint")) {
            op.tokenEndpoint = JSONObjectUtils.getURL(jsonObject, "token_endpoint");
        }
        if (jsonObject.containsKey((Object)"userinfo_endpoint")) {
            op.userInfoEndpoint = JSONObjectUtils.getURL(jsonObject, "userinfo_endpoint");
        }
        if (jsonObject.containsKey((Object)"registration_endpoint")) {
            op.regEndpoint = JSONObjectUtils.getURL(jsonObject, "registration_endpoint");
        }
        if (jsonObject.containsKey((Object)"check_session_iframe")) {
            op.checkSessionIframe = JSONObjectUtils.getURL(jsonObject, "check_session_iframe");
        }
        if (jsonObject.containsKey((Object)"end_session_endpoint")) {
            op.endSessionEndpoint = JSONObjectUtils.getURL(jsonObject, "end_session_endpoint");
        }
        if (jsonObject.containsKey((Object)"scopes_supported")) {
            op.scope = new Scope();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "scopes_supported")) {
                if (v == null) continue;
                op.scope.add(new Scope.Value(v));
            }
        }
        if (jsonObject.containsKey((Object)"response_types_supported")) {
            op.rts = new ArrayList<ResponseType>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "response_types_supported")) {
                if (v == null) continue;
                op.rts.add(ResponseType.parse(v));
            }
        }
        if (jsonObject.containsKey((Object)"grant_types_supported")) {
            op.gts = new ArrayList<GrantType>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "grant_types_supported")) {
                if (v == null) continue;
                op.gts.add(new GrantType(v));
            }
        }
        if (jsonObject.containsKey((Object)"acr_values_supported")) {
            op.acrValues = new ArrayList<ACR>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "acr_values_supported")) {
                if (v == null) continue;
                op.acrValues.add(new ACR(v));
            }
        }
        if (jsonObject.containsKey((Object)"token_endpoint_auth_methods_supported")) {
            op.tokenEndpointAuthMethods = new ArrayList<ClientAuthenticationMethod>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "token_endpoint_auth_methods_supported")) {
                if (v == null) continue;
                op.tokenEndpointAuthMethods.add(new ClientAuthenticationMethod(v));
            }
        }
        if (jsonObject.containsKey((Object)"token_endpoint_auth_signing_alg_values_supported")) {
            op.tokenEndpointJWSAlgs = new ArrayList<JWSAlgorithm>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "token_endpoint_auth_signing_alg_values_supported")) {
                if (v == null) continue;
                op.tokenEndpointJWSAlgs.add(new JWSAlgorithm(v));
            }
        }
        if (jsonObject.containsKey((Object)"request_object_signing_alg_values_supported")) {
            op.requestObjectJWSAlgs = new ArrayList<JWSAlgorithm>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "request_object_signing_alg_values_supported")) {
                if (v == null) continue;
                op.requestObjectJWSAlgs.add(new JWSAlgorithm(v));
            }
        }
        if (jsonObject.containsKey((Object)"request_object_encryption_alg_values_supported")) {
            op.requestObjectJWEAlgs = new ArrayList<JWEAlgorithm>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "request_object_encryption_alg_values_supported")) {
                if (v == null) continue;
                op.requestObjectJWEAlgs.add(new JWEAlgorithm(v));
            }
        }
        if (jsonObject.containsKey((Object)"request_object_encryption_enc_values_supported")) {
            op.requestObjectJWEEncs = new ArrayList<EncryptionMethod>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "request_object_encryption_enc_values_supported")) {
                if (v == null) continue;
                op.requestObjectJWEEncs.add(new EncryptionMethod(v));
            }
        }
        if (jsonObject.containsKey((Object)"id_token_signing_alg_values_supported")) {
            op.idTokenJWSAlgs = new ArrayList<JWSAlgorithm>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "id_token_signing_alg_values_supported")) {
                if (v == null) continue;
                op.idTokenJWSAlgs.add(new JWSAlgorithm(v));
            }
        }
        if (jsonObject.containsKey((Object)"id_token_encryption_alg_values_supported")) {
            op.idTokenJWEAlgs = new ArrayList<JWEAlgorithm>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "id_token_encryption_alg_values_supported")) {
                if (v == null) continue;
                op.idTokenJWEAlgs.add(new JWEAlgorithm(v));
            }
        }
        if (jsonObject.containsKey((Object)"id_token_encryption_enc_values_supported")) {
            op.idTokenJWEEncs = new ArrayList<EncryptionMethod>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "id_token_encryption_enc_values_supported")) {
                if (v == null) continue;
                op.idTokenJWEEncs.add(new EncryptionMethod(v));
            }
        }
        if (jsonObject.containsKey((Object)"userinfo_signing_alg_values_supported")) {
            op.userInfoJWSAlgs = new ArrayList<JWSAlgorithm>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "userinfo_signing_alg_values_supported")) {
                if (v == null) continue;
                op.userInfoJWSAlgs.add(new JWSAlgorithm(v));
            }
        }
        if (jsonObject.containsKey((Object)"userinfo_encryption_alg_values_supported")) {
            op.userInfoJWEAlgs = new ArrayList<JWEAlgorithm>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "userinfo_encryption_alg_values_supported")) {
                if (v == null) continue;
                op.userInfoJWEAlgs.add(new JWEAlgorithm(v));
            }
        }
        if (jsonObject.containsKey((Object)"userinfo_encryption_enc_values_supported")) {
            op.userInfoJWEEncs = new ArrayList<EncryptionMethod>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "userinfo_encryption_enc_values_supported")) {
                if (v == null) continue;
                op.userInfoJWEEncs.add(new EncryptionMethod(v));
            }
        }
        if (jsonObject.containsKey((Object)"display_values_supported")) {
            op.displays = new ArrayList<Display>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "display_values_supported")) {
                if (v == null) continue;
                op.displays.add(Display.parse(v));
            }
        }
        if (jsonObject.containsKey((Object)"claim_types_supported")) {
            op.claimTypes = new ArrayList<ClaimType>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "claim_types_supported")) {
                if (v == null) continue;
                op.claimTypes.add(ClaimType.parse(v));
            }
        }
        if (jsonObject.containsKey((Object)"claims_supported")) {
            op.claims = new ArrayList<String>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "claims_supported")) {
                if (v == null) continue;
                op.claims.add(v);
            }
        }
        if (jsonObject.containsKey((Object)"claims_locales_supported")) {
            op.claimsLocales = new ArrayList<LangTag>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "claims_locales_supported")) {
                if (v == null) continue;
                try {
                    op.claimsLocales.add(LangTag.parse((String)v));
                }
                catch (LangTagException e) {
                    throw new ParseException("Invalid claims_locales_supported field: " + e.getMessage(), e);
                }
            }
        }
        if (jsonObject.containsKey((Object)"ui_locales_supported")) {
            op.uiLocales = new ArrayList<LangTag>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "ui_locales_supported")) {
                if (v == null) continue;
                try {
                    op.uiLocales.add(LangTag.parse((String)v));
                }
                catch (LangTagException e) {
                    throw new ParseException("Invalid ui_locales_supported field: " + e.getMessage(), e);
                }
            }
        }
        if (jsonObject.containsKey((Object)"service_documentation")) {
            op.serviceDocsURL = JSONObjectUtils.getURL(jsonObject, "service_documentation");
        }
        if (jsonObject.containsKey((Object)"op_policy_uri")) {
            op.policyURI = JSONObjectUtils.getURL(jsonObject, "op_policy_uri");
        }
        if (jsonObject.containsKey((Object)"op_tos_uri")) {
            op.tosURI = JSONObjectUtils.getURL(jsonObject, "op_tos_uri");
        }
        if (jsonObject.containsKey((Object)"claims_parameter_supported")) {
            op.claimsParamSupported = JSONObjectUtils.getBoolean(jsonObject, "claims_parameter_supported");
        }
        if (jsonObject.containsKey((Object)"request_parameter_supported")) {
            op.requestParamSupported = JSONObjectUtils.getBoolean(jsonObject, "request_parameter_supported");
        }
        if (jsonObject.containsKey((Object)"request_uri_parameter_supported")) {
            op.requestURIParamSupported = JSONObjectUtils.getBoolean(jsonObject, "request_uri_parameter_supported");
        }
        if (jsonObject.containsKey((Object)"require_request_uri_registration")) {
            op.requireRequestURIReg = JSONObjectUtils.getBoolean(jsonObject, "require_request_uri_registration");
        }
        return op;
    }

    public static OIDCProviderMetadata parse(String s) throws ParseException {
        return OIDCProviderMetadata.parse(JSONObjectUtils.parseJSONObject(s));
    }
}

