/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.ClientCredentialsGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.JWTBearerGrant;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.ResourceOwnerPasswordCredentialsGrant;
import com.nimbusds.oauth2.sdk.SAML2BearerGrant;
import java.util.Map;

public abstract class AuthorizationGrant {
    private final GrantType type;

    protected AuthorizationGrant(GrantType type) {
        if (type == null) {
            throw new IllegalArgumentException("The grant type must not be null");
        }
        this.type = type;
    }

    public GrantType getType() {
        return this.type;
    }

    public abstract Map<String, String> toParameters();

    public static AuthorizationGrant parse(Map<String, String> params) throws ParseException {
        String grantTypeString = params.get("grant_type");
        if (grantTypeString == null) {
            throw new ParseException("Missing \"grant_type\" parameter", OAuth2Error.INVALID_REQUEST);
        }
        GrantType grantType = GrantType.parse(grantTypeString);
        if (grantType.equals(GrantType.AUTHORIZATION_CODE)) {
            return AuthorizationCodeGrant.parse(params);
        }
        if (grantType.equals(GrantType.REFRESH_TOKEN)) {
            return RefreshTokenGrant.parse(params);
        }
        if (grantType.equals(GrantType.PASSWORD)) {
            return ResourceOwnerPasswordCredentialsGrant.parse(params);
        }
        if (grantType.equals(GrantType.CLIENT_CREDENTIALS)) {
            return ClientCredentialsGrant.parse(params);
        }
        if (grantType.equals(GrantType.JWT_BEARER)) {
            return JWTBearerGrant.parse(params);
        }
        if (grantType.equals(GrantType.SAML2_BEARER)) {
            return SAML2BearerGrant.parse(params);
        }
        throw new ParseException("Invalid or unsupported grant type: " + grantType, OAuth2Error.UNSUPPORTED_GRANT_TYPE);
    }
}

