/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.AbstractRequest;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class TokenRequest
extends AbstractRequest {
    private final ClientAuthentication clientAuth;
    private final ClientID clientID;
    private final AuthorizationGrant authzGrant;
    private final Scope scope;

    public TokenRequest(URI uri, ClientAuthentication clientAuth, AuthorizationGrant authzGrant, Scope scope) {
        super(uri);
        if (clientAuth == null) {
            throw new IllegalArgumentException("The client authentication must not be null");
        }
        this.clientAuth = clientAuth;
        this.clientID = null;
        this.authzGrant = authzGrant;
        this.scope = scope;
    }

    public TokenRequest(URI uri, ClientID clientID, AuthorizationGrant authzGrant, Scope scope) {
        super(uri);
        if (authzGrant.getType().requiresClientAuthentication()) {
            throw new IllegalArgumentException("The \"" + authzGrant.getType() + "\" grant type requires client authentication");
        }
        if (authzGrant.getType().requiresClientID() && clientID == null) {
            throw new IllegalArgumentException("The \"" + authzGrant.getType() + "\" grant type requires a \"client_id\" parameter");
        }
        this.authzGrant = authzGrant;
        this.clientID = clientID;
        this.clientAuth = null;
        this.scope = scope;
    }

    public TokenRequest(URI uri, AuthorizationGrant authzGrant, Scope scope) {
        this(uri, (ClientID)null, authzGrant, scope);
    }

    public ClientAuthentication getClientAuthentication() {
        return this.clientAuth;
    }

    public ClientID getClientID() {
        return this.clientID;
    }

    public AuthorizationGrant getAuthorizationGrant() {
        return this.authzGrant;
    }

    public Scope getScope() {
        return this.scope;
    }

    @Override
    public HTTPRequest toHTTPRequest() throws SerializeException {
        URL url;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        try {
            url = this.getEndpointURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new SerializeException(e.getMessage(), e);
        }
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, url);
        httpRequest.setContentType(CommonContentTypes.APPLICATION_URLENCODED);
        if (this.getClientAuthentication() != null) {
            this.getClientAuthentication().applyTo(httpRequest);
        }
        Map<String, String> params = this.authzGrant.toParameters();
        if (this.scope != null && !this.scope.isEmpty()) {
            params.put("scope", this.scope.toString());
        }
        if (this.clientID != null) {
            params.put("client_id", this.clientID.getValue());
        }
        httpRequest.setQuery(URLUtils.serializeParameters(params));
        return httpRequest;
    }

    public static TokenRequest parse(HTTPRequest httpRequest) throws ParseException {
        URI uri;
        try {
            uri = httpRequest.getURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new ParseException(e.getMessage(), e);
        }
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        httpRequest.ensureContentType(CommonContentTypes.APPLICATION_URLENCODED);
        ClientAuthentication clientAuth = ClientAuthentication.parse(httpRequest);
        Map<String, String> params = httpRequest.getQueryParameters();
        AuthorizationGrant grant = AuthorizationGrant.parse(params);
        if (clientAuth == null && grant.getType().requiresClientAuthentication()) {
            throw new ParseException("Missing client authentication", OAuth2Error.INVALID_CLIENT);
        }
        ClientID clientID = null;
        if (clientAuth == null) {
            String clientIDString = params.get("client_id");
            if (clientIDString != null && clientIDString.trim().length() > 0) {
                clientID = new ClientID(clientIDString);
            }
            if (clientID == null && grant.getType().requiresClientID()) {
                throw new ParseException("Missing required \"client_id\" parameter", OAuth2Error.INVALID_REQUEST);
            }
        }
        String scopeValue = params.get("scope");
        Scope scope = null;
        if (scopeValue != null) {
            scope = Scope.parse(scopeValue);
        }
        if (clientAuth != null) {
            return new TokenRequest(uri, clientAuth, grant, scope);
        }
        return new TokenRequest(uri, clientID, grant, scope);
    }
}

