/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.assertions.jwt;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.oauth2.sdk.id.Audience;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public class JWTAssertionClaimsSetVerifier
extends DefaultJWTClaimsVerifier {
    private static BadJWTException INVALID_CLAIM_EXCEPTION = new BadJWTException("Missing or invalid JWT claim");
    private final Set<Audience> expectedAudience;

    public JWTAssertionClaimsSetVerifier(Set<Audience> expectedAudience) {
        if (expectedAudience == null || expectedAudience.isEmpty()) {
            throw new IllegalArgumentException("The expected audience set must not be null or empty");
        }
        this.expectedAudience = expectedAudience;
    }

    public Set<Audience> getExpectedAudience() {
        return this.expectedAudience;
    }

    public void verify(JWTClaimsSet claimsSet) throws BadJWTException {
        super.verify(claimsSet);
        if (claimsSet.getExpirationTime() == null) {
            throw INVALID_CLAIM_EXCEPTION;
        }
        if (claimsSet.getAudience() == null || claimsSet.getAudience().isEmpty()) {
            throw INVALID_CLAIM_EXCEPTION;
        }
        boolean audMatch = false;
        for (String aud : claimsSet.getAudience()) {
            if (aud == null || aud.isEmpty() || !this.expectedAudience.contains(new Audience(aud))) continue;
            audMatch = true;
        }
        if (!audMatch) {
            throw INVALID_CLAIM_EXCEPTION;
        }
        if (claimsSet.getIssuer() == null || claimsSet.getSubject() == null) {
            throw INVALID_CLAIM_EXCEPTION;
        }
    }
}

