/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.federation.policy;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.CollectionUtils;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import com.nimbusds.openid.connect.sdk.federation.policy.language.BooleanConfiguration;
import com.nimbusds.openid.connect.sdk.federation.policy.language.OperationName;
import com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyOperation;
import com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyOperationApplication;
import com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyViolationException;
import com.nimbusds.openid.connect.sdk.federation.policy.language.StringConfiguration;
import com.nimbusds.openid.connect.sdk.federation.policy.language.StringListConfiguration;
import com.nimbusds.openid.connect.sdk.federation.policy.operations.DefaultPolicyOperationCombinationValidator;
import com.nimbusds.openid.connect.sdk.federation.policy.operations.DefaultPolicyOperationFactory;
import com.nimbusds.openid.connect.sdk.federation.policy.operations.PolicyOperationCombinationValidator;
import com.nimbusds.openid.connect.sdk.federation.policy.operations.PolicyOperationFactory;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONObject;

public class MetadataPolicyEntry
implements Map.Entry<String, List<PolicyOperation>> {
    protected static final PolicyOperationFactory DEFAULT_POLICY_OPERATION_FACTORY = new DefaultPolicyOperationFactory();
    protected static final PolicyOperationCombinationValidator DEFAULT_POLICY_COMBINATION_VALIDATOR = new DefaultPolicyOperationCombinationValidator();
    private final String parameterName;
    private List<PolicyOperation> policyOperations;

    public MetadataPolicyEntry(String parameterName, List<PolicyOperation> policyOperations) {
        if (StringUtils.isBlank(parameterName)) {
            throw new IllegalArgumentException("The parameter name must not be null or empty");
        }
        this.parameterName = parameterName;
        this.policyOperations = policyOperations;
    }

    public String getParameterName() {
        return this.getKey();
    }

    @Override
    public String getKey() {
        return this.parameterName;
    }

    public List<PolicyOperation> getPolicyOperations() {
        return this.getValue();
    }

    @Override
    public List<PolicyOperation> getValue() {
        return this.policyOperations;
    }

    @Override
    public List<PolicyOperation> setValue(List<PolicyOperation> policyOperations) {
        throw new UnsupportedOperationException();
    }

    public Object apply(Object value) throws PolicyViolationException {
        if (CollectionUtils.isEmpty(this.getValue())) {
            return value;
        }
        Object updatedValue = value;
        Iterator iterator = this.getValue().iterator();
        while (iterator.hasNext()) {
            PolicyOperation op = (PolicyOperation)iterator.next();
            updatedValue = PolicyOperationApplication.apply(op, updatedValue);
        }
        return updatedValue;
    }

    public JSONObject toJSONObject() {
        if (CollectionUtils.isEmpty(this.getValue())) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        Iterator iterator = this.getValue().iterator();
        while (iterator.hasNext()) {
            PolicyOperation operation = (PolicyOperation)iterator.next();
            jsonObject.put((Object)operation.getOperationName().getValue(), MetadataPolicyEntry.configToJSONEntity(operation));
        }
        return jsonObject;
    }

    private static Object configToJSONEntity(PolicyOperation op) {
        Object value;
        if (op instanceof StringConfiguration && (value = ((StringConfiguration)((Object)op)).getStringConfiguration()) != null) {
            return value;
        }
        if (op instanceof StringListConfiguration && (value = ((StringListConfiguration)((Object)op)).getStringListConfiguration()) != null) {
            return value;
        }
        if (op instanceof BooleanConfiguration) {
            return ((BooleanConfiguration)((Object)op)).getBooleanConfiguration();
        }
        throw new IllegalArgumentException("Unsupported policy operation: " + op.getClass());
    }

    public static MetadataPolicyEntry parse(String parameterName, JSONObject entrySpec, PolicyOperationFactory factory, PolicyOperationCombinationValidator combinationValidator) throws ParseException, PolicyViolationException {
        LinkedList<PolicyOperation> policyOperations = new LinkedList<PolicyOperation>();
        for (String opName : entrySpec.keySet()) {
            PolicyOperation op = factory.createForName(new OperationName(opName));
            op.parseConfiguration(entrySpec.get((Object)opName));
            policyOperations.add(op);
        }
        List<PolicyOperation> validatedPolicyOperations = combinationValidator.validate(policyOperations);
        return new MetadataPolicyEntry(parameterName, validatedPolicyOperations);
    }

    public static MetadataPolicyEntry parse(String parameterName, JSONObject entrySpec) throws ParseException, PolicyViolationException {
        return MetadataPolicyEntry.parse(parameterName, entrySpec, DEFAULT_POLICY_OPERATION_FACTORY, DEFAULT_POLICY_COMBINATION_VALIDATOR);
    }
}

