package com.norbitltd.spoiwo.model

object Color {

  lazy val Black = Color(0, 0, 0)
  lazy val White = Color(255, 255, 255)
  lazy val Red = Color(255, 0, 0)
  lazy val Lime = Color(0, 255, 0)
  lazy val Blue = Color(0, 0, 255)
  lazy val Yellow = Color(255, 255, 0)
  lazy val Aqua = Color(0, 255, 255)
  lazy val Magenta = Color(255, 0, 255)
  lazy val Silver = Color(192, 192, 192)
  lazy val Gray = Color(128, 128, 128)
  lazy val Maroon = Color(128, 0, 0)
  lazy val Olive = Color(128, 128, 0)
  lazy val Green = Color(0, 128, 0)
  lazy val Purple = Color(128, 0, 128)
  lazy val Teal = Color(0, 128, 128)
  lazy val Navy = Color(0, 0, 128)
  lazy val Orange = Color(255, 165, 0)
  lazy val DarkRed = Color(139,0,0)
  lazy val Brown = Color(165,42,42)
  lazy val Firebrick = Color(178,34,34)
  lazy val Crimson = Color(220,20,60)
  lazy val Tomato = Color(255,99,71)
  lazy val Coral = Color(255,127,80)
  lazy val IndianRed = Color(205,92,92)
  lazy val LightCoral = Color(240,128,128)
  lazy val DarkSalmon = Color(233,150,122)
  lazy val Salmon = Color(250,128,114)
  lazy val LightSalmon = Color(255,160,122)
  lazy val OrangeRed = Color(255,69,0)
  lazy val DarkOrange = Color(255,140,0)
  lazy val Gold = Color(255,215,0)
  lazy val DarkGoldenRod = Color(184,134,11)
  lazy val GoldenRod = Color(218,165,32)
  lazy val PaleGoldenRod = Color(238,232,170)
  lazy val DarkKhaki = Color(189,183,107)
  lazy val Khaki = Color(240,230,140)
  lazy val YellowGreen = Color(154,205,50)
  lazy val DarkOliveGreen = Color(85,107,47)
  lazy val OliveDrab = Color(107,142,35)
  lazy val LawnGreen = Color(124,252,0)
  lazy val ChartReuse = Color(127,255,0)
  lazy val GreenYellow = Color(173,255,47)
  lazy val DarkGreen = Color(0,100,0)
  lazy val ForestGreen = Color(34,139,34)
  lazy val LimeGreen = Color(50,205,50)
  lazy val LightGreen = Color(144,238,144)
  lazy val PaleGreen = Color(152,251,152)
  lazy val DarkSeaGreen = Color(143,188,143)
  lazy val MediumSpringGreen = Color(0,250,154)
  lazy val SpringGreen = Color(0,255,127)
  lazy val SeaGreen = Color(46,139,87)
  lazy val MediumAquaMarine = Color(102,205,170)
  lazy val MediumSeaGreen = Color(60,179,113)
  lazy val LightSeaGreen = Color(32,178,170)
  lazy val DarkSlateGray = Color(47,79,79)
  lazy val DarkCyan = Color(0,139,139)
  lazy val Cyan = Color(0,255,255)
  lazy val LightCyan = Color(224,255,255)
  lazy val DarkTurquoise = Color(0,206,209)
  lazy val Turquoise = Color(64,224,208)
  lazy val MediumTurquoise = Color(72,209,204)
  lazy val PaleTurquoise = Color(175,238,238)
  lazy val AquaMarine = Color(127,255,212)
  lazy val PowderBlue = Color(176,224,230)
  lazy val CadetBlue = Color(95,158,160)
  lazy val SteelBlue = Color(70,130,180)
  lazy val CornFlowerBlue = Color(100,149,237)
  lazy val DeepSkyBlue = Color(0,191,255)
  lazy val DodgerBlue = Color(30,144,255)
  lazy val LightBlue = Color(173,216,230)
  lazy val SkyBlue = Color(135,206,235)
  lazy val LightSkyBlue = Color(135,206,250)
  lazy val MidnightBlue = Color(25,25,112)
  lazy val DarkBlue = Color(0,0,139)
  lazy val MediumBlue = Color(0,0,205)
  lazy val RoyalBlue = Color(65,105,225)
  lazy val BlueViolet = Color(138,43,226)
  lazy val Indigo = Color(75,0,130)
  lazy val DarkSlateBlue = Color(72,61,139)
  lazy val SlateBlue = Color(106,90,205)
  lazy val MediumSlateBlue = Color(123,104,238)
  lazy val MediumPurple = Color(147,112,219)
  lazy val DarkMagenta = Color(139,0,139)
  lazy val DarkViolet = Color(148,0,211)
  lazy val DarkOrchid = Color(153,50,204)
  lazy val MediumOrchid = Color(186,85,211)
  lazy val Thistle = Color(216,191,216)
  lazy val Plum = Color(221,160,221)
  lazy val Violet = Color(238,130,238)
  lazy val Orchid = Color(218,112,214)
  lazy val MediumVioletRed = Color(199,21,133)
  lazy val PaleVioletRed = Color(219,112,147)
  lazy val DeepPink = Color(255,20,147)
  lazy val HotPink = Color(255,105,180)
  lazy val LightPink = Color(255,182,193)
  lazy val Pink = Color(255,192,203)
  lazy val AntiqueWhite = Color(250,235,215)
  lazy val Beige = Color(245,245,220)
  lazy val Bisque = Color(255,228,196)
  lazy val BlanchedAlmond = Color(255,235,205)
  lazy val Wheat = Color(245,222,179)
  lazy val CornSilk = Color(255,248,220)
  lazy val LemonChiffon = Color(255,250,205)
  lazy val LightGoldenRodYellow = Color(250,250,210)
  lazy val LightYellow = Color(255,255,224)
  lazy val SaddleBrown = Color(139,69,19)
  lazy val Sienna = Color(160,82,45)
  lazy val Chocolate = Color(210,105,30)
  lazy val Peru = Color(205,133,63)
  lazy val SandyBrown = Color(244,164,96)
  lazy val BurlyWood = Color(222,184,135)
  lazy val Tan = Color(210,180,140)
  lazy val RosyBrown = Color(188,143,143)
  lazy val Moccasin = Color(255,228,181)
  lazy val NavajoWhite = Color(255,222,173)
  lazy val PeachPuff = Color(255,218,185)
  lazy val MistyRose = Color(255,228,225)
  lazy val LavenderBlush = Color(255,240,245)
  lazy val Linen = Color(250,240,230)
  lazy val OldLace = Color(253,245,230)
  lazy val PapayaWhip = Color(255,239,213)
  lazy val SeaShell = Color(255,245,238)
  lazy val MintCream = Color(245,255,250)
  lazy val SlateGray = Color(112,128,144)
  lazy val LightSlateGray = Color(119,136,153)
  lazy val LightSteelBlue = Color(176,196,222)
  lazy val Lavender = Color(230,230,250)
  lazy val FloralWhite = Color(255,250,240)
  lazy val AliceBlue = Color(240,248,255)
  lazy val GhostWhite = Color(248,248,255)
  lazy val Honeydew = Color(240,255,240)
  lazy val Ivory = Color(255,255,240)
  lazy val Azure = Color(240,255,255)
  lazy val Snow = Color(255,250,250)
  lazy val DimGrey = Color(105,105,105)
  lazy val Grey = Color(128,128,128)
  lazy val DarkGrey = Color(169,169,169)
  lazy val LightGrey = Color(211,211,211)
  lazy val Gainsborough = Color(220,220,220)
  lazy val WhiteSmoke = Color(245,245,245)

  def apply(rgbArray : Array[Byte]) : Color = {
    require(rgbArray.size == 3, "Only 3 values are allowed in RGB array!")
    Color(rgbArray(0), rgbArray(1), rgbArray(2))
  }
}

case class Color(r: Int, g: Int, b: Int) {
  require(r >= 0 && r <= 255, "Invalid red color value = %d".format(r))
  require(g >= 0 && g <= 255, "Invalid green color value = %d".format(g))
  require(b >= 0 && b <= 255, "Invalid blue color value = %d".format(b))
}
