/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.collection;

import com.orientechnologies.common.collection.OIterableObject;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.util.OResettable;
import com.orientechnologies.common.util.OSizeable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class OMultiCollectionIterator<T>
implements Iterator<T>,
Iterable<T>,
OResettable,
OSizeable {
    private Collection<Object> sources;
    private Iterator<?> iteratorOfInternalCollections;
    private Iterator<T> partialIterator;
    private int browsed = 0;
    private int limit = -1;
    private boolean embedded = false;

    public OMultiCollectionIterator() {
        this.sources = new ArrayList<Object>();
    }

    public OMultiCollectionIterator(Collection<Object> iSources) {
        this.sources = iSources;
        this.iteratorOfInternalCollections = iSources.iterator();
        this.getNextPartial();
    }

    public OMultiCollectionIterator(Iterator<? extends Collection<?>> iterator) {
        this.iteratorOfInternalCollections = iterator;
        this.getNextPartial();
    }

    @Override
    public boolean hasNext() {
        if (this.iteratorOfInternalCollections == null) {
            if (this.sources == null || this.sources.isEmpty()) {
                return false;
            }
            this.iteratorOfInternalCollections = this.sources.iterator();
            this.getNextPartial();
        }
        if (this.partialIterator == null) {
            return false;
        }
        if (this.limit > -1 && this.browsed >= this.limit) {
            return false;
        }
        if (this.partialIterator.hasNext()) {
            return true;
        }
        if (this.iteratorOfInternalCollections.hasNext()) {
            return this.getNextPartial();
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.browsed;
        return this.partialIterator.next();
    }

    @Override
    public Iterator<T> iterator() {
        this.reset();
        return this;
    }

    @Override
    public void reset() {
        this.iteratorOfInternalCollections = null;
        this.partialIterator = null;
        this.browsed = 0;
    }

    public OMultiCollectionIterator<T> add(Object iValue) {
        if (iValue != null) {
            if (this.iteratorOfInternalCollections != null) {
                throw new IllegalStateException("MultiCollection iterator is in use and new collections cannot be added");
            }
            this.sources.add(iValue);
        }
        return this;
    }

    @Override
    public int size() {
        int size = 0;
        for (Object o : this.sources) {
            if (o == null) continue;
            if (o instanceof Collection) {
                size += ((Collection)o).size();
                continue;
            }
            if (o instanceof Map) {
                size += ((Map)o).size();
                continue;
            }
            if (o instanceof OSizeable) {
                size += ((OSizeable)o).size();
                continue;
            }
            if (o.getClass().isArray()) {
                size += Array.getLength(o);
                continue;
            }
            if (o instanceof Iterator && o instanceof OResettable) {
                while (((Iterator)o).hasNext()) {
                    ++size;
                    ((Iterator)o).next();
                }
                ((OResettable)o).reset();
                continue;
            }
            ++size;
        }
        return size;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("OMultiCollectionIterator.remove()");
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    protected boolean getNextPartial() {
        if (this.iteratorOfInternalCollections != null) {
            while (this.iteratorOfInternalCollections.hasNext()) {
                Object next = this.iteratorOfInternalCollections.next();
                if (next == null) continue;
                if (next instanceof Iterator) {
                    if (next instanceof OResettable) {
                        ((OResettable)next).reset();
                    }
                    if (!((Iterator)next).hasNext()) continue;
                    this.partialIterator = (Iterator)next;
                    return true;
                }
                if (next instanceof Collection) {
                    if (((Collection)next).isEmpty()) continue;
                    this.partialIterator = ((Collection)next).iterator();
                    return true;
                }
                if (next.getClass().isArray()) {
                    int arraySize = Array.getLength(next);
                    if (arraySize <= 0) continue;
                    this.partialIterator = arraySize == 1 ? new OIterableObject<Object>(Array.get(next, 0)) : OMultiValue.getMultiValueIterator(next);
                    return true;
                }
                this.partialIterator = new OIterableObject(next);
                return true;
            }
        }
        return false;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public OMultiCollectionIterator<T> setEmbedded(boolean embedded) {
        this.embedded = embedded;
        return this;
    }

    public String toString() {
        return "[" + this.size() + "]";
    }
}

