/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.lock;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.concur.lock.OAbstractLock;
import com.orientechnologies.common.concur.lock.OLockException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class OAdaptiveLock
extends OAbstractLock {
    private final ReentrantLock lock = new ReentrantLock();
    private final boolean concurrent;
    private final int timeout;
    private final boolean ignoreThreadInterruption;

    public OAdaptiveLock() {
        this.concurrent = true;
        this.timeout = 0;
        this.ignoreThreadInterruption = false;
    }

    public OAdaptiveLock(int iTimeout) {
        this.concurrent = true;
        this.timeout = iTimeout;
        this.ignoreThreadInterruption = false;
    }

    public OAdaptiveLock(boolean iConcurrent) {
        this.concurrent = iConcurrent;
        this.timeout = 0;
        this.ignoreThreadInterruption = false;
    }

    public OAdaptiveLock(boolean iConcurrent, int iTimeout, boolean ignoreThreadInterruption) {
        this.concurrent = iConcurrent;
        this.timeout = iTimeout;
        this.ignoreThreadInterruption = ignoreThreadInterruption;
    }

    @Override
    public void lock() {
        if (this.concurrent) {
            if (this.timeout > 0) {
                try {
                    if (this.lock.tryLock(this.timeout, TimeUnit.MILLISECONDS)) {
                        return;
                    }
                }
                catch (InterruptedException e) {
                    if (this.ignoreThreadInterruption) {
                        try {
                            if (this.lock.tryLock(this.timeout, TimeUnit.MILLISECONDS)) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                        }
                        catch (InterruptedException e2) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    throw new OLockException("Thread interrupted while waiting for resource of class '" + this.getClass() + "' with timeout=" + this.timeout);
                }
                throw new OTimeoutException("Timeout on acquiring lock against resource of class: " + this.getClass() + " with timeout=" + this.timeout);
            }
            this.lock.lock();
        }
    }

    public boolean tryAcquireLock() {
        return this.tryAcquireLock(this.timeout, TimeUnit.MILLISECONDS);
    }

    public boolean tryAcquireLock(long iTimeout, TimeUnit iUnit) {
        if (this.concurrent) {
            if (this.timeout > 0) {
                try {
                    return this.lock.tryLock(iTimeout, iUnit);
                }
                catch (InterruptedException e) {
                    throw new OLockException("Thread interrupted while waiting for resource of class '" + this.getClass() + "' with timeout=" + this.timeout);
                }
            }
            return this.lock.tryLock();
        }
        return true;
    }

    @Override
    public void unlock() {
        if (this.concurrent) {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        try {
            if (this.lock.isLocked()) {
                this.lock.unlock();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isConcurrent() {
        return this.concurrent;
    }

    public ReentrantLock getUnderlying() {
        return this.lock;
    }

    public boolean isHeldByCurrentThread() {
        return this.lock.isHeldByCurrentThread();
    }
}

