/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.lock;

import com.orientechnologies.common.concur.lock.OModificationOperationProhibitedException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class OModificationLock {
    private final AtomicInteger vetos = new AtomicInteger();
    private volatile boolean throwException = false;
    private final ConcurrentLinkedQueue<Thread> waiters = new ConcurrentLinkedQueue();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public void requestModificationLock() {
        this.lock.readLock().lock();
        if (this.vetos.get() == 0) {
            return;
        }
        if (this.throwException) {
            this.lock.readLock().unlock();
            throw new OModificationOperationProhibitedException("Modification requests are prohibited");
        }
        boolean wasInterrupted = false;
        Thread thread = Thread.currentThread();
        this.waiters.add(thread);
        while (this.vetos.get() > 0) {
            LockSupport.park(this);
            if (!Thread.interrupted()) continue;
            wasInterrupted = true;
        }
        this.waiters.remove(thread);
        if (wasInterrupted) {
            thread.interrupt();
        }
    }

    public void releaseModificationLock() {
        this.lock.readLock().unlock();
    }

    public void prohibitModifications() {
        this.prohibitModifications(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prohibitModifications(boolean throwException) {
        this.lock.writeLock().lock();
        try {
            this.throwException = throwException;
            this.vetos.incrementAndGet();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void allowModifications() {
        int currentVetos = this.vetos.decrementAndGet();
        if (currentVetos < 0) {
            throw new IllegalStateException("Bad state of modification lock. Modifications were prohibited less times than they will be allowed.");
        }
        for (Thread thread : this.waiters) {
            LockSupport.unpark(thread);
        }
    }
}

