/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.resource;

import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.concur.resource.OResourcePoolListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class OResourcePool<K, V> {
    protected final Semaphore sem;
    protected final Queue<V> resources = new ConcurrentLinkedQueue<V>();
    protected final Collection<V> unmodifiableresources;
    protected OResourcePoolListener<K, V> listener;

    public OResourcePool(int maxResources, OResourcePoolListener<K, V> listener) {
        if (maxResources < 1) {
            throw new IllegalArgumentException("iMaxResource must be major than 0");
        }
        this.listener = listener;
        this.sem = new Semaphore(maxResources, true);
        this.unmodifiableresources = Collections.unmodifiableCollection(this.resources);
    }

    public V getResource(K key, long maxWaitMillis, Object ... additionalArgs) throws OLockException {
        V res;
        try {
            if (!this.sem.tryAcquire(maxWaitMillis, TimeUnit.MILLISECONDS)) {
                throw new OLockException("No more resources available in pool. Requested resource: " + key);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OInterruptedException(e);
        }
        do {
            if ((res = this.resources.poll()) == null) continue;
            if (this.listener.reuseResource(key, additionalArgs, res)) break;
            res = null;
        } while (!this.resources.isEmpty());
        try {
            if (res == null) {
                res = this.listener.createNewResource(key, additionalArgs);
            }
            return res;
        }
        catch (RuntimeException e) {
            this.sem.release();
            throw e;
        }
        catch (Exception e) {
            this.sem.release();
            throw new OLockException("Error on creation of the new resource in the pool", e);
        }
    }

    public int getMaxResources() {
        return this.sem.availablePermits();
    }

    public int getAvailableResources() {
        return this.resources.size();
    }

    public boolean returnResource(V res) {
        this.resources.add(res);
        this.sem.release();
        return true;
    }

    public Collection<V> getResources() {
        return this.unmodifiableresources;
    }

    public void close() {
        this.sem.drainPermits();
    }

    public void remove(V res) {
        this.resources.remove(res);
        this.sem.release();
    }
}

