/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.directmemory;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.directmemory.OUnsafeMemory;
import com.orientechnologies.common.log.OLogManager;

class ODirectMemoryFactory {
    public static final ODirectMemoryFactory INSTANCE = new ODirectMemoryFactory();
    private static final ODirectMemory directMemory;

    ODirectMemoryFactory() {
    }

    public ODirectMemory directMemory() {
        return directMemory;
    }

    static {
        ODirectMemory localDirectMemory = null;
        try {
            Class<?> jnaClass = Class.forName("com.orientechnologies.nio.OJNADirectMemory");
            localDirectMemory = jnaClass == null ? null : (ODirectMemory)jnaClass.newInstance();
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (localDirectMemory == null) {
            try {
                Class<?> sunClass = Class.forName("sun.misc.Unsafe");
                if (sunClass != null) {
                    localDirectMemory = OUnsafeMemory.INSTANCE;
                    OLogManager.instance().warn(ODirectMemoryFactory.class, "Sun Unsafe direct  memory implementation is going to be used, this implementation is not stable so please use JNA version instead.", new Object[0]);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        directMemory = localDirectMemory;
    }
}

