/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.factory;

import com.orientechnologies.common.exception.OException;
import java.util.LinkedHashMap;
import java.util.Map;

public class OConfigurableStatefulFactory<K, V> {
    protected final Map<K, Class<? extends V>> registry = new LinkedHashMap<K, Class<? extends V>>();
    protected Class<? extends V> defaultClass;

    public Class<? extends V> get(K iKey) {
        return this.registry.get(iKey);
    }

    public V newInstance(K iKey) {
        if (iKey == null && this.defaultClass == null) {
            throw new IllegalArgumentException("Cannot create implementation for type null");
        }
        Class<V> cls = this.registry.get(iKey);
        if (cls != null) {
            try {
                return cls.newInstance();
            }
            catch (Exception e) {
                throw new OException(String.format("Error on creating new instance of class '%s' registered in factory with key '%s'", cls, iKey), e);
            }
        }
        return this.newInstanceOfDefaultClass();
    }

    public V newInstanceOfDefaultClass() {
        if (this.defaultClass != null) {
            try {
                return this.defaultClass.newInstance();
            }
            catch (Exception e) {
                throw new OException(String.format("Error on creating new instance of default class '%s'", this.defaultClass), e);
            }
        }
        return null;
    }

    public OConfigurableStatefulFactory<K, V> register(K iKey, Class<? extends V> iValue) {
        this.registry.put(iKey, iValue);
        return this;
    }

    public OConfigurableStatefulFactory<K, V> unregister(K iKey) {
        this.registry.remove(iKey);
        return this;
    }

    public OConfigurableStatefulFactory<K, V> unregisterAll() {
        this.registry.clear();
        return this;
    }

    public Class<? extends V> getDefaultClass() {
        return this.defaultClass;
    }

    public <C extends Class<? extends V>> OConfigurableStatefulFactory<K, V> setDefaultClass(C defaultClass) {
        this.defaultClass = defaultClass;
        return this;
    }
}

