/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.types.OBinarySerializer;

public class OByteSerializer
implements OBinarySerializer<Byte> {
    public static final int BYTE_SIZE = 1;
    public static OByteSerializer INSTANCE = new OByteSerializer();
    public static final byte ID = 2;

    @Override
    public int getObjectSize(Byte object, Object ... hints) {
        return 1;
    }

    @Override
    public void serialize(Byte object, byte[] stream, int startPosition, Object ... hints) {
        stream[startPosition] = object;
    }

    @Override
    public Byte deserialize(byte[] stream, int startPosition) {
        return stream[startPosition];
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 1;
    }

    @Override
    public byte getId() {
        return 2;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return this.getObjectSize(stream, startPosition);
    }

    @Override
    public void serializeNative(Byte object, byte[] stream, int startPosition, Object ... hints) {
        this.serialize(object, stream, startPosition, new Object[0]);
    }

    @Override
    public Byte deserializeNative(byte[] stream, int startPosition) {
        return this.deserialize(stream, startPosition);
    }

    @Override
    public void serializeInDirectMemory(Byte object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        pointer.setByte(offset, object);
    }

    @Override
    public Byte deserializeFromDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return pointer.getByte(offset);
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return 1;
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 1;
    }

    @Override
    public Byte preprocess(Byte value, Object ... hints) {
        return value;
    }
}

