/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OBinaryTypeSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ODecimalSerializer
implements OBinarySerializer<BigDecimal> {
    public static final ODecimalSerializer INSTANCE = new ODecimalSerializer();
    public static final byte ID = 18;

    @Override
    public int getObjectSize(BigDecimal object, Object ... hints) {
        return 4 + OBinaryTypeSerializer.INSTANCE.getObjectSize(object.unscaledValue().toByteArray(), new Object[0]);
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        int size = 4 + OBinaryTypeSerializer.INSTANCE.getObjectSize(stream, startPosition + 4);
        return size;
    }

    @Override
    public void serialize(BigDecimal object, byte[] stream, int startPosition, Object ... hints) {
        OIntegerSerializer.INSTANCE.serialize(object.scale(), stream, startPosition, new Object[0]);
        OBinaryTypeSerializer.INSTANCE.serialize(object.unscaledValue().toByteArray(), stream, startPosition += 4, new Object[0]);
    }

    @Override
    public BigDecimal deserialize(byte[] stream, int startPosition) {
        int scale = OIntegerSerializer.INSTANCE.deserialize(stream, startPosition);
        byte[] unscaledValue = OBinaryTypeSerializer.INSTANCE.deserialize(stream, startPosition += 4);
        return new BigDecimal(new BigInteger(unscaledValue), scale);
    }

    @Override
    public byte getId() {
        return 18;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        int size = 4 + OBinaryTypeSerializer.INSTANCE.getObjectSizeNative(stream, startPosition + 4);
        return size;
    }

    @Override
    public void serializeNative(BigDecimal object, byte[] stream, int startPosition, Object ... hints) {
        OIntegerSerializer.INSTANCE.serializeNative(object.scale(), stream, startPosition, new Object[0]);
        OBinaryTypeSerializer.INSTANCE.serializeNative(object.unscaledValue().toByteArray(), stream, startPosition += 4, new Object[0]);
    }

    @Override
    public BigDecimal deserializeNative(byte[] stream, int startPosition) {
        int scale = OIntegerSerializer.INSTANCE.deserializeNative(stream, startPosition);
        byte[] unscaledValue = OBinaryTypeSerializer.INSTANCE.deserializeNative(stream, startPosition += 4);
        return new BigDecimal(new BigInteger(unscaledValue), scale);
    }

    @Override
    public void serializeInDirectMemory(BigDecimal object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        OIntegerSerializer.INSTANCE.serializeInDirectMemory(object.scale(), pointer, offset, new Object[0]);
        OBinaryTypeSerializer.INSTANCE.serializeInDirectMemory(object.unscaledValue().toByteArray(), pointer, offset += 4L, new Object[0]);
    }

    @Override
    public BigDecimal deserializeFromDirectMemory(ODirectMemoryPointer pointer, long offset) {
        int scale = pointer.getInt(offset);
        byte[] unscaledValue = OBinaryTypeSerializer.INSTANCE.deserializeFromDirectMemory(pointer, offset += 4L);
        return new BigDecimal(new BigInteger(unscaledValue), scale);
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemoryPointer pointer, long offset) {
        int size = 4 + OBinaryTypeSerializer.INSTANCE.getObjectSizeInDirectMemory(pointer, offset + 4L);
        return size;
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public int getFixedLength() {
        return 0;
    }

    @Override
    public BigDecimal preprocess(BigDecimal value, Object ... hints) {
        return value;
    }
}

