/*
 * Decompiled with CFR 0.152.
 */
package com.plumelog.log4j.appender;

import com.plumelog.core.AbstractClient;
import com.plumelog.core.MessageAppenderFactory;
import com.plumelog.core.constant.LogMessageConstant;
import com.plumelog.core.dto.BaseLogMessage;
import com.plumelog.core.dto.RunLogMessage;
import com.plumelog.core.kafka.KafkaProducerClient;
import com.plumelog.core.util.GfJsonUtil;
import com.plumelog.core.util.ThreadPoolUtil;
import com.plumelog.log4j.util.LogMessageUtil;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class KafkaAppender
extends AppenderSkeleton {
    private static final AtomicBoolean INIT = new AtomicBoolean();
    private static final ThreadPoolExecutor threadPoolExecutor = ThreadPoolUtil.getPool();
    private KafkaProducerClient kafkaClient;
    private String appName;
    private String env = "default";
    private String kafkaHosts;
    private String runModel;
    private int maxCount = 100;
    private int logQueueSize = 10000;
    private final int threadPoolSize = 1;
    private boolean compressor = false;

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setKafkaHosts(String kafkaHosts) {
        this.kafkaHosts = kafkaHosts;
    }

    public void setRunModel(String runModel) {
        this.runModel = runModel;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public void setLogQueueSize(int logQueueSize) {
        this.logQueueSize = logQueueSize;
    }

    public void setKafkaClient(KafkaProducerClient kafkaClient) {
        this.kafkaClient = kafkaClient;
    }

    public void setCompressor(boolean compressor) {
        this.compressor = compressor;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    protected void append(LoggingEvent loggingEvent) {
        BaseLogMessage logMessage;
        if (this.runModel != null) {
            LogMessageConstant.RUN_MODEL = Integer.parseInt(this.runModel);
        }
        if (this.kafkaClient == null) {
            MessageAppenderFactory.initQueue((int)this.logQueueSize);
            this.kafkaClient = KafkaProducerClient.getInstance((String)this.kafkaHosts, (String)(this.compressor ? "lz4" : "none"));
            if (INIT.compareAndSet(false, true)) {
                for (int a = 0; a < this.threadPoolSize; ++a) {
                    threadPoolExecutor.execute(() -> MessageAppenderFactory.startRunLog((AbstractClient)this.kafkaClient, (int)this.maxCount));
                    threadPoolExecutor.execute(() -> MessageAppenderFactory.startTraceLog((AbstractClient)this.kafkaClient, (int)this.maxCount));
                }
            }
        }
        if ((logMessage = LogMessageUtil.getLogMessage(this.appName, this.env, loggingEvent)) instanceof RunLogMessage) {
            String message = LogMessageUtil.getLogMessage(logMessage, loggingEvent);
            MessageAppenderFactory.pushRundataQueue((String)message);
        } else {
            MessageAppenderFactory.pushTracedataQueue((String)GfJsonUtil.toJSONString((Object)logMessage));
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }
}

