/*
 * Decompiled with CFR 0.152.
 */
package com.plumelog.log4j.util;

import com.plumelog.core.LogMessageThreadLocal;
import com.plumelog.core.TraceMessage;
import com.plumelog.core.dto.BaseLogMessage;
import com.plumelog.core.dto.RunLogMessage;
import com.plumelog.core.util.DateUtil;
import com.plumelog.core.util.GfJsonUtil;
import com.plumelog.core.util.LogExceptionStackTrace;
import com.plumelog.core.util.TraceLogMessageFactory;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class LogMessageUtil {
    private static final AtomicLong SEQ_BUILDER = new AtomicLong();

    public static BaseLogMessage getLogMessage(String appName, String env, LoggingEvent loggingEvent) {
        TraceMessage traceMessage = (TraceMessage)LogMessageThreadLocal.logMessageThreadLocal.get();
        String formattedMessage = LogMessageUtil.getMessage(loggingEvent);
        if (formattedMessage.startsWith("TRACE:")) {
            return TraceLogMessageFactory.getTraceLogMessage((TraceMessage)traceMessage, (String)appName, (String)env, (long)loggingEvent.getTimeStamp());
        }
        RunLogMessage logMessage = TraceLogMessageFactory.getLogMessage((String)appName, (String)env, (String)formattedMessage, (long)loggingEvent.getTimeStamp());
        logMessage.setClassName(loggingEvent.getLoggerName());
        logMessage.setThreadName(loggingEvent.getThreadName());
        logMessage.setSeq(Long.valueOf(SEQ_BUILDER.getAndIncrement()));
        LocationInfo locationInfo = loggingEvent.getLocationInformation();
        String method = locationInfo.getMethodName();
        String line = locationInfo.getLineNumber();
        logMessage.setMethod(method + "(" + locationInfo.getFileName() + ":" + line + ")");
        logMessage.setDateTime(DateUtil.getDatetimeNormalStrWithMills((long)loggingEvent.getTimeStamp()));
        logMessage.setLogLevel(loggingEvent.getLevel().toString());
        return logMessage;
    }

    public static String getLogMessage(BaseLogMessage baseLogMessage, LoggingEvent logEvent) {
        Map mdc = logEvent.getProperties();
        Map map = (Map)GfJsonUtil.parseObject((String)GfJsonUtil.toJSONString((Object)baseLogMessage), Map.class);
        if (mdc != null) {
            map.putAll(mdc);
        }
        return GfJsonUtil.toJSONString((Object)map);
    }

    private static String getMessage(LoggingEvent logEvent) {
        if (logEvent.getLevel().toInt() == 40000) {
            String msg = "";
            if (logEvent.getThrowableInformation() != null) {
                msg = LogExceptionStackTrace.erroStackTrace((Object)logEvent.getThrowableInformation().getThrowable()).toString();
            }
            if (logEvent.getRenderedMessage() != null && logEvent.getRenderedMessage().contains("{}")) {
                FormattingTuple format = MessageFormatter.format((String)logEvent.getRenderedMessage(), (Object)msg);
                return format.getMessage();
            }
            return logEvent.getRenderedMessage() + "\n" + msg;
        }
        return logEvent.getRenderedMessage();
    }
}

