/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx.adapters;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;

public class YearMonthAdapter
extends XmlAdapter<String, YearMonth> {
    private static String YEAR_MONTH_FORMAT = "yyyy-MM";
    private DateTimeFormatter dtf = DateTimeFormatter.ofPattern(YEAR_MONTH_FORMAT);

    public YearMonthAdapter() {
    }

    public YearMonthAdapter(DateTimeFormatter dtf) {
        this.dtf = dtf;
    }

    public YearMonth unmarshal(String value) throws Exception {
        return YearMonth.parse(value, this.dtf);
    }

    public String marshal(YearMonth value) throws Exception {
        if (value != null) {
            return this.dtf.format(value);
        }
        return null;
    }

    public String toString() {
        return "YearMonthAdapter{ " + YEAR_MONTH_FORMAT + " }";
    }
}

