/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx.adapters;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZuluOffsetDateTimeAdapter
extends XmlAdapter<String, OffsetDateTime> {
    private static final Logger log = Logger.getLogger(ZuluOffsetDateTimeAdapter.class.getName());
    private static final String FRACTIONAL_SECONDS_REGEX = "\\.0{1,}[Z+-]";
    private static final Pattern FRACTIONAL_SECONDS_PATTERN = Pattern.compile("\\.0{1,}[Z+-]");
    private final DateTimeFormatter marshalFormat = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().appendPattern("'Z'").toFormatter().withZone(ZoneOffset.UTC);

    public OffsetDateTime unmarshal(String value) {
        return ZuluOffsetDateTimeAdapter.parseOffsetDateTime(value);
    }

    public String marshal(OffsetDateTime offsetDateTime) throws Exception {
        OffsetDateTime utcDateTime = offsetDateTime.withOffsetSameInstant(ZoneOffset.UTC);
        String formatted = ZuluOffsetDateTimeAdapter.formatOffsetDateTime(this.marshalFormat, utcDateTime);
        Matcher matcher = FRACTIONAL_SECONDS_PATTERN.matcher(formatted);
        if (matcher.find()) {
            formatted = formatted.replace(matcher.group(), "Z");
        }
        return formatted;
    }

    private static OffsetDateTime parseOffsetDateTime(String value) {
        if (value == null) {
            return null;
        }
        try {
            return OffsetDateTime.parse(value);
        }
        catch (DateTimeParseException e) {
            log.log(Level.FINEST, "Error parsing OffsetDateTime: " + e.getMessage());
            try {
                LocalDateTime localDateTime = LocalDateTime.parse(value);
                return localDateTime.atZone(ZoneId.systemDefault()).toOffsetDateTime();
            }
            catch (DateTimeParseException e2) {
                log.log(Level.FINEST, "Error parsing LocalDateTime: " + e2.getMessage());
                return null;
            }
        }
    }

    private static String formatOffsetDateTime(DateTimeFormatter dateTimeFormatter, OffsetDateTime offsetDateTime) {
        return dateTimeFormatter.format(offsetDateTime);
    }

    public String toString() {
        return "ZuluOffsetDateTimeAdapter{ yyyy-MM-dd'T'HH:mm:ss[.SSS]Z }";
    }
}

