/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.autoconfiguration;

import com.sap.cloud.security.xsuaa.XsuaaServiceConfiguration;
import com.sap.cloud.security.xsuaa.token.authentication.XsuaaJwtDecoderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.oauth2.resource.servlet.OAuth2ResourceServerAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.web.client.RestOperations;

@Configuration
@ConditionalOnClass(value={Jwt.class})
@ConditionalOnProperty(prefix="spring.xsuaa", name={"auto"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(value={OAuth2ResourceServerAutoConfiguration.class})
public class XsuaaResourceServerJwkAutoConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Bean
    @ConditionalOnBean(value={XsuaaServiceConfiguration.class, RestOperations.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnMissingBean
    public JwtDecoder xsuaaJwtDecoder(XsuaaServiceConfiguration xsuaaServiceConfiguration, RestOperations xsuaaRestOperations) {
        this.logger.debug("auto-configures JwtDecoder using restOperations of type: {}", (Object)xsuaaRestOperations);
        return new XsuaaJwtDecoderBuilder(xsuaaServiceConfiguration).withRestOperations(xsuaaRestOperations).build();
    }
}

