/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.token.authentication.httpclient;

import com.sap.cloud.security.client.HttpClientException;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.mtls.SSLContextFactory;
import com.sap.cloud.security.xsuaa.token.authentication.httpclient.SpringHttpClientFactory;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class DefaultSpringHttpClientFactory
implements SpringHttpClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSpringHttpClientFactory.class);
    final Set<String> httpClientsCreated = Collections.synchronizedSet(new HashSet());
    final ConcurrentHashMap<String, HttpClientConnectionManager> sslConnectionManagers = new ConcurrentHashMap();
    private static final Timeout DEFAULT_TIMEOUT = Timeout.ofSeconds((long)5L);
    private static final Timeout DEFAULT_SOCKET_TIMEOUT = Timeout.ofSeconds((long)5L);
    private static final int MAX_CONNECTIONS_PER_ROUTE = 4;
    private static final int MAX_CONNECTIONS = 20;

    @Override
    public RestTemplate createRestTemplateClient(ClientIdentity clientIdentity) {
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpClient((HttpClient)this.createClient(clientIdentity));
        return new RestTemplate((ClientHttpRequestFactory)requestFactory);
    }

    private CloseableHttpClient createClient(ClientIdentity clientIdentity) throws HttpClientException {
        String clientId;
        String string = clientId = clientIdentity != null ? clientIdentity.getId() : null;
        if (this.httpClientsCreated.contains(clientId)) {
            LOGGER.warn("Application has already created HttpClient for clientId = {}, please check.", (Object)clientId);
        }
        this.httpClientsCreated.add(clientId);
        if (clientId == null || !clientIdentity.isCertificateBased()) {
            return HttpClients.custom().disableRedirectHandling().build();
        }
        return this.createTLSClient(clientIdentity);
    }

    private CloseableHttpClient createTLSClient(ClientIdentity clientIdentity) {
        SSLContext context;
        RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectionRequestTimeout(DEFAULT_TIMEOUT).setRedirectsEnabled(false).build();
        ConnectionConfig defaultConnectionConfig = ConnectionConfig.custom().setSocketTimeout(DEFAULT_SOCKET_TIMEOUT).setConnectTimeout(DEFAULT_TIMEOUT).build();
        try {
            context = SSLContextFactory.getInstance().create(clientIdentity);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new HttpClientException(String.format("Couldn't set up https client for service provider %s. %s.", clientIdentity.getId(), e.getLocalizedMessage()));
        }
        HttpClientConnectionManager connectionManager = this.sslConnectionManagers.computeIfAbsent(clientIdentity.getId(), cid -> PoolingHttpClientConnectionManagerBuilder.create().setDefaultConnectionConfig(defaultConnectionConfig).setMaxConnPerRoute(4).setMaxConnTotal(20).setSSLSocketFactory((LayeredConnectionSocketFactory)SSLConnectionSocketFactoryBuilder.create().setTlsVersions(new TLS[]{TLS.V_1_2}).setSslContext(context).build()).build());
        return HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).setConnectionManager(connectionManager).build();
    }
}

