/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.tigervnc.network.Socket;
import com.tigervnc.network.TcpSocket;
import com.tigervnc.rdr.FdInStreamBlockCallback;
import com.tigervnc.rdr.MemInStream;
import com.tigervnc.rdr.MemOutStream;
import com.tigervnc.rfb.CConnection;
import com.tigervnc.rfb.CSecurityTLS;
import com.tigervnc.rfb.Encodings;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.Hostname;
import com.tigervnc.rfb.Keysyms;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Point;
import com.tigervnc.rfb.Rect;
import com.tigervnc.rfb.Screen;
import com.tigervnc.rfb.ScreenSet;
import com.tigervnc.rfb.Security;
import com.tigervnc.rfb.UserMsgBox;
import com.tigervnc.rfb.UserPasswdGetter;
import com.tigervnc.rfb.VncAuth;
import com.tigervnc.vncviewer.ClipboardDialog;
import com.tigervnc.vncviewer.DesktopWindow;
import com.tigervnc.vncviewer.F8Menu;
import com.tigervnc.vncviewer.MenuKey;
import com.tigervnc.vncviewer.OptionsDialog;
import com.tigervnc.vncviewer.OptionsDialogCallback;
import com.tigervnc.vncviewer.PasswdDialog;
import com.tigervnc.vncviewer.ServerDialog;
import com.tigervnc.vncviewer.Tunnel;
import com.tigervnc.vncviewer.UserPreferences;
import com.tigervnc.vncviewer.Viewport;
import com.tigervnc.vncviewer.VncViewer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class CConn
extends CConnection
implements UserPasswdGetter,
UserMsgBox,
OptionsDialogCallback,
FdInStreamBlockCallback,
ActionListener {
    static final PixelFormat verylowColourPF = new PixelFormat(8, 3, false, true, 1, 1, 1, 2, 1, 0);
    static final PixelFormat lowColourPF = new PixelFormat(8, 6, false, true, 3, 3, 3, 4, 2, 0);
    static final PixelFormat mediumColourPF = new PixelFormat(8, 8, false, false, 7, 7, 3, 0, 3, 6);
    static final int KEY_LOC_SHIFT_R = 0;
    static final int KEY_LOC_SHIFT_L = 16;
    static final int SUPER_MASK = 32768;
    VncViewer viewer;
    public static UserPasswdGetter upg;
    public UserMsgBox msg;
    boolean shuttingDown = false;
    int lowColourLevel;
    F8Menu menu;
    OptionsDialog options;
    ClipboardDialog clipboardDialog;
    int buttonMask;
    private Socket sock;
    protected DesktopWindow desktop;
    public PixelFormat serverPF;
    private PixelFormat fullColourPF;
    private boolean pendingPFChange;
    private PixelFormat pendingPF;
    private int currentEncoding;
    private int lastServerEncoding;
    private boolean formatChange;
    private boolean encodingChange;
    private boolean firstUpdate;
    private boolean pendingUpdate;
    private boolean continuousUpdates;
    private boolean forceNonincremental;
    private boolean supportsSyncFence;
    public int menuKeyCode;
    Viewport viewport;
    private boolean fullColour;
    private boolean autoSelect;
    boolean fullScreen;
    private HashMap<Integer, Integer> downKeySym;
    public ActionListener closeListener = null;
    static LogWriter vlog;

    @Override
    public final PixelFormat getPreferredPF() {
        return this.fullColourPF;
    }

    public CConn(VncViewer viewer_, Socket sock_, String vncServerName) {
        this.sock = sock_;
        this.viewer = viewer_;
        this.pendingPFChange = false;
        this.currentEncoding = 7;
        this.lastServerEncoding = -1;
        this.fullColour = this.viewer.fullColour.getValue();
        this.lowColourLevel = this.viewer.lowColourLevel.getValue();
        this.autoSelect = this.viewer.autoSelect.getValue();
        this.formatChange = false;
        this.encodingChange = false;
        this.fullScreen = this.viewer.fullScreen.getValue();
        this.menuKeyCode = MenuKey.getMenuKeyCode();
        this.options = new OptionsDialog(this);
        this.options.initDialog();
        this.clipboardDialog = new ClipboardDialog(this);
        this.firstUpdate = true;
        this.pendingUpdate = false;
        this.continuousUpdates = false;
        this.forceNonincremental = true;
        this.supportsSyncFence = false;
        this.downKeySym = new HashMap();
        this.setShared(this.viewer.shared.getValue());
        upg = this;
        this.msg = this;
        String encStr = this.viewer.preferredEncoding.getValue();
        int encNum = Encodings.encodingNum(encStr);
        if (encNum != -1) {
            this.currentEncoding = encNum;
        }
        this.cp.supportsDesktopResize = true;
        this.cp.supportsExtendedDesktopSize = true;
        this.cp.supportsSetDesktopSize = false;
        this.cp.supportsClientRedirect = true;
        this.cp.supportsDesktopRename = true;
        this.cp.supportsLocalCursor = this.viewer.useLocalCursor.getValue();
        this.cp.customCompressLevel = this.viewer.customCompressLevel.getValue();
        this.cp.compressLevel = this.viewer.compressLevel.getValue();
        this.cp.noJpeg = this.viewer.noJpeg.getValue();
        this.cp.qualityLevel = this.viewer.qualityLevel.getValue();
        this.initMenu();
        if (this.sock != null) {
            String name = this.sock.getPeerEndpoint();
            vlog.info("Accepted connection from " + name);
        } else {
            if (vncServerName != null && !this.viewer.alwaysShowServerDialog.getValue()) {
                this.setServerName(Hostname.getHost(vncServerName));
                this.setServerPort(Hostname.getPort(vncServerName));
            } else {
                ServerDialog dlg = new ServerDialog(this.options, vncServerName, this);
                boolean ret = dlg.showDialog();
                if (!ret) {
                    this.close();
                    return;
                }
                this.setServerName(this.viewer.vncServerName.getValueStr());
                this.setServerPort(this.viewer.vncServerPort.getValue());
            }
            try {
                if (this.viewer.tunnel.getValue() || this.viewer.via.getValue() != null) {
                    int localPort = TcpSocket.findFreeTcpPort();
                    if (localPort == 0) {
                        throw new Exception("Could not obtain free TCP port");
                    }
                    Tunnel.createTunnel(this, localPort);
                    this.sock = new TcpSocket("localhost", localPort);
                } else {
                    this.sock = new TcpSocket(this.getServerName(), this.getServerPort());
                }
            }
            catch (java.lang.Exception e) {
                throw new Exception(e.getMessage());
            }
            vlog.info("connected to host " + this.getServerName() + " port " + this.getServerPort());
        }
        this.sock.inStream().setBlockCallback(this);
        this.setStreams(this.sock.inStream(), this.sock.outStream());
        this.initialiseProtocol();
    }

    public void refreshFramebuffer() {
        this.forceNonincremental = true;
        if (this.supportsSyncFence) {
            this.requestNewUpdate();
        }
    }

    @Override
    public boolean showMsgBox(int flags, String title, String text) {
        return true;
    }

    void deleteWindow() {
        if (this.viewport != null) {
            this.viewport.dispose();
        }
        this.viewport = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockCallback() {
        try {
            CConn cConn = this;
            synchronized (cConn) {
                this.wait(1L);
            }
        }
        catch (InterruptedException e) {
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public final boolean getUserPasswd(StringBuffer user, StringBuffer passwd) {
        PasswdDialog dlg;
        String title = "VNC Authentication [" + this.csecurity.description() + "]";
        String passwordFileStr = this.viewer.passwordFile.getValue();
        if (user == null && !passwordFileStr.equals("")) {
            FileInputStream fp = null;
            try {
                fp = new FileInputStream(passwordFileStr);
            }
            catch (FileNotFoundException e) {
                throw new Exception("Opening password file failed");
            }
            byte[] obfPwd = new byte[256];
            try {
                ((InputStream)fp).read(obfPwd);
                ((InputStream)fp).close();
            }
            catch (IOException e) {
                throw new Exception("Failed to read VncPasswd file");
            }
            String PlainPasswd = VncAuth.unobfuscatePasswd(obfPwd);
            passwd.append(PlainPasswd);
            passwd.setLength(PlainPasswd.length());
            return true;
        }
        if (user == null) {
            dlg = new PasswdDialog(title, user == null, passwd == null);
        } else {
            if (passwd == null && this.viewer.sendLocalUsername.getValue()) {
                user.append((String)System.getProperties().get("user.name"));
                return true;
            }
            dlg = new PasswdDialog(title, this.viewer.sendLocalUsername.getValue(), passwd == null);
        }
        if (!dlg.showDialog()) {
            return false;
        }
        if (user != null) {
            if (this.viewer.sendLocalUsername.getValue()) {
                user.append((String)System.getProperties().get("user.name"));
            } else {
                user.append(dlg.userEntry.getText());
            }
        }
        if (passwd != null) {
            passwd.append(new String(dlg.passwdEntry.getPassword()));
        }
        return true;
    }

    @Override
    public void serverInit() {
        super.serverInit();
        if (this.cp.beforeVersion(3, 8) && this.autoSelect) {
            this.fullColour = true;
        }
        this.serverPF = this.cp.pf();
        this.desktop = new DesktopWindow(this.cp.width, this.cp.height, this.serverPF, this);
        this.fullColourPF = this.desktop.getPreferredPF();
        this.formatChange = true;
        this.encodingChange = true;
        this.requestNewUpdate();
        assert (this.pendingPFChange);
        this.desktop.setServerPF(this.pendingPF);
        this.cp.setPF(this.pendingPF);
        this.pendingPFChange = false;
        if (this.viewer.embed.getValue()) {
            this.setupEmbeddedFrame();
        } else {
            this.recreateViewport();
        }
    }

    void setupEmbeddedFrame() {
        UIManager.getDefaults().put("ScrollPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[0]));
        JScrollPane sp = new JScrollPane();
        sp.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        sp.getViewport().setBackground(Color.BLACK);
        InputMap im = sp.getInputMap(2);
        int ctrlAltShiftMask = 11;
        if (im != null) {
            im.put(KeyStroke.getKeyStroke(38, ctrlAltShiftMask), "unitScrollUp");
            im.put(KeyStroke.getKeyStroke(40, ctrlAltShiftMask), "unitScrollDown");
            im.put(KeyStroke.getKeyStroke(37, ctrlAltShiftMask), "unitScrollLeft");
            im.put(KeyStroke.getKeyStroke(39, ctrlAltShiftMask), "unitScrollRight");
            im.put(KeyStroke.getKeyStroke(33, ctrlAltShiftMask), "scrollUp");
            im.put(KeyStroke.getKeyStroke(34, ctrlAltShiftMask), "scrollDown");
            im.put(KeyStroke.getKeyStroke(36, ctrlAltShiftMask), "scrollLeft");
            im.put(KeyStroke.getKeyStroke(35, ctrlAltShiftMask), "scrollRight");
        }
        sp.setHorizontalScrollBarPolicy(30);
        sp.setVerticalScrollBarPolicy(20);
        this.desktop.setViewport(sp.getViewport());
        this.viewer.getContentPane().removeAll();
        this.viewer.add(sp);
        this.viewer.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (CConn.this.desktop.isAncestorOf(CConn.this.viewer)) {
                    CConn.this.desktop.requestFocus();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                CConn.this.releaseDownKeys();
            }
        });
        this.viewer.validate();
        this.desktop.requestFocus();
    }

    @Override
    public void setDesktopSize(int w, int h) {
        super.setDesktopSize(w, h);
        this.resizeFramebuffer();
    }

    @Override
    public void setExtendedDesktopSize(int reason, int result, int w, int h, ScreenSet layout) {
        super.setExtendedDesktopSize(reason, result, w, h, layout);
        if (reason == 1 && result != 0) {
            vlog.error("SetDesktopSize failed: " + result);
            return;
        }
        this.resizeFramebuffer();
    }

    @Override
    public void clientRedirect(int port, String host, String x509subject) {
        try {
            this.sock.close();
            this.setServerPort(port);
            this.sock = new TcpSocket(host, port);
            vlog.info("Redirected to " + host + ":" + port);
            VncViewer.newViewer(this.viewer, this.sock, true);
        }
        catch (java.lang.Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.viewport != null) {
            this.viewport.setTitle(name + " - TigerVNC");
        }
    }

    @Override
    public void framebufferUpdateStart() {
        this.pendingUpdate = false;
        this.requestNewUpdate();
    }

    @Override
    public void framebufferUpdateEnd() {
        this.desktop.updateWindow();
        if (this.firstUpdate) {
            if (this.cp.supportsFence) {
                this.writer().writeFence(-2147483644, 0, null);
            }
            if (this.cp.supportsSetDesktopSize && this.viewer.desktopSize.getValue() != null && this.viewer.desktopSize.getValue().split("x").length == 2) {
                int width = Integer.parseInt(this.viewer.desktopSize.getValue().split("x")[0]);
                int height = Integer.parseInt(this.viewer.desktopSize.getValue().split("x")[1]);
                ScreenSet layout = this.cp.screenLayout;
                if (layout.num_screens() == 0) {
                    layout.add_screen(new Screen());
                } else if (layout.num_screens() != 1) {
                    while (true) {
                        Iterator<Screen> iter = layout.screens.iterator();
                        Screen screen = iter.next();
                        if (!iter.hasNext()) break;
                        layout.remove_screen(screen.id);
                    }
                }
                Screen screen0 = layout.screens.iterator().next();
                screen0.dimensions.tl.x = 0;
                screen0.dimensions.tl.y = 0;
                screen0.dimensions.br.x = width;
                screen0.dimensions.br.y = height;
                this.writer().writeSetDesktopSize(width, height, layout);
            }
            this.firstUpdate = false;
        }
        if (this.pendingPFChange) {
            this.desktop.setServerPF(this.pendingPF);
            this.cp.setPF(this.pendingPF);
            this.pendingPFChange = false;
        }
        if (this.autoSelect) {
            this.autoSelectFormatAndEncoding();
        }
    }

    @Override
    public void setColourMapEntries(int firstColour, int nColours, int[] rgbs) {
        this.desktop.setColourMapEntries(firstColour, nColours, rgbs);
    }

    @Override
    public void bell() {
        if (this.viewer.acceptBell.getValue()) {
            this.desktop.getToolkit().beep();
        }
    }

    @Override
    public void serverCutText(String str, int len) {
        if (this.viewer.acceptClipboard.getValue()) {
            this.clipboardDialog.serverCutText(str, len);
        }
    }

    @Override
    public void beginRect(Rect r, int encoding) {
        this.sock.inStream().startTiming();
        if (encoding != 1) {
            this.lastServerEncoding = encoding;
        }
    }

    @Override
    public void endRect(Rect r, int encoding) {
        this.sock.inStream().stopTiming();
    }

    @Override
    public void fillRect(Rect r, int p) {
        this.desktop.fillRect(r.tl.x, r.tl.y, r.width(), r.height(), p);
    }

    @Override
    public void imageRect(Rect r, Object p) {
        this.desktop.imageRect(r.tl.x, r.tl.y, r.width(), r.height(), p);
    }

    @Override
    public void copyRect(Rect r, int sx, int sy) {
        this.desktop.copyRect(r.tl.x, r.tl.y, r.width(), r.height(), sx, sy);
    }

    @Override
    public void setCursor(int width, int height, Point hotspot, int[] data, byte[] mask) {
        this.desktop.setCursor(width, height, hotspot, data, mask);
    }

    @Override
    public void fence(int flags, int len, byte[] data) {
        this.cp.supportsFence = true;
        if ((flags & Integer.MIN_VALUE) != 0) {
            this.writer().writeFence(flags &= 3, len, data);
            return;
        }
        if (len == 0) {
            if ((flags & 4) != 0) {
                this.supportsSyncFence = true;
                if (this.cp.supportsContinuousUpdates) {
                    vlog.info("Enabling continuous updates");
                    this.continuousUpdates = true;
                    this.writer().writeEnableContinuousUpdates(true, 0, 0, this.cp.width, this.cp.height);
                }
            }
        } else {
            MemInStream memStream = new MemInStream(data, 0, len);
            PixelFormat pf = new PixelFormat();
            pf.read(memStream);
            this.desktop.setServerPF(pf);
            this.cp.setPF(pf);
        }
    }

    private void resizeFramebuffer() {
        if (this.desktop == null) {
            return;
        }
        if (this.continuousUpdates) {
            this.writer().writeEnableContinuousUpdates(true, 0, 0, this.cp.width, this.cp.height);
        }
        if (this.cp.width == 0 && this.cp.height == 0) {
            return;
        }
        if (this.desktop.width() == this.cp.width && this.desktop.height() == this.cp.height) {
            return;
        }
        this.desktop.resize();
        if (this.viewer.embed.getValue()) {
            this.setupEmbeddedFrame();
        } else {
            this.recreateViewport();
        }
    }

    public void setEmbeddedFeatures(boolean s) {
        this.menu.restore.setEnabled(s);
        this.menu.minimize.setEnabled(s);
        this.menu.maximize.setEnabled(s);
        this.menu.fullScreen.setEnabled(s);
        this.menu.newConn.setEnabled(s);
        this.options.fullScreen.setEnabled(s);
        this.options.fullScreenAllMonitors.setEnabled(s);
        this.options.scalingFactor.setEnabled(s);
    }

    public void recreateViewport() {
        if (this.viewer.embed.getValue()) {
            return;
        }
        if (this.viewport != null) {
            this.viewport.dispose();
        }
        this.viewport = new Viewport(this.cp.name(), this);
        this.viewport.setUndecorated(this.fullScreen);
        this.desktop.setViewport(this.viewport.getViewport());
        this.reconfigureViewport();
        if (this.cp.width > 0 && this.cp.height > 0) {
            this.viewport.setVisible(true);
        }
        this.desktop.requestFocusInWindow();
    }

    private void reconfigureViewport() {
        Dimension dpySize = this.viewport.getScreenSize();
        int w = this.desktop.scaledWidth;
        int h = this.desktop.scaledHeight;
        if (this.fullScreen) {
            if (!this.viewer.fullScreenAllMonitors.getValue()) {
                this.viewport.setExtendedState(6);
            }
            this.viewport.setBounds(this.viewport.getScreenBounds());
            if (!this.viewer.fullScreenAllMonitors.getValue()) {
                Viewport.setFullScreenWindow(this.viewport);
            }
        } else {
            int wmDecorationWidth = this.viewport.getInsets().left + this.viewport.getInsets().right;
            int wmDecorationHeight = this.viewport.getInsets().top + this.viewport.getInsets().bottom;
            if (w + wmDecorationWidth >= dpySize.width) {
                w = dpySize.width - wmDecorationWidth;
            }
            if (h + wmDecorationHeight >= dpySize.height) {
                h = dpySize.height - wmDecorationHeight;
            }
            if (this.viewport.getExtendedState() == 6) {
                w = this.viewport.getSize().width;
                h = this.viewport.getSize().height;
                int x = this.viewport.getLocation().x;
                int y = this.viewport.getLocation().y;
                this.viewport.setGeometry(x, y, w, h);
            } else {
                int x = (dpySize.width - w - wmDecorationWidth) / 2;
                int y = (dpySize.height - h - wmDecorationHeight) / 2;
                this.viewport.setExtendedState(0);
                this.viewport.setGeometry(x, y, w, h);
            }
            Viewport.setFullScreenWindow(null);
        }
    }

    private void autoSelectFormatAndEncoding() {
        long kbitsPerSecond = this.sock.inStream().kbitsPerSecond();
        long timeWaited = this.sock.inStream().timeWaited();
        boolean newFullColour = this.fullColour;
        int newQualityLevel = this.cp.qualityLevel;
        if (this.currentEncoding != 7) {
            this.currentEncoding = 7;
            this.encodingChange = true;
        }
        if (kbitsPerSecond == 0L || timeWaited < 100L) {
            return;
        }
        if (!this.cp.noJpeg && (newQualityLevel = kbitsPerSecond > 16000L ? 8 : 6) != this.cp.qualityLevel) {
            vlog.info("Throughput " + kbitsPerSecond + " kbit/s - changing to quality " + newQualityLevel);
            this.cp.qualityLevel = newQualityLevel;
            this.viewer.qualityLevel.setParam(Integer.toString(newQualityLevel));
            this.encodingChange = true;
        }
        if (this.cp.beforeVersion(3, 8)) {
            return;
        }
        boolean bl = newFullColour = kbitsPerSecond > 256L;
        if (newFullColour != this.fullColour) {
            vlog.info("Throughput " + kbitsPerSecond + " kbit/s - full color is now " + (newFullColour ? "enabled" : "disabled"));
            this.fullColour = newFullColour;
            this.formatChange = true;
            this.forceNonincremental = true;
        }
    }

    private void requestNewUpdate() {
        if (this.formatChange) {
            assert (!this.pendingUpdate || this.supportsSyncFence);
            PixelFormat pf = this.fullColour ? this.fullColourPF : (this.lowColourLevel == 0 ? verylowColourPF : (this.lowColourLevel == 1 ? lowColourPF : mediumColourPF));
            if (this.supportsSyncFence) {
                MemOutStream memStream = new MemOutStream();
                pf.write(memStream);
                this.writer().writeFence(-2147483644, memStream.length(), memStream.data());
            } else {
                this.pendingPFChange = true;
                this.pendingPF = pf;
            }
            String str = pf.print();
            vlog.info("Using pixel format " + str);
            this.writer().writeSetPixelFormat(pf);
            this.formatChange = false;
        }
        this.checkEncodings();
        if (this.forceNonincremental || !this.continuousUpdates) {
            this.pendingUpdate = true;
            this.writer().writeFramebufferUpdateRequest(new Rect(0, 0, this.cp.width, this.cp.height), !this.forceNonincremental);
        }
        this.forceNonincremental = false;
    }

    public void close() {
        if (this.closeListener != null) {
            JFrame f;
            this.viewer.embed.setParam(true);
            if (VncViewer.nViewers == 1 && (f = (JFrame)JOptionPane.getFrameForComponent(this.viewer)) != null) {
                f.dispatchEvent(new WindowEvent(f, 201));
            }
        }
        this.deleteWindow();
        this.shuttingDown = true;
        try {
            if (this.sock != null) {
                this.sock.shutdown();
            }
        }
        catch (java.lang.Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private void initMenu() {
        this.menu = new F8Menu(this);
    }

    void showMenu(int x, int y) {
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            WindowsLookAndFeel.setMnemonicHidden((boolean)false);
        }
        this.menu.show(this.desktop, x, y);
    }

    void showAbout() {
        String pkgDate = "";
        String pkgTime = "";
        try {
            Manifest manifest = new Manifest(VncViewer.timestamp);
            Attributes attributes = manifest.getMainAttributes();
            pkgDate = attributes.getValue("Package-Date");
            pkgTime = attributes.getValue("Package-Time");
        }
        catch (java.lang.Exception manifest) {
            // empty catch block
        }
        Window fullScreenWindow = Viewport.getFullScreenWindow();
        if (fullScreenWindow != null) {
            Viewport.setFullScreenWindow(null);
        }
        String msg = String.format(VncViewer.aboutText, VncViewer.version, VncViewer.build, VncViewer.buildDate, VncViewer.buildTime);
        JOptionPane op = new JOptionPane(msg, 1, -1, VncViewer.logoIcon);
        JDialog dlg = op.createDialog(this.desktop, "About TigerVNC Viewer for Java");
        dlg.setIconImage(VncViewer.frameIcon);
        dlg.setAlwaysOnTop(true);
        dlg.setVisible(true);
        if (fullScreenWindow != null) {
            Viewport.setFullScreenWindow(fullScreenWindow);
        }
    }

    void showInfo() {
        Window fullScreenWindow = Viewport.getFullScreenWindow();
        if (fullScreenWindow != null) {
            Viewport.setFullScreenWindow(null);
        }
        String info = new String("Desktop name: %s%nHost: %s:%d%nSize: %dx%d%nPixel format: %s%n  (server default: %s)%nRequested encoding: %s%nLast used encoding: %s%nLine speed estimate: %d kbit/s%nProtocol version: %d.%d%nSecurity method: %s [%s]%n");
        String msg = String.format(info, this.cp.name(), this.sock.getPeerName(), this.sock.getPeerPort(), this.cp.width, this.cp.height, this.desktop.getPF().print(), this.serverPF.print(), Encodings.encodingName(this.currentEncoding), Encodings.encodingName(this.lastServerEncoding), this.sock.inStream().kbitsPerSecond(), this.cp.majorVersion, this.cp.minorVersion, Security.secTypeName(this.csecurity.getType()), this.csecurity.description());
        JOptionPane op = new JOptionPane(msg, -1, -1);
        JDialog dlg = op.createDialog(this.desktop, "VNC connection info");
        dlg.setIconImage(VncViewer.frameIcon);
        dlg.setAlwaysOnTop(true);
        dlg.setVisible(true);
        if (fullScreenWindow != null) {
            Viewport.setFullScreenWindow(fullScreenWindow);
        }
    }

    public void refresh() {
        this.writer().writeFramebufferUpdateRequest(new Rect(0, 0, this.cp.width, this.cp.height), false);
        this.pendingUpdate = true;
    }

    @Override
    public void setOptions() {
        this.options.autoSelect.setSelected(this.autoSelect);
        this.options.fullColour.setSelected(this.fullColour);
        this.options.veryLowColour.setSelected(!this.fullColour && this.lowColourLevel == 0);
        this.options.lowColour.setSelected(!this.fullColour && this.lowColourLevel == 1);
        this.options.mediumColour.setSelected(!this.fullColour && this.lowColourLevel == 2);
        this.options.tight.setSelected(this.currentEncoding == 7);
        this.options.zrle.setSelected(this.currentEncoding == 16);
        this.options.hextile.setSelected(this.currentEncoding == 5);
        this.options.raw.setSelected(this.currentEncoding == 0);
        this.options.customCompressLevel.setSelected(this.viewer.customCompressLevel.getValue());
        int digit = 0 + this.viewer.compressLevel.getValue();
        if (digit >= 0 && digit <= 9) {
            this.options.compressLevel.setSelectedItem(digit);
        } else {
            this.options.compressLevel.setSelectedItem(Integer.parseInt(this.viewer.compressLevel.getDefaultStr()));
        }
        this.options.noJpeg.setSelected(!this.viewer.noJpeg.getValue());
        digit = 0 + this.viewer.qualityLevel.getValue();
        if (digit >= 0 && digit <= 9) {
            this.options.qualityLevel.setSelectedItem(digit);
        } else {
            this.options.qualityLevel.setSelectedItem(Integer.parseInt(this.viewer.qualityLevel.getDefaultStr()));
        }
        this.options.viewOnly.setSelected(this.viewer.viewOnly.getValue());
        this.options.acceptClipboard.setSelected(this.viewer.acceptClipboard.getValue());
        this.options.sendClipboard.setSelected(this.viewer.sendClipboard.getValue());
        this.options.menuKey.setSelectedItem(KeyEvent.getKeyText(MenuKey.getMenuKeyCode()));
        this.options.sendLocalUsername.setSelected(this.viewer.sendLocalUsername.getValue());
        if (this.state() == 6) {
            this.options.shared.setEnabled(false);
            this.options.secVeNCrypt.setEnabled(false);
            this.options.encNone.setEnabled(false);
            this.options.encTLS.setEnabled(false);
            this.options.encX509.setEnabled(false);
            this.options.x509ca.setEnabled(false);
            this.options.caButton.setEnabled(false);
            this.options.x509crl.setEnabled(false);
            this.options.crlButton.setEnabled(false);
            this.options.secIdent.setEnabled(false);
            this.options.secNone.setEnabled(false);
            this.options.secVnc.setEnabled(false);
            this.options.secPlain.setEnabled(false);
            this.options.sendLocalUsername.setEnabled(false);
            this.options.cfLoadButton.setEnabled(false);
            this.options.cfSaveAsButton.setEnabled(true);
            this.options.sshTunnel.setEnabled(false);
            this.options.sshUseGateway.setEnabled(false);
            this.options.sshUser.setEnabled(false);
            this.options.sshHost.setEnabled(false);
            this.options.sshPort.setEnabled(false);
            this.options.sshUseExt.setEnabled(false);
            this.options.sshClient.setEnabled(false);
            this.options.sshClientBrowser.setEnabled(false);
            this.options.sshArgsDefault.setEnabled(false);
            this.options.sshArgsCustom.setEnabled(false);
            this.options.sshArguments.setEnabled(false);
            this.options.sshConfig.setEnabled(false);
            this.options.sshConfigBrowser.setEnabled(false);
            this.options.sshKeyFile.setEnabled(false);
            this.options.sshKeyFileBrowser.setEnabled(false);
        } else {
            File crlFile;
            File caFile;
            this.options.shared.setSelected(this.viewer.shared.getValue());
            this.options.sendLocalUsername.setSelected(this.viewer.sendLocalUsername.getValue());
            this.options.cfSaveAsButton.setEnabled(false);
            if (this.viewer.tunnel.getValue() || this.viewer.via.getValue() != null) {
                this.options.sshTunnel.setSelected(true);
            }
            if (this.viewer.via.getValue() != null) {
                this.options.sshUseGateway.setSelected(true);
            }
            this.options.sshUser.setText(Tunnel.getSshUser(this));
            this.options.sshHost.setText(Tunnel.getSshHost(this));
            this.options.sshPort.setText(Integer.toString(Tunnel.getSshPort(this)));
            this.options.sshUseExt.setSelected(this.viewer.extSSH.getValue());
            File client = new File(this.viewer.extSSHClient.getValue());
            if (client.exists() && client.canRead()) {
                this.options.sshClient.setText(client.getAbsolutePath());
            }
            if (this.viewer.extSSHArgs.getValue() == null) {
                this.options.sshArgsDefault.setSelected(true);
                this.options.sshArguments.setText("");
            } else {
                this.options.sshArgsCustom.setSelected(true);
                this.options.sshArguments.setText(this.viewer.extSSHArgs.getValue());
            }
            File config = new File(this.viewer.sshConfig.getValue());
            if (config.exists() && config.canRead()) {
                this.options.sshConfig.setText(config.getAbsolutePath());
            }
            this.options.sshKeyFile.setText(Tunnel.getSshKeyFile(this));
            List<Object> secTypes = new ArrayList();
            secTypes = Security.GetEnabledSecTypes();
            Iterator<Object> i = secTypes.iterator();
            while (i.hasNext()) {
                switch ((Integer)i.next()) {
                    case 19: {
                        this.options.secVeNCrypt.setSelected(UserPreferences.getBool("viewer", "secVeNCrypt", true));
                        break;
                    }
                    case 1: {
                        this.options.encNone.setSelected(true);
                        this.options.secNone.setSelected(UserPreferences.getBool("viewer", "secTypeNone", true));
                        break;
                    }
                    case 2: {
                        this.options.encNone.setSelected(true);
                        this.options.secVnc.setSelected(UserPreferences.getBool("viewer", "secTypeVncAuth", true));
                    }
                }
            }
            if (this.options.secVeNCrypt.isSelected()) {
                List<Object> secTypesExt = new ArrayList();
                secTypesExt = Security.GetEnabledExtSecTypes();
                Iterator<Object> iext = secTypesExt.iterator();
                while (iext.hasNext()) {
                    switch ((Integer)iext.next()) {
                        case 256: {
                            this.options.encNone.setSelected(UserPreferences.getBool("viewer", "encNone", true));
                            this.options.secPlain.setSelected(UserPreferences.getBool("viewer", "secPlain", true));
                            break;
                        }
                        case 265: {
                            this.options.encNone.setSelected(UserPreferences.getBool("viewer", "encNone", true));
                            this.options.secIdent.setSelected(UserPreferences.getBool("viewer", "secIdent", true));
                            break;
                        }
                        case 257: {
                            this.options.encTLS.setSelected(UserPreferences.getBool("viewer", "encTLS", true));
                            this.options.secNone.setSelected(UserPreferences.getBool("viewer", "secNone", true));
                            break;
                        }
                        case 258: {
                            this.options.encTLS.setSelected(UserPreferences.getBool("viewer", "encTLS", true));
                            this.options.secVnc.setSelected(UserPreferences.getBool("viewer", "secVnc", true));
                            break;
                        }
                        case 259: {
                            this.options.encTLS.setSelected(UserPreferences.getBool("viewer", "encTLS", true));
                            this.options.secPlain.setSelected(UserPreferences.getBool("viewer", "secPlain", true));
                            break;
                        }
                        case 266: {
                            this.options.encTLS.setSelected(UserPreferences.getBool("viewer", "encTLS", true));
                            this.options.secIdent.setSelected(UserPreferences.getBool("viewer", "secIdent", true));
                            break;
                        }
                        case 260: {
                            this.options.encX509.setSelected(UserPreferences.getBool("viewer", "encX509", true));
                            this.options.secNone.setSelected(UserPreferences.getBool("viewer", "secNone", true));
                            break;
                        }
                        case 261: {
                            this.options.encX509.setSelected(UserPreferences.getBool("viewer", "encX509", true));
                            this.options.secVnc.setSelected(UserPreferences.getBool("viewer", "secVnc", true));
                            break;
                        }
                        case 262: {
                            this.options.encX509.setSelected(UserPreferences.getBool("viewer", "encX509", true));
                            this.options.secPlain.setSelected(UserPreferences.getBool("viewer", "secPlain", true));
                            break;
                        }
                        case 267: {
                            this.options.encX509.setSelected(UserPreferences.getBool("viewer", "encX509", true));
                            this.options.secIdent.setSelected(UserPreferences.getBool("viewer", "secIdent", true));
                        }
                    }
                }
            }
            if ((caFile = new File(this.viewer.x509ca.getValue())).exists() && caFile.canRead()) {
                this.options.x509ca.setText(caFile.getAbsolutePath());
            }
            if ((crlFile = new File(this.viewer.x509crl.getValue())).exists() && crlFile.canRead()) {
                this.options.x509crl.setText(crlFile.getAbsolutePath());
            }
            this.options.encNone.setEnabled(this.options.secVeNCrypt.isSelected());
            this.options.encTLS.setEnabled(this.options.secVeNCrypt.isSelected());
            this.options.encX509.setEnabled(this.options.secVeNCrypt.isSelected());
            this.options.x509ca.setEnabled(this.options.secVeNCrypt.isSelected() && this.options.encX509.isSelected());
            this.options.caButton.setEnabled(this.options.secVeNCrypt.isSelected() && this.options.encX509.isSelected());
            this.options.x509crl.setEnabled(this.options.secVeNCrypt.isSelected() && this.options.encX509.isSelected());
            this.options.crlButton.setEnabled(this.options.secVeNCrypt.isSelected() && this.options.encX509.isSelected());
            this.options.secIdent.setEnabled(this.options.secVeNCrypt.isSelected());
            this.options.secPlain.setEnabled(this.options.secVeNCrypt.isSelected());
            this.options.sendLocalUsername.setEnabled(this.options.secPlain.isSelected() || this.options.secIdent.isSelected());
            this.options.sshTunnel.setEnabled(true);
            this.options.sshUseGateway.setEnabled(this.options.sshTunnel.isSelected());
            this.options.sshUser.setEnabled(this.options.sshTunnel.isSelected() && this.options.sshUseGateway.isEnabled() && this.options.sshUseGateway.isSelected());
            this.options.sshHost.setEnabled(this.options.sshTunnel.isSelected() && this.options.sshUseGateway.isEnabled() && this.options.sshUseGateway.isSelected());
            this.options.sshPort.setEnabled(this.options.sshTunnel.isSelected() && this.options.sshUseGateway.isEnabled() && this.options.sshUseGateway.isSelected());
            this.options.sshUseExt.setEnabled(this.options.sshTunnel.isSelected());
            this.options.sshClient.setEnabled(this.options.sshTunnel.isSelected() && this.options.sshUseExt.isEnabled() && this.options.sshUseExt.isSelected());
            this.options.sshClientBrowser.setEnabled(this.options.sshTunnel.isSelected() && this.options.sshUseExt.isEnabled() && this.options.sshUseExt.isSelected());
            this.options.sshArgsDefault.setEnabled(this.options.sshTunnel.isSelected() && this.options.sshUseExt.isEnabled() && this.options.sshUseExt.isSelected());
            this.options.sshArgsCustom.setEnabled(this.options.sshTunnel.isSelected() && this.options.sshUseExt.isEnabled() && this.options.sshUseExt.isSelected());
            this.options.sshArguments.setEnabled(this.options.sshTunnel.isSelected() && this.options.sshUseExt.isEnabled() && this.options.sshUseExt.isSelected() && this.options.sshArgsCustom.isSelected());
            this.options.sshConfig.setEnabled(this.options.sshTunnel.isSelected() && this.options.sshUseExt.isEnabled() && !this.options.sshUseExt.isSelected());
            this.options.sshConfigBrowser.setEnabled(this.options.sshTunnel.isSelected() && this.options.sshUseExt.isEnabled() && !this.options.sshUseExt.isSelected());
            this.options.sshKeyFile.setEnabled(this.options.sshTunnel.isSelected() && this.options.sshUseExt.isEnabled() && !this.options.sshUseExt.isSelected());
            this.options.sshKeyFileBrowser.setEnabled(this.options.sshTunnel.isSelected() && this.options.sshUseExt.isEnabled() && !this.options.sshUseExt.isSelected());
        }
        this.options.fullScreen.setSelected(this.fullScreen);
        this.options.fullScreenAllMonitors.setSelected(this.viewer.fullScreenAllMonitors.getValue());
        this.options.useLocalCursor.setSelected(this.viewer.useLocalCursor.getValue());
        this.options.acceptBell.setSelected(this.viewer.acceptBell.getValue());
        String scaleString = this.viewer.scalingFactor.getValue();
        if (scaleString.equalsIgnoreCase("Auto")) {
            this.options.scalingFactor.setSelectedItem("Auto");
        } else if (scaleString.equalsIgnoreCase("FixedRatio")) {
            this.options.scalingFactor.setSelectedItem("Fixed Aspect Ratio");
        } else {
            digit = Integer.parseInt(scaleString);
            if (digit >= 1 && digit <= 1000) {
                this.options.scalingFactor.setSelectedItem(digit + "%");
            } else {
                digit = Integer.parseInt(this.viewer.scalingFactor.getDefaultStr());
                this.options.scalingFactor.setSelectedItem(digit + "%");
            }
            int config = Integer.parseInt(scaleString.substring(0, scaleString.length()));
        }
        if (this.viewer.desktopSize.getValue() != null && this.viewer.desktopSize.getValue().split("x").length == 2) {
            this.options.desktopSize.setSelected(true);
            String desktopWidth = this.viewer.desktopSize.getValue().split("x")[0];
            this.options.desktopWidth.setText(desktopWidth);
            String desktopHeight = this.viewer.desktopSize.getValue().split("x")[1];
            this.options.desktopHeight.setText(desktopHeight);
        }
    }

    @Override
    public void getOptions() {
        int newEncoding;
        this.autoSelect = this.options.autoSelect.isSelected();
        if (this.fullColour != this.options.fullColour.isSelected()) {
            this.formatChange = true;
            this.forceNonincremental = true;
        }
        this.fullColour = this.options.fullColour.isSelected();
        if (!this.fullColour) {
            int newLowColourLevel;
            int n = this.options.veryLowColour.isSelected() ? 0 : (newLowColourLevel = this.options.lowColour.isSelected() ? 1 : 2);
            if (newLowColourLevel != this.lowColourLevel) {
                this.lowColourLevel = newLowColourLevel;
                this.formatChange = true;
                this.forceNonincremental = true;
            }
        }
        int n = this.options.zrle.isSelected() ? 16 : (this.options.hextile.isSelected() ? 5 : (newEncoding = this.options.tight.isSelected() ? 7 : 0));
        if (newEncoding != this.currentEncoding) {
            this.currentEncoding = newEncoding;
            this.encodingChange = true;
        }
        this.viewer.customCompressLevel.setParam(this.options.customCompressLevel.isSelected());
        if (this.cp.customCompressLevel != this.viewer.customCompressLevel.getValue()) {
            this.cp.customCompressLevel = this.viewer.customCompressLevel.getValue();
            this.encodingChange = true;
        }
        if (Integer.parseInt(this.options.compressLevel.getSelectedItem().toString()) >= 0 && Integer.parseInt(this.options.compressLevel.getSelectedItem().toString()) <= 9) {
            this.viewer.compressLevel.setParam(this.options.compressLevel.getSelectedItem().toString());
        } else {
            this.viewer.compressLevel.setParam(this.viewer.compressLevel.getDefaultStr());
        }
        if (this.cp.compressLevel != this.viewer.compressLevel.getValue()) {
            this.cp.compressLevel = this.viewer.compressLevel.getValue();
            this.encodingChange = true;
        }
        this.viewer.noJpeg.setParam(!this.options.noJpeg.isSelected());
        if (this.cp.noJpeg != this.viewer.noJpeg.getValue()) {
            this.cp.noJpeg = this.viewer.noJpeg.getValue();
            this.encodingChange = true;
        }
        this.viewer.qualityLevel.setParam(this.options.qualityLevel.getSelectedItem().toString());
        if (this.cp.qualityLevel != this.viewer.qualityLevel.getValue()) {
            this.cp.qualityLevel = this.viewer.qualityLevel.getValue();
            this.encodingChange = true;
        }
        if (!this.options.x509ca.getText().equals("")) {
            CSecurityTLS.x509ca.setParam(this.options.x509ca.getText());
        }
        if (!this.options.x509crl.getText().equals("")) {
            CSecurityTLS.x509crl.setParam(this.options.x509crl.getText());
        }
        this.viewer.sendLocalUsername.setParam(this.options.sendLocalUsername.isSelected());
        this.viewer.viewOnly.setParam(this.options.viewOnly.isSelected());
        this.viewer.acceptClipboard.setParam(this.options.acceptClipboard.isSelected());
        this.viewer.sendClipboard.setParam(this.options.sendClipboard.isSelected());
        this.viewer.acceptBell.setParam(this.options.acceptBell.isSelected());
        String scaleString = this.options.scalingFactor.getSelectedItem().toString();
        String oldScaleFactor = this.viewer.scalingFactor.getValue();
        scaleString = scaleString.equalsIgnoreCase("Fixed Aspect Ratio") ? new String("FixedRatio") : (scaleString.equalsIgnoreCase("Auto") ? new String("Auto") : scaleString.substring(0, scaleString.length() - 1));
        if (!oldScaleFactor.equals(scaleString)) {
            this.viewer.scalingFactor.setParam(scaleString);
            if (this.options.fullScreen.isSelected() == this.fullScreen && this.desktop != null) {
                this.recreateViewport();
            }
        }
        this.clipboardDialog.setSendingEnabled(this.viewer.sendClipboard.getValue());
        this.viewer.menuKey.setParam(MenuKey.getMenuKeySymbols()[this.options.menuKey.getSelectedIndex()].name);
        F8Menu.f8.setText("Send " + KeyEvent.getKeyText(MenuKey.getMenuKeyCode()));
        this.setShared(this.options.shared.isSelected());
        this.viewer.useLocalCursor.setParam(this.options.useLocalCursor.isSelected());
        if (this.cp.supportsLocalCursor != this.viewer.useLocalCursor.getValue()) {
            this.cp.supportsLocalCursor = this.viewer.useLocalCursor.getValue();
            this.encodingChange = true;
            if (this.desktop != null) {
                this.desktop.resetLocalCursor();
            }
        }
        this.viewer.extSSH.setParam(this.options.sshUseExt.isSelected());
        this.checkEncodings();
        if (this.state() != 6) {
            if (this.options.encNone.isSelected()) {
                if (this.options.secNone.isSelected()) {
                    Security.EnableSecType(1);
                }
                if (this.options.secVnc.isSelected()) {
                    Security.EnableSecType(2);
                }
                if (this.options.secPlain.isSelected()) {
                    Security.EnableSecType(256);
                }
                if (this.options.secIdent.isSelected()) {
                    Security.EnableSecType(265);
                }
            } else {
                Security.DisableSecType(1);
                Security.DisableSecType(2);
                Security.DisableSecType(256);
                Security.DisableSecType(265);
            }
            if (this.options.encTLS.isSelected()) {
                if (this.options.secNone.isSelected()) {
                    Security.EnableSecType(257);
                }
                if (this.options.secVnc.isSelected()) {
                    Security.EnableSecType(258);
                }
                if (this.options.secPlain.isSelected()) {
                    Security.EnableSecType(259);
                }
                if (this.options.secIdent.isSelected()) {
                    Security.EnableSecType(266);
                }
            } else {
                Security.DisableSecType(257);
                Security.DisableSecType(258);
                Security.DisableSecType(259);
                Security.DisableSecType(266);
            }
            if (this.options.encX509.isSelected()) {
                if (this.options.secNone.isSelected()) {
                    Security.EnableSecType(260);
                }
                if (this.options.secVnc.isSelected()) {
                    Security.EnableSecType(261);
                }
                if (this.options.secPlain.isSelected()) {
                    Security.EnableSecType(262);
                }
                if (this.options.secIdent.isSelected()) {
                    Security.EnableSecType(267);
                }
            } else {
                Security.DisableSecType(260);
                Security.DisableSecType(261);
                Security.DisableSecType(262);
                Security.DisableSecType(267);
            }
            if (this.options.secNone.isSelected()) {
                if (this.options.encNone.isSelected()) {
                    Security.EnableSecType(1);
                }
                if (this.options.encTLS.isSelected()) {
                    Security.EnableSecType(257);
                }
                if (this.options.encX509.isSelected()) {
                    Security.EnableSecType(260);
                }
            } else {
                Security.DisableSecType(1);
                Security.DisableSecType(257);
                Security.DisableSecType(260);
            }
            if (this.options.secVnc.isSelected()) {
                if (this.options.encNone.isSelected()) {
                    Security.EnableSecType(2);
                }
                if (this.options.encTLS.isSelected()) {
                    Security.EnableSecType(258);
                }
                if (this.options.encX509.isSelected()) {
                    Security.EnableSecType(261);
                }
            } else {
                Security.DisableSecType(2);
                Security.DisableSecType(258);
                Security.DisableSecType(261);
            }
            if (this.options.secPlain.isSelected()) {
                if (this.options.encNone.isSelected()) {
                    Security.EnableSecType(256);
                }
                if (this.options.encTLS.isSelected()) {
                    Security.EnableSecType(259);
                }
                if (this.options.encX509.isSelected()) {
                    Security.EnableSecType(262);
                }
            } else {
                Security.DisableSecType(256);
                Security.DisableSecType(259);
                Security.DisableSecType(262);
            }
            if (this.options.secIdent.isSelected()) {
                if (this.options.encNone.isSelected()) {
                    Security.EnableSecType(265);
                }
                if (this.options.encTLS.isSelected()) {
                    Security.EnableSecType(266);
                }
                if (this.options.encX509.isSelected()) {
                    Security.EnableSecType(267);
                }
            } else {
                Security.DisableSecType(265);
                Security.DisableSecType(266);
                Security.DisableSecType(267);
            }
            if (this.options.sshTunnel.isSelected()) {
                if (this.options.sshUseGateway.isSelected()) {
                    String user = this.options.sshUser.getText();
                    String host = this.options.sshHost.getText();
                    String port = this.options.sshPort.getText();
                    this.viewer.via.setParam(user + "@" + host + ":" + port);
                } else {
                    this.viewer.tunnel.setParam(true);
                }
            }
            this.viewer.extSSH.setParam(this.options.sshUseExt.isSelected());
            this.viewer.extSSHClient.setParam(this.options.sshClient.getText());
            if (this.options.sshArgsCustom.isSelected()) {
                this.viewer.extSSHArgs.setParam(this.options.sshArguments.getText());
            }
            this.viewer.sshConfig.setParam(this.options.sshConfig.getText());
            this.viewer.sshKeyFile.setParam(this.options.sshKeyFile.getText());
        }
        String desktopSize = this.options.desktopSize.isSelected() ? this.options.desktopWidth.getText() + "x" + this.options.desktopHeight.getText() : "";
        this.viewer.desktopSize.setParam(desktopSize);
        if (this.options.fullScreen.isSelected() ^ this.fullScreen) {
            this.viewer.fullScreenAllMonitors.setParam(this.options.fullScreenAllMonitors.isSelected());
            this.toggleFullScreen();
        } else if (this.viewer.fullScreenAllMonitors.getValue() != this.options.fullScreenAllMonitors.isSelected()) {
            this.viewer.fullScreenAllMonitors.setParam(this.options.fullScreenAllMonitors.isSelected());
            if (this.desktop != null) {
                this.recreateViewport();
            }
        } else {
            this.viewer.fullScreenAllMonitors.setParam(this.options.fullScreenAllMonitors.isSelected());
        }
    }

    public void toggleFullScreen() {
        if (this.viewer.embed.getValue()) {
            return;
        }
        this.fullScreen = !this.fullScreen;
        this.menu.fullScreen.setSelected(this.fullScreen);
        if (this.viewport != null) {
            if (!this.viewport.lionFSSupported()) {
                this.recreateViewport();
            } else {
                this.viewport.toggleLionFS();
            }
        }
    }

    public void writeClientCutText(String str, int len) {
        if (this.state() != 6 || this.shuttingDown) {
            return;
        }
        this.writer().writeClientCutText(str, len);
    }

    public void writeKeyEvent(int keysym, boolean down) {
        if (this.state() != 6 || this.shuttingDown) {
            return;
        }
        this.writer().writeKeyEvent(keysym, down);
    }

    public void writeKeyEvent(KeyEvent ev) {
        if (this.viewer.viewOnly.getValue() || this.shuttingDown) {
            return;
        }
        boolean down = ev.getID() == 401;
        int keyCode = ev.getKeyCode();
        if (keyCode == 0 && ev.getKeyChar() == '\uffff') {
            return;
        }
        if (!down) {
            Integer iter = this.downKeySym.get(keyCode);
            if (iter == null) {
                vlog.error("Unexpected key release of keyCode " + keyCode);
                String fmt = ev.paramString().replaceAll("%", "%%");
                vlog.error(String.format(fmt.replaceAll(",", "%n       "), new Object[0]));
                return;
            }
            vlog.debug(String.format("Key released: 0x%04x => 0x%04x", keyCode, iter));
            this.writeKeyEvent(iter, false);
            this.downKeySym.remove(keyCode);
            return;
        }
        int keySym = Keysyms.translateKeyEvent(ev);
        if (keySym == 0xFFFFFF) {
            return;
        }
        boolean need_cheat = true;
        if (VncViewer.os.startsWith("windows")) {
            if (KeyEvent.getKeyText(keyCode).isEmpty()) {
                need_cheat = false;
            } else if (!this.downKeySym.containsValue(65507) && !this.downKeySym.containsValue(65508)) {
                need_cheat = false;
            } else if (!this.downKeySym.containsValue(65513) && !this.downKeySym.containsValue(65514)) {
                need_cheat = false;
            }
            if (need_cheat) {
                vlog.info("Faking release of AltGr (Ctrl+Alt)");
                if (this.downKeySym.containsValue(65507)) {
                    this.writeKeyEvent(65507, false);
                }
                if (this.downKeySym.containsValue(65508)) {
                    this.writeKeyEvent(65508, false);
                }
                if (this.downKeySym.containsValue(65513)) {
                    this.writeKeyEvent(65513, false);
                }
                if (this.downKeySym.containsValue(65514)) {
                    this.writeKeyEvent(65514, false);
                }
            }
        }
        vlog.debug(String.format("Key pressed: 0x%04x '%s' => 0x%04x", keyCode, Character.toString(ev.getKeyChar()), keySym));
        this.downKeySym.put(keyCode, keySym);
        this.writeKeyEvent(keySym, down);
        if (VncViewer.os.startsWith("windows") && need_cheat) {
            vlog.debug("Restoring AltGr state");
            if (this.downKeySym.containsValue(65507)) {
                this.writeKeyEvent(65507, true);
            }
            if (this.downKeySym.containsValue(65508)) {
                this.writeKeyEvent(65508, true);
            }
            if (this.downKeySym.containsValue(65513)) {
                this.writeKeyEvent(65513, true);
            }
            if (this.downKeySym.containsValue(65514)) {
                this.writeKeyEvent(65514, true);
            }
        }
    }

    public void writePointerEvent(MouseEvent ev) {
        if (this.state() != 6 || this.shuttingDown) {
            return;
        }
        switch (ev.getID()) {
            case 501: {
                this.buttonMask = 1;
                if ((ev.getModifiers() & 8) != 0) {
                    this.buttonMask = 2;
                }
                if ((ev.getModifiers() & 4) == 0) break;
                this.buttonMask = 4;
                break;
            }
            case 502: {
                this.buttonMask = 0;
            }
        }
        if (this.cp.width != this.desktop.scaledWidth || this.cp.height != this.desktop.scaledHeight) {
            int sx = (double)this.desktop.scaleWidthRatio == 1.0 ? ev.getX() : (int)Math.floor((float)ev.getX() / this.desktop.scaleWidthRatio);
            int sy = (double)this.desktop.scaleHeightRatio == 1.0 ? ev.getY() : (int)Math.floor((float)ev.getY() / this.desktop.scaleHeightRatio);
            ev.translatePoint(sx - ev.getX(), sy - ev.getY());
        }
        this.writer().writePointerEvent(new Point(ev.getX(), ev.getY()), this.buttonMask);
    }

    public void writeWheelEvent(MouseWheelEvent ev) {
        if (this.state() != 6 || this.shuttingDown) {
            return;
        }
        int clicks = ev.getWheelRotation();
        this.buttonMask = clicks < 0 ? 8 : 16;
        for (int i = 0; i < Math.abs(clicks); ++i) {
            int x = ev.getX();
            int y = ev.getY();
            this.writer().writePointerEvent(new Point(x, y), this.buttonMask);
            this.buttonMask = 0;
            this.writer().writePointerEvent(new Point(x, y), this.buttonMask);
        }
    }

    synchronized void releaseDownKeys() {
        for (Map.Entry<Integer, Integer> entry : this.downKeySym.entrySet()) {
            this.writeKeyEvent(entry.getValue(), false);
        }
        this.downKeySym.clear();
    }

    public void setCloseListener(ActionListener cl) {
        this.closeListener = cl;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public Socket getSocket() {
        return this.sock;
    }

    private void checkEncodings() {
        if (this.encodingChange && this.writer() != null) {
            vlog.info("Requesting " + Encodings.encodingName(this.currentEncoding) + " encoding");
            this.writer().writeSetEncodings(this.currentEncoding, true);
            this.encodingChange = false;
        }
    }

    static {
        vlog = new LogWriter("CConn");
    }
}

