/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.rfb.Configuration;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.vncviewer.CConn;
import com.tigervnc.vncviewer.MenuKey;
import com.tigervnc.vncviewer.Viewport;
import com.tigervnc.vncviewer.VncViewer;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class F8Menu
extends JPopupMenu
implements ActionListener {
    CConn cc;
    JMenuItem restore;
    JMenuItem move;
    JMenuItem size;
    JMenuItem minimize;
    JMenuItem maximize;
    JMenuItem exit;
    JMenuItem clipboard;
    JMenuItem ctrlAltDel;
    JMenuItem refresh;
    JMenuItem newConn;
    JMenuItem options;
    JMenuItem save;
    JMenuItem info;
    JMenuItem about;
    JMenuItem dismiss;
    static JMenuItem f8;
    JCheckBoxMenuItem fullScreen;
    static LogWriter vlog;

    public F8Menu(CConn cc_) {
        super("VNC Menu");
        this.setLightWeightPopupEnabled(false);
        this.cc = cc_;
        this.restore = this.addMenuItem("Restore", 82);
        this.restore.setEnabled(!this.cc.viewer.embed.getValue());
        this.move = this.addMenuItem("Move");
        this.move.setEnabled(false);
        this.size = this.addMenuItem("Size");
        this.size.setEnabled(false);
        this.minimize = this.addMenuItem("Minimize", 78);
        this.minimize.setEnabled(!this.cc.viewer.embed.getValue());
        this.maximize = this.addMenuItem("Maximize", 88);
        this.maximize.setEnabled(!this.cc.viewer.embed.getValue());
        this.addSeparator();
        this.exit = this.addMenuItem("Close Viewer", 67);
        this.addSeparator();
        this.fullScreen = new JCheckBoxMenuItem("Full Screen");
        this.fullScreen.setMnemonic(70);
        this.fullScreen.setSelected(this.cc.fullScreen);
        this.fullScreen.addActionListener(this);
        this.fullScreen.setEnabled(!this.cc.viewer.embed.getValue());
        this.add(this.fullScreen);
        this.addSeparator();
        this.clipboard = this.addMenuItem("Clipboard...");
        this.addSeparator();
        f8 = this.addMenuItem("Send " + KeyEvent.getKeyText(MenuKey.getMenuKeyCode()), MenuKey.getMenuKeyCode());
        this.ctrlAltDel = this.addMenuItem("Send Ctrl-Alt-Del");
        this.addSeparator();
        this.refresh = this.addMenuItem("Refresh Screen", 72);
        this.addSeparator();
        this.newConn = this.addMenuItem("New connection...", 87);
        this.newConn.setEnabled(!this.cc.viewer.embed.getValue());
        this.options = this.addMenuItem("Options...", 79);
        this.save = this.addMenuItem("Save connection info as...", 83);
        this.info = this.addMenuItem("Connection info...", 73);
        this.about = this.addMenuItem("About VncViewer...", 65);
        this.addSeparator();
        this.dismiss = this.addMenuItem("Dismiss menu");
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    JMenuItem addMenuItem(String str, int mnemonic) {
        JMenuItem item = new JMenuItem(str, mnemonic);
        item.addActionListener(this);
        this.add(item);
        return item;
    }

    JMenuItem addMenuItem(String str) {
        JMenuItem item = new JMenuItem(str);
        item.addActionListener(this);
        this.add(item);
        return item;
    }

    boolean actionMatch(ActionEvent ev, JMenuItem item) {
        return ev.getActionCommand().equals(item.getActionCommand());
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (this.actionMatch(ev, this.exit)) {
            this.cc.close();
        } else if (this.actionMatch(ev, this.fullScreen)) {
            this.cc.toggleFullScreen();
        } else if (this.actionMatch(ev, this.restore)) {
            if (this.cc.fullScreen) {
                this.cc.toggleFullScreen();
            }
            this.cc.viewport.setExtendedState(0);
        } else if (this.actionMatch(ev, this.minimize)) {
            if (this.cc.fullScreen) {
                this.cc.toggleFullScreen();
            }
            this.cc.viewport.setExtendedState(1);
        } else if (this.actionMatch(ev, this.maximize)) {
            if (this.cc.fullScreen) {
                this.cc.toggleFullScreen();
            }
            this.cc.viewport.setExtendedState(6);
        } else if (this.actionMatch(ev, this.clipboard)) {
            this.cc.clipboardDialog.showDialog(this.cc.viewport);
        } else if (this.actionMatch(ev, f8)) {
            this.cc.writeKeyEvent(MenuKey.getMenuKeySym(), true);
            this.cc.writeKeyEvent(MenuKey.getMenuKeySym(), false);
        } else if (this.actionMatch(ev, this.ctrlAltDel)) {
            this.cc.writeKeyEvent(65507, true);
            this.cc.writeKeyEvent(65513, true);
            this.cc.writeKeyEvent(65535, true);
            this.cc.writeKeyEvent(65535, false);
            this.cc.writeKeyEvent(65513, false);
            this.cc.writeKeyEvent(65507, false);
        } else if (this.actionMatch(ev, this.refresh)) {
            this.cc.refresh();
        } else if (this.actionMatch(ev, this.newConn)) {
            VncViewer.newViewer(this.cc.viewer);
        } else if (this.actionMatch(ev, this.options)) {
            this.cc.options.showDialog(this.cc.viewport);
        } else if (this.actionMatch(ev, this.save)) {
            String filename;
            JFileChooser fc = new JFileChooser();
            fc.setDialogTitle("Save current configuration as:");
            fc.setApproveButtonText("OK");
            fc.setFileHidingEnabled(false);
            Window fullScreenWindow = Viewport.getFullScreenWindow();
            if (fullScreenWindow != null) {
                Viewport.setFullScreenWindow(null);
            }
            int ret = fc.showOpenDialog(this.cc.viewport);
            if (fullScreenWindow != null) {
                Viewport.setFullScreenWindow(fullScreenWindow);
            }
            if (ret == 0 && (filename = fc.getSelectedFile().toString()) != null) {
                Configuration.save(filename);
            }
        } else if (this.actionMatch(ev, this.info)) {
            this.cc.showInfo();
        } else if (this.actionMatch(ev, this.about)) {
            this.cc.showAbout();
        } else if (this.actionMatch(ev, this.dismiss)) {
            this.firePopupMenuCanceled();
        }
    }

    static {
        vlog = new LogWriter("F8Menu");
    }
}

