/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.OpenSSHConfig;
import com.jcraft.jsch.Session;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.vncviewer.CConn;
import com.tigervnc.vncviewer.FileUtils;
import com.tigervnc.vncviewer.PasswdDialog;
import com.tigervnc.vncviewer.VncViewer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class Tunnel {
    private static final String DEFAULT_TUNNEL_TEMPLATE = "-f -L %L:localhost:%R %H sleep 20";
    private static final String DEFAULT_VIA_TEMPLATE = "-f -L %L:%H:%R %G sleep 20";
    static LogWriter vlog = new LogWriter("Tunnel");

    public static void createTunnel(CConn cc, int localPort) throws com.tigervnc.rfb.Exception {
        String remoteHost;
        String gatewayHost;
        int remotePort = cc.getServerPort();
        if (cc.viewer.tunnel.getValue()) {
            gatewayHost = cc.getServerName();
            remoteHost = "localhost";
        } else {
            gatewayHost = Tunnel.getSshHost(cc);
            remoteHost = cc.getServerName();
        }
        String pattern = cc.viewer.extSSHArgs.getValue();
        if (pattern == null) {
            pattern = cc.viewer.tunnel.getValue() ? System.getProperty("VNC_TUNNEL_CMD") : System.getProperty("VNC_VIA_CMD");
        }
        if (cc.viewer.extSSH.getValue() || pattern != null && pattern.length() > 0) {
            Tunnel.createTunnelExt(gatewayHost, remoteHost, remotePort, localPort, pattern, cc);
        } else {
            Tunnel.createTunnelJSch(gatewayHost, remoteHost, remotePort, localPort, cc);
        }
    }

    public static String getSshHost(CConn cc) {
        String sshHost = cc.viewer.via.getValue();
        if (sshHost == null) {
            return cc.getServerName();
        }
        int end = sshHost.indexOf(":");
        if (end < 0) {
            end = sshHost.length();
        }
        sshHost = sshHost.substring(sshHost.indexOf("@") + 1, end);
        return sshHost;
    }

    public static String getSshUser(CConn cc) {
        String sshUser = (String)System.getProperties().get("user.name");
        String via = cc.viewer.via.getValue();
        if (via != null && via.indexOf("@") > 0) {
            sshUser = via.substring(0, via.indexOf("@"));
        }
        return sshUser;
    }

    public static int getSshPort(CConn cc) {
        String sshPort = "22";
        String via = cc.viewer.via.getValue();
        if (via != null && via.indexOf(":") > 0) {
            sshPort = via.substring(via.indexOf(":") + 1, via.length());
        }
        return Integer.parseInt(sshPort);
    }

    public static String getSshKeyFile(CConn cc) {
        String[] ids;
        if (cc.viewer.sshKeyFile.getValue() != null) {
            return cc.viewer.sshKeyFile.getValue();
        }
        for (String id : ids = new String[]{"id_dsa", "id_rsa"}) {
            File f = new File(FileUtils.getHomeDir() + ".ssh/" + id);
            if (!f.exists() || !f.canRead()) continue;
            return f.getAbsolutePath();
        }
        return null;
    }

    private static void createTunnelJSch(String gatewayHost, String remoteHost, int remotePort, int localPort, CConn cc) throws com.tigervnc.rfb.Exception {
        JSch.setLogger(new MyJSchLogger());
        JSch jsch = new JSch();
        try {
            File knownHosts = new File(FileUtils.getHomeDir() + ".ssh/known_hosts");
            if (knownHosts.exists() && knownHosts.canRead()) {
                jsch.setKnownHosts(knownHosts.getAbsolutePath());
            }
            ArrayList<File> privateKeys = new ArrayList<File>();
            String sshKeyFile = cc.options.sshKeyFile.getText();
            String sshKey = cc.viewer.sshKey.getValue();
            if (sshKey != null) {
                String sshKeyPass = cc.viewer.sshKeyPass.getValue();
                byte[] keyPass = null;
                if (sshKeyPass != null) {
                    keyPass = sshKeyPass.getBytes();
                }
                sshKey = sshKey.replaceAll("\\\\n", "\n");
                byte[] key = sshKey.getBytes();
                jsch.addIdentity("TigerVNC", key, null, keyPass);
            } else if (!sshKeyFile.equals("")) {
                File f = new File(sshKeyFile);
                if (!f.exists() || !f.canRead()) {
                    throw new com.tigervnc.rfb.Exception("Cannot access SSH key file " + sshKeyFile);
                }
                privateKeys.add(f);
            }
            for (File privateKey : privateKeys) {
                if (!privateKey.exists() || !privateKey.canRead()) continue;
                if (cc.viewer.sshKeyPass.getValue() != null) {
                    jsch.addIdentity(privateKey.getAbsolutePath(), cc.viewer.sshKeyPass.getValue());
                    continue;
                }
                jsch.addIdentity(privateKey.getAbsolutePath());
            }
            String user = Tunnel.getSshUser(cc);
            String label = new String("SSH Authentication");
            PasswdDialog dlg = new PasswdDialog(label, user != null, false);
            dlg.userEntry.setText(user != null ? user : "");
            File ssh_config = new File(cc.viewer.sshConfig.getValue());
            if (ssh_config.exists() && ssh_config.canRead()) {
                OpenSSHConfig repo = OpenSSHConfig.parse(ssh_config.getAbsolutePath());
                jsch.setConfigRepository(repo);
            }
            Session session = jsch.getSession(user, gatewayHost, Tunnel.getSshPort(cc));
            session.setUserInfo(dlg);
            if (session.getConfig("StrictHostKeyChecking") == null) {
                session.setConfig("StrictHostKeyChecking", "ask");
            }
            session.connect();
            session.setPortForwardingL(localPort, remoteHost, remotePort);
        }
        catch (Exception e) {
            throw new com.tigervnc.rfb.Exception(e.getMessage());
        }
    }

    private static void createTunnelExt(String gatewayHost, String remoteHost, int remotePort, int localPort, String pattern, CConn cc) throws com.tigervnc.rfb.Exception {
        if (pattern == null || pattern.length() < 1) {
            pattern = cc.viewer.tunnel.getValue() ? DEFAULT_TUNNEL_TEMPLATE : DEFAULT_VIA_TEMPLATE;
        }
        String cmd = Tunnel.fillCmdPattern(pattern, gatewayHost, remoteHost, remotePort, localPort, cc);
        try {
            Thread t = new Thread(new MyExtProcess(cmd));
            t.start();
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            throw new com.tigervnc.rfb.Exception(e.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    private static String fillCmdPattern(String pattern, String gatewayHost, String remoteHost, int remotePort, int localPort, CConn cc) {
        H_found = false;
        G_found = false;
        R_found = false;
        L_found = false;
        P_found = false;
        cmd = cc.options.sshClient.getText() + " ";
        pattern.replaceAll("^\\s+", "");
        user = Tunnel.getSshUser(cc);
        sshPort = Tunnel.getSshPort(cc);
        gatewayHost = user + "@" + gatewayHost;
        block7: for (i = 0; i < pattern.length(); ++i) {
            if (pattern.charAt(i) != '%') ** GOTO lbl-1000
            switch (pattern.charAt(++i)) {
                case 'H': {
                    cmd = cmd + (cc.viewer.tunnel.getValue() != false ? gatewayHost : remoteHost);
                    H_found = true;
                    continue block7;
                }
                case 'G': {
                    cmd = cmd + gatewayHost;
                    G_found = true;
                    continue block7;
                }
                case 'R': {
                    cmd = cmd + remotePort;
                    R_found = true;
                    continue block7;
                }
                case 'L': {
                    cmd = cmd + localPort;
                    L_found = true;
                    continue block7;
                }
                case 'P': {
                    cmd = cmd + sshPort;
                    P_found = true;
                    continue block7;
                }
                default: lbl-1000:
                // 2 sources

                {
                    cmd = cmd + pattern.charAt(i);
                }
            }
        }
        if (pattern.length() > 1024) {
            throw new com.tigervnc.rfb.Exception("Tunneling command is too long.");
        }
        if (!(H_found && R_found && L_found)) {
            throw new com.tigervnc.rfb.Exception("%H, %R or %L absent in tunneling command template.");
        }
        if (!cc.viewer.tunnel.getValue() && !G_found) {
            throw new com.tigervnc.rfb.Exception("%G pattern absent in tunneling command template.");
        }
        Tunnel.vlog.info("SSH command line: " + cmd);
        if (VncViewer.os.startsWith("windows")) {
            cmd.replaceAll("\\\\", "\\\\\\\\");
        }
        return cmd;
    }

    private static class MyExtProcess
    implements Runnable {
        private String cmd = null;
        private Process pid = null;

        public MyExtProcess(String command) {
            this.cmd = command;
        }

        @Override
        public void run() {
            try {
                Runtime runtime = Runtime.getRuntime();
                this.pid = runtime.exec(this.cmd);
                runtime.addShutdownHook(new MyShutdownHook(this.pid));
                new MyProcessLogger(this.pid).start();
                this.pid.waitFor();
            }
            catch (InterruptedException e) {
                vlog.info(e.getMessage());
            }
            catch (IOException e) {
                vlog.info(e.getMessage());
            }
        }

        private static class MyShutdownHook
        extends Thread {
            private Process proc = null;

            public MyShutdownHook(Process p) {
                this.proc = p;
            }

            @Override
            public void run() {
                try {
                    this.proc.exitValue();
                }
                catch (IllegalThreadStateException e) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.proc.destroy();
                }
            }
        }

        private static class MyProcessLogger
        extends Thread {
            private final BufferedReader err;

            public MyProcessLogger(Process p) {
                InputStreamReader reader = new InputStreamReader(p.getErrorStream());
                this.err = new BufferedReader(reader);
            }

            @Override
            public void run() {
                try {
                    try {
                        while (true) {
                            String msg;
                            if ((msg = this.err.readLine()) == null) {
                                continue;
                            }
                            vlog.info(msg);
                        }
                    }
                    catch (IOException e) {
                        vlog.info(e.getMessage());
                        try {
                            if (this.err != null) {
                                this.err.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (this.err != null) {
                            this.err.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    private static class MyJSchLogger
    implements Logger {
        private MyJSchLogger() {
        }

        @Override
        public boolean isEnabled(int level) {
            return true;
        }

        @Override
        public void log(int level, String msg) {
            switch (level) {
                case 1: {
                    vlog.info(msg);
                    break;
                }
                case 3: {
                    vlog.error(msg);
                    break;
                }
                default: {
                    vlog.debug(msg);
                }
            }
        }
    }
}

