/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark;

import com.snowflake.snowpark.Column;
import com.snowflake.snowpark.internal.ErrorMessage$;
import com.snowflake.snowpark.internal.analyzer.Ascending$;
import com.snowflake.snowpark.internal.analyzer.CurrentRow$;
import com.snowflake.snowpark.internal.analyzer.Expression;
import com.snowflake.snowpark.internal.analyzer.Literal$;
import com.snowflake.snowpark.internal.analyzer.RangeFrame$;
import com.snowflake.snowpark.internal.analyzer.RowFrame$;
import com.snowflake.snowpark.internal.analyzer.SortOrder;
import com.snowflake.snowpark.internal.analyzer.SortOrder$;
import com.snowflake.snowpark.internal.analyzer.SpecifiedWindowFrame;
import com.snowflake.snowpark.internal.analyzer.UnboundedFollowing$;
import com.snowflake.snowpark.internal.analyzer.UnboundedPreceding$;
import com.snowflake.snowpark.internal.analyzer.WindowExpression;
import com.snowflake.snowpark.internal.analyzer.WindowFrame;
import com.snowflake.snowpark.internal.analyzer.WindowSpecDefinition;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q3AAC\u0006\u0001%!A\u0011\u0004\u0001B\u0001B\u0003%!\u0004\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0011!\u0019\u0004A!A!\u0002\u0013!\u0004BB\u001c\u0001\t\u0003Y\u0001\bC\u0003?\u0001\u0011\u0005q\bC\u0003I\u0001\u0011\u0005\u0011\nC\u0003L\u0001\u0011\u0005A\nC\u0003U\u0001\u0011\u0005Q\u000b\u0003\u0004Y\u0001\u0011\u00051\"\u0017\u0002\u000b/&tGm\\<Ta\u0016\u001c'B\u0001\u0007\u000e\u0003!\u0019hn\\<qCJ\\'B\u0001\b\u0010\u0003%\u0019hn\\<gY\u0006\\WMC\u0001\u0011\u0003\r\u0019w.\\\u0002\u0001'\t\u00011\u0003\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0004B]f\u0014VMZ\u0001\u000ea\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2\u0011\u0007m\u0019cE\u0004\u0002\u001dC9\u0011Q\u0004I\u0007\u0002=)\u0011q$E\u0001\u0007yI|w\u000e\u001e \n\u0003YI!AI\u000b\u0002\u000fA\f7m[1hK&\u0011A%\n\u0002\u0004'\u0016\f(B\u0001\u0012\u0016!\t9C&D\u0001)\u0015\tI#&\u0001\u0005b]\u0006d\u0017P_3s\u0015\tY3\"\u0001\u0005j]R,'O\\1m\u0013\ti\u0003F\u0001\u0006FqB\u0014Xm]:j_:\f\u0011b\u001c:eKJ\u001c\u0006/Z2\u0011\u0007m\u0019\u0003\u0007\u0005\u0002(c%\u0011!\u0007\u000b\u0002\n'>\u0014Ho\u0014:eKJ\fQA\u001a:b[\u0016\u0004\"aJ\u001b\n\u0005YB#aC,j]\u0012|wO\u0012:b[\u0016\fa\u0001P5oSRtD\u0003B\u001d<yu\u0002\"A\u000f\u0001\u000e\u0003-AQ!\u0007\u0003A\u0002iAQA\f\u0003A\u0002=BQa\r\u0003A\u0002Q\n1\u0002]1si&$\u0018n\u001c8CsR\u0011\u0011\b\u0011\u0005\u0006\u0003\u0016\u0001\rAQ\u0001\u0005G>d7\u000fE\u0002\u0015\u0007\u0016K!\u0001R\u000b\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0002;\r&\u0011qi\u0003\u0002\u0007\u0007>dW/\u001c8\u0002\u000f=\u0014H-\u001a:CsR\u0011\u0011H\u0013\u0005\u0006\u0003\u001a\u0001\rAQ\u0001\fe><8OQ3uo\u0016,g\u000eF\u0002:\u001bJCQAT\u0004A\u0002=\u000bQa\u001d;beR\u0004\"\u0001\u0006)\n\u0005E+\"\u0001\u0002'p]\u001eDQaU\u0004A\u0002=\u000b1!\u001a8e\u00031\u0011\u0018M\\4f\u0005\u0016$x/Z3o)\rIdk\u0016\u0005\u0006\u001d\"\u0001\ra\u0014\u0005\u0006'\"\u0001\raT\u0001\u000eo&$\b.Q4he\u0016<\u0017\r^3\u0015\u0005\u0015S\u0006\"B.\n\u0001\u00041\u0013!C1hOJ,w-\u0019;f\u0001")
public class WindowSpec {
    private final Seq<Expression> partitionSpec;
    private final Seq<SortOrder> orderSpec;
    private final WindowFrame frame;

    public WindowSpec partitionBy(Seq<Column> cols) {
        return new WindowSpec((Seq<Expression>)((Seq)cols.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.expr(), Seq$.MODULE$.canBuildFrom())), this.orderSpec, this.frame);
    }

    public WindowSpec orderBy(Seq<Column> cols) {
        Seq sortOrder = (Seq)cols.map((Function1 & Serializable & scala.Serializable)col -> {
            SortOrder sortOrder;
            Expression expression = col.expr();
            if (expression instanceof SortOrder) {
                SortOrder sortOrder2;
                sortOrder = sortOrder2 = (SortOrder)expression;
            } else if (expression != null) {
                Expression expression2 = expression;
                sortOrder = SortOrder$.MODULE$.apply(expression2, Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
            } else {
                throw new MatchError((Object)expression);
            }
            return sortOrder;
        }, Seq$.MODULE$.canBuildFrom());
        return new WindowSpec(this.partitionSpec, (Seq<SortOrder>)sortOrder, this.frame);
    }

    public WindowSpec rowsBetween(long start, long end) {
        Expression expression;
        Expression expression2;
        long l = start;
        if (0L == l) {
            expression2 = CurrentRow$.MODULE$;
        } else if (Long.MIN_VALUE == l) {
            expression2 = UnboundedPreceding$.MODULE$;
        } else if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
            expression2 = Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)((int)l)));
        } else {
            throw ErrorMessage$.MODULE$.DF_WINDOW_BOUNDARY_START_INVALID(l);
        }
        CurrentRow$ boundaryStart = expression2;
        long l2 = end;
        if (0L == l2) {
            expression = CurrentRow$.MODULE$;
        } else if (Long.MAX_VALUE == l2) {
            expression = UnboundedFollowing$.MODULE$;
        } else if (Integer.MIN_VALUE <= l2 && l2 <= Integer.MAX_VALUE) {
            expression = Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)((int)l2)));
        } else {
            throw ErrorMessage$.MODULE$.DF_WINDOW_BOUNDARY_END_INVALID(l2);
        }
        CurrentRow$ boundaryEnd = expression;
        return new WindowSpec(this.partitionSpec, this.orderSpec, new SpecifiedWindowFrame(RowFrame$.MODULE$, boundaryStart, boundaryEnd));
    }

    public WindowSpec rangeBetween(long start, long end) {
        long l = start;
        Expression expression = 0L == l ? CurrentRow$.MODULE$ : (Long.MIN_VALUE == l ? UnboundedPreceding$.MODULE$ : Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)l)));
        CurrentRow$ boundaryStart = expression;
        long l2 = end;
        Expression expression2 = 0L == l2 ? CurrentRow$.MODULE$ : (Long.MAX_VALUE == l2 ? UnboundedFollowing$.MODULE$ : Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)l2)));
        CurrentRow$ boundaryEnd = expression2;
        return new WindowSpec(this.partitionSpec, this.orderSpec, new SpecifiedWindowFrame(RangeFrame$.MODULE$, boundaryStart, boundaryEnd));
    }

    public Column withAggregate(Expression aggregate) {
        WindowSpecDefinition spec = new WindowSpecDefinition(this.partitionSpec, this.orderSpec, this.frame);
        return new Column(new WindowExpression(aggregate, spec));
    }

    public WindowSpec(Seq<Expression> partitionSpec, Seq<SortOrder> orderSpec, WindowFrame frame) {
        this.partitionSpec = partitionSpec;
        this.orderSpec = orderSpec;
        this.frame = frame;
    }
}

