/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark.internal;

import com.snowflake.snowpark.internal.ErrorMessage$;
import com.snowflake.snowpark.internal.Logging;
import com.snowflake.snowpark.internal.ParameterUtils$ClosureCleanerMode$;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;

public final class ParameterUtils$
extends Logging {
    public static ParameterUtils$ MODULE$;
    private Set<String> snowparkSpecificParameters;
    private final String Url;
    private final String PrivateKey;
    private final String SnowparkLazyAnalysis;
    private final String GeographyOutputFormat;
    private final String SnowparkEnableClosureCleaner;
    private final String SnowparkRequestTimeoutInSeconds;
    private final String SnowparkMaxFileUploadRetryCount;
    private final String SnowparkMaxFileDownloadRetryCount;
    private final String DEFAULT_REQUEST_TIMEOUT_IN_SECONDS;
    private final int MAX_REQUEST_TIMEOUT_IN_SECONDS;
    private final int MIN_REQUEST_TIMEOUT_IN_SECONDS;
    private final String DEFAULT_MAX_FILE_UPLOAD_RETRY_COUNT;
    private final String DEFAULT_MAX_FILE_DOWNLOAD_RETRY_COUNT;

    static {
        new ParameterUtils$();
    }

    private Set<String> snowparkSpecificParameters() {
        return this.snowparkSpecificParameters;
    }

    private void snowparkSpecificParameters_$eq(Set<String> x$1) {
        this.snowparkSpecificParameters = x$1;
    }

    public String Url() {
        return this.Url;
    }

    public String PrivateKey() {
        return this.PrivateKey;
    }

    public String SnowparkLazyAnalysis() {
        return this.SnowparkLazyAnalysis;
    }

    public String GeographyOutputFormat() {
        return this.GeographyOutputFormat;
    }

    public String SnowparkEnableClosureCleaner() {
        return this.SnowparkEnableClosureCleaner;
    }

    public String SnowparkRequestTimeoutInSeconds() {
        return this.SnowparkRequestTimeoutInSeconds;
    }

    public String SnowparkMaxFileUploadRetryCount() {
        return this.SnowparkMaxFileUploadRetryCount;
    }

    public String SnowparkMaxFileDownloadRetryCount() {
        return this.SnowparkMaxFileDownloadRetryCount;
    }

    public String DEFAULT_REQUEST_TIMEOUT_IN_SECONDS() {
        return this.DEFAULT_REQUEST_TIMEOUT_IN_SECONDS;
    }

    public int MAX_REQUEST_TIMEOUT_IN_SECONDS() {
        return this.MAX_REQUEST_TIMEOUT_IN_SECONDS;
    }

    public int MIN_REQUEST_TIMEOUT_IN_SECONDS() {
        return this.MIN_REQUEST_TIMEOUT_IN_SECONDS;
    }

    public String DEFAULT_MAX_FILE_UPLOAD_RETRY_COUNT() {
        return this.DEFAULT_MAX_FILE_UPLOAD_RETRY_COUNT;
    }

    public String DEFAULT_MAX_FILE_DOWNLOAD_RETRY_COUNT() {
        return this.DEFAULT_MAX_FILE_DOWNLOAD_RETRY_COUNT;
    }

    /*
     * WARNING - void declaration
     */
    public Properties jdbcConfig(Map<String, String> options) {
        void var2_2;
        Properties config = new Properties();
        Set forwardNameSet = (Set)options.keySet().$minus$minus(this.snowparkSpecificParameters());
        String client_memory_limit = "client_memory_limit";
        config.put(client_memory_limit, "10240");
        options.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                if (forwardNameSet.contains((Object)key)) {
                    object = config.put(key, value);
                } else {
                    String string = key;
                    String string2 = MODULE$.PrivateKey();
                    object = !(string != null ? !string.equals(string2) : string2 != null) ? config.put(MODULE$.PrivateKey(), MODULE$.parsePrivateKey(value)) : BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Object object2 = object;
            return object2;
        });
        config.put("CLIENT_VALIDATE_DEFAULT_PARAMETERS", BoxesRunTime.boxToBoolean((boolean)true));
        config.put("CLIENT_SESSION_KEEP_ALIVE", BoxesRunTime.boxToBoolean((boolean)true));
        this.logInfo(new StringBuilder(32).append("set JDBC client memory limit to ").append(config.get(client_memory_limit).toString()).toString());
        return var2_2;
    }

    public boolean parseBoolean(String value) {
        String lowerCase = value.trim().toLowerCase();
        String string = lowerCase;
        boolean bl = "true".equals(string) ? true : ("on".equals(string) ? true : "yes".equals(string));
        boolean bl2 = bl;
        return bl2;
    }

    /*
     * WARNING - void declaration
     */
    public Enumeration.Value parseClosureCleanerParam(String value) {
        void var3_3;
        Enumeration.Value mode;
        String lowerCase = value.trim().toLowerCase();
        Enumeration.Value value2 = mode = ParameterUtils$ClosureCleanerMode$.MODULE$.withNameWithDefault(value);
        Enumeration.Value value3 = ParameterUtils$ClosureCleanerMode$.MODULE$.unsupported();
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            throw ErrorMessage$.MODULE$.MISC_INVALID_CLOSURE_CLEANER_PARAMETER(this.SnowparkEnableClosureCleaner());
        }
        return var3_3;
    }

    public PrivateKey parsePrivateKey(String key) {
        PrivateKey privateKey;
        try {
            byte[] decoded = Base64.decodeBase64((String)key);
            DerInputStream derReader = new DerInputStream(decoded);
            DerValue[] seq = derReader.getSequence(0);
            if (seq.length < 9) {
                throw new GeneralSecurityException("Could not parse a PKCS1 private key.");
            }
            BigInteger modulus = seq[1].getBigInteger();
            BigInteger publicExp = seq[2].getBigInteger();
            BigInteger privateExp = seq[3].getBigInteger();
            BigInteger prime1 = seq[4].getBigInteger();
            BigInteger prime2 = seq[5].getBigInteger();
            BigInteger exp1 = seq[6].getBigInteger();
            BigInteger exp2 = seq[7].getBigInteger();
            BigInteger crtCoef = seq[8].getBigInteger();
            RSAPrivateCrtKeySpec keySpec = new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, prime1, prime2, exp1, exp2, crtCoef);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            privateKey = keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw ErrorMessage$.MODULE$.MISC_INVALID_RSA_PRIVATE_KEY(e.getMessage());
        }
        return privateKey;
    }

    private String registerParameter(String name) {
        Predef$.MODULE$.require(!this.snowparkSpecificParameters().contains((Object)name), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("duplicated parameter: ").append(name).toString());
        this.snowparkSpecificParameters_$eq((Set<String>)((Set)this.snowparkSpecificParameters().$plus((Object)name)));
        return name;
    }

    private ParameterUtils$() {
        MODULE$ = this;
        this.snowparkSpecificParameters = Predef$.MODULE$.Set().empty();
        this.Url = this.registerParameter("url");
        this.PrivateKey = this.registerParameter("privatekey");
        this.SnowparkLazyAnalysis = "snowpark_lazy_analysis";
        this.GeographyOutputFormat = "geography_output_format";
        this.SnowparkEnableClosureCleaner = "snowpark_enable_closure_cleaner";
        this.SnowparkRequestTimeoutInSeconds = "snowpark_request_timeout_in_seconds";
        this.SnowparkMaxFileUploadRetryCount = this.registerParameter("snowpark_max_file_upload_retry_count");
        this.SnowparkMaxFileDownloadRetryCount = this.registerParameter("snowpark_max_file_download_retry_count");
        this.DEFAULT_REQUEST_TIMEOUT_IN_SECONDS = "86400";
        this.MAX_REQUEST_TIMEOUT_IN_SECONDS = 604800;
        this.MIN_REQUEST_TIMEOUT_IN_SECONDS = 0;
        this.DEFAULT_MAX_FILE_UPLOAD_RETRY_COUNT = "5";
        this.DEFAULT_MAX_FILE_DOWNLOAD_RETRY_COUNT = "5";
    }
}

