/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark.internal.analyzer;

import com.snowflake.snowpark.internal.Logging;
import com.snowflake.snowpark.internal.SnowflakeUDF;
import com.snowflake.snowpark.internal.analyzer.Analyzer$BinaryOperatorExtractor$;
import com.snowflake.snowpark.internal.analyzer.Analyzer$GroupingExtractor$;
import com.snowflake.snowpark.internal.analyzer.Analyzer$SpecialFrameBoundaryExtractor$;
import com.snowflake.snowpark.internal.analyzer.Analyzer$TableFunctionExpressionExtractor$;
import com.snowflake.snowpark.internal.analyzer.Analyzer$UnaryExpressionExtractor$;
import com.snowflake.snowpark.internal.analyzer.Attribute;
import com.snowflake.snowpark.internal.analyzer.BinaryExpression;
import com.snowflake.snowpark.internal.analyzer.CaseWhen;
import com.snowflake.snowpark.internal.analyzer.Collate;
import com.snowflake.snowpark.internal.analyzer.DataTypeMapper$;
import com.snowflake.snowpark.internal.analyzer.DeleteMergeExpression;
import com.snowflake.snowpark.internal.analyzer.ExprId;
import com.snowflake.snowpark.internal.analyzer.Expression;
import com.snowflake.snowpark.internal.analyzer.FrameType;
import com.snowflake.snowpark.internal.analyzer.FunctionExpression;
import com.snowflake.snowpark.internal.analyzer.GroupingSetsExpression;
import com.snowflake.snowpark.internal.analyzer.InExpression;
import com.snowflake.snowpark.internal.analyzer.InsertMergeExpression;
import com.snowflake.snowpark.internal.analyzer.Like;
import com.snowflake.snowpark.internal.analyzer.ListAgg;
import com.snowflake.snowpark.internal.analyzer.Literal;
import com.snowflake.snowpark.internal.analyzer.MultipleExpression;
import com.snowflake.snowpark.internal.analyzer.NamedExpression;
import com.snowflake.snowpark.internal.analyzer.NullOrdering;
import com.snowflake.snowpark.internal.analyzer.Query;
import com.snowflake.snowpark.internal.analyzer.RegExp;
import com.snowflake.snowpark.internal.analyzer.ScalarSubquery;
import com.snowflake.snowpark.internal.analyzer.SnowflakePlan;
import com.snowflake.snowpark.internal.analyzer.SortDirection;
import com.snowflake.snowpark.internal.analyzer.SortOrder;
import com.snowflake.snowpark.internal.analyzer.SpecialFrameBoundary;
import com.snowflake.snowpark.internal.analyzer.SpecifiedWindowFrame;
import com.snowflake.snowpark.internal.analyzer.Star;
import com.snowflake.snowpark.internal.analyzer.SubfieldInt;
import com.snowflake.snowpark.internal.analyzer.SubfieldString;
import com.snowflake.snowpark.internal.analyzer.TableFunctionExpression;
import com.snowflake.snowpark.internal.analyzer.UnaryExpression;
import com.snowflake.snowpark.internal.analyzer.UnresolvedAttribute;
import com.snowflake.snowpark.internal.analyzer.UnspecifiedFrame$;
import com.snowflake.snowpark.internal.analyzer.UpdateMergeExpression;
import com.snowflake.snowpark.internal.analyzer.WindowExpression;
import com.snowflake.snowpark.internal.analyzer.WindowFrame;
import com.snowflake.snowpark.internal.analyzer.WindowSpecDefinition;
import com.snowflake.snowpark.internal.analyzer.WithinGroup;
import com.snowflake.snowpark.internal.analyzer.package$;
import com.snowflake.snowpark.types.DataType;
import com.snowflake.snowpark.types.IntegralType;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.DynamicVariable;

public final class Analyzer$
extends Logging {
    public static Analyzer$ MODULE$;
    private final DynamicVariable<Map<ExprId, String>> generatedAliasMaps;
    private final DynamicVariable<scala.collection.immutable.Map<ExprId, String>> aliasMapsToUse;
    private final DynamicVariable<ArrayBuffer<SnowflakePlan>> subqueryPlans;

    static {
        new Analyzer$();
    }

    public DynamicVariable<Map<ExprId, String>> generatedAliasMaps() {
        return this.generatedAliasMaps;
    }

    public DynamicVariable<scala.collection.immutable.Map<ExprId, String>> aliasMapsToUse() {
        return this.aliasMapsToUse;
    }

    public DynamicVariable<ArrayBuffer<SnowflakePlan>> subqueryPlans() {
        return this.subqueryPlans;
    }

    public String analyze(Expression expr2) {
        TableFunctionExpression tableFunctionExpression;
        Option<String> option;
        String string;
        Expression expression = expr2;
        if (expression instanceof GroupingSetsExpression) {
            GroupingSetsExpression groupingSetsExpression = (GroupingSetsExpression)expression;
            Seq<Set<Expression>> args = groupingSetsExpression.args();
            string = package$.MODULE$.groupingSetExpression((Seq<Set<String>>)((Seq)args.map((Function1 & Serializable & scala.Serializable)x$1 -> (Set)x$1.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.analyze((Expression)expr), Set$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())));
        } else if (expression instanceof TableFunctionExpression && !(option = Analyzer$TableFunctionExpressionExtractor$.MODULE$.unapply(tableFunctionExpression = (TableFunctionExpression)expression)).isEmpty()) {
            String str;
            string = str = (String)option.get();
        } else if (expression instanceof SubfieldString) {
            SubfieldString subfieldString = (SubfieldString)expression;
            Expression expr3 = subfieldString.expr();
            String field = subfieldString.field();
            string = package$.MODULE$.subfieldExpression(this.analyze(expr3), field);
        } else if (expression instanceof SubfieldInt) {
            SubfieldInt subfieldInt = (SubfieldInt)expression;
            Expression expr4 = subfieldInt.expr();
            int field = subfieldInt.field();
            string = package$.MODULE$.subfieldExpression(this.analyze(expr4), field);
        } else if (expression instanceof Like) {
            Like like = (Like)expression;
            Expression expr5 = like.expr();
            Expression pattern = like.pattern();
            string = package$.MODULE$.likeExpression(this.analyze(expr5), this.analyze(pattern));
        } else if (expression instanceof RegExp) {
            RegExp regExp = (RegExp)expression;
            Expression expr6 = regExp.expr();
            Expression pattern = regExp.pattern();
            string = package$.MODULE$.regexpExpression(this.analyze(expr6), this.analyze(pattern));
        } else if (expression instanceof Collate) {
            Collate collate = (Collate)expression;
            Expression expr7 = collate.expr();
            String collationSpec = collate.collationSpec();
            string = package$.MODULE$.collateExpression(this.analyze(expr7), collationSpec);
        } else if (expression instanceof SnowflakeUDF) {
            SnowflakeUDF snowflakeUDF = (SnowflakeUDF)expression;
            String name = snowflakeUDF.udfName();
            Seq<Expression> children = snowflakeUDF.children();
            string = package$.MODULE$.functionExpression(name, (Seq<String>)((Seq)children.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.analyze((Expression)expr), Seq$.MODULE$.canBuildFrom())), false);
        } else if (expression instanceof CaseWhen) {
            String string2;
            CaseWhen caseWhen = (CaseWhen)expression;
            Seq<Tuple2<Expression, Expression>> branches = caseWhen.branches();
            Option<Expression> elseValue = caseWhen.elseValue();
            Seq seq = (Seq)branches.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Expression condition = (Expression)tuple2._1();
                Expression value = (Expression)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)MODULE$.analyze(condition), (Object)MODULE$.analyze(value));
                return tuple22;
            }, Seq$.MODULE$.canBuildFrom());
            Option<Expression> option2 = elseValue;
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Expression value = (Expression)some.value();
                string2 = this.analyze(value);
            } else {
                string2 = "NULL";
            }
            string = package$.MODULE$.caseWhenExpression((Seq<Tuple2<String, String>>)seq, string2);
        } else if (expression instanceof MultipleExpression) {
            MultipleExpression multipleExpression = (MultipleExpression)expression;
            Seq<Expression> expressions = multipleExpression.expressions();
            string = package$.MODULE$.blockExpression((Seq<String>)((Seq)expressions.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.analyze((Expression)expr), Seq$.MODULE$.canBuildFrom())));
        } else if (expression instanceof InExpression) {
            InExpression inExpression = (InExpression)expression;
            Expression column = inExpression.columns();
            Seq<Expression> values = inExpression.values();
            string = package$.MODULE$.inExpression(this.analyze(column), (Seq<String>)((Seq)values.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.analyze((Expression)expr), Seq$.MODULE$.canBuildFrom())));
        } else {
            ScalarSubquery scalarSubquery;
            SnowflakePlan plan;
            UnaryExpression unaryExpression;
            Option<String> option3;
            BinaryExpression binaryExpression;
            Option<String> option4;
            SpecialFrameBoundary specialFrameBoundary;
            Option<String> option5;
            Option<String> option6 = Analyzer$GroupingExtractor$.MODULE$.unapply(expression);
            if (!option6.isEmpty()) {
                String str;
                string = str = (String)option6.get();
            } else if (expression instanceof WindowExpression) {
                WindowExpression windowExpression = (WindowExpression)expression;
                Expression windowFunction = windowExpression.windowFunction();
                WindowSpecDefinition windowSpec = windowExpression.windowSpec();
                string = package$.MODULE$.windowExpression(this.analyze(windowFunction), this.analyze(windowSpec));
            } else if (expression instanceof WindowSpecDefinition) {
                WindowSpecDefinition windowSpecDefinition = (WindowSpecDefinition)expression;
                Seq<Expression> partitionSpec = windowSpecDefinition.partitionSpec();
                Seq<SortOrder> orderSpec = windowSpecDefinition.orderSpec();
                WindowFrame frameSpecification = windowSpecDefinition.frameSpecification();
                string = package$.MODULE$.windowSpecExpressions((Seq<String>)((Seq)partitionSpec.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.analyze((Expression)expr), Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)orderSpec.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.analyze((Expression)expr), Seq$.MODULE$.canBuildFrom())), this.analyze(frameSpecification));
            } else if (expression instanceof SpecifiedWindowFrame) {
                SpecifiedWindowFrame specifiedWindowFrame = (SpecifiedWindowFrame)expression;
                FrameType frameType = specifiedWindowFrame.frameType();
                Expression lower = specifiedWindowFrame.lower();
                Expression upper = specifiedWindowFrame.upper();
                string = package$.MODULE$.specifiedWindowFrameExpression(frameType.sql(), this.windowFrameBoundary(this.toSqlAvoidOffset(lower)), this.windowFrameBoundary(this.toSqlAvoidOffset(upper)));
            } else if (UnspecifiedFrame$.MODULE$.equals(expression)) {
                string = "";
            } else if (expression instanceof SpecialFrameBoundary && !(option5 = Analyzer$SpecialFrameBoundaryExtractor$.MODULE$.unapply(specialFrameBoundary = (SpecialFrameBoundary)expression)).isEmpty()) {
                String str;
                string = str = (String)option5.get();
            } else if (expression instanceof Literal) {
                Literal literal = (Literal)expression;
                Object value = literal.value();
                Option<DataType> dataType = literal.dataTypeOption();
                string = DataTypeMapper$.MODULE$.toSql(value, dataType);
            } else if (expression instanceof Attribute) {
                Attribute attribute = (Attribute)expression;
                string = package$.MODULE$.quoteName((String)((MapLike)this.aliasMapsToUse().value()).getOrElse((Object)attribute.exprId(), (Function0 & Serializable & scala.Serializable)() -> attribute.name()));
            } else if (expression instanceof UnresolvedAttribute) {
                String name;
                UnresolvedAttribute unresolvedAttribute = (UnresolvedAttribute)expression;
                string = name = unresolvedAttribute.name();
            } else if (expression instanceof FunctionExpression) {
                FunctionExpression functionExpression = (FunctionExpression)expression;
                String name = functionExpression.name();
                Seq<Expression> children = functionExpression.arguments();
                boolean isDistinct = functionExpression.isDistinct();
                string = package$.MODULE$.functionExpression(name, (Seq<String>)((Seq)children.map((Function1 & Serializable & scala.Serializable)exp -> MODULE$.toSqlAvoidOffset((Expression)exp), Seq$.MODULE$.canBuildFrom())), isDistinct);
            } else if (expression instanceof Star) {
                Star star = (Star)expression;
                Seq<NamedExpression> columns = star.expressions();
                string = columns.isEmpty() ? "*" : ((TraversableOnce)columns.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.analyze((Expression)expr), Seq$.MODULE$.canBuildFrom())).mkString(",");
            } else if (expression instanceof BinaryExpression && !(option4 = Analyzer$BinaryOperatorExtractor$.MODULE$.unapply(binaryExpression = (BinaryExpression)expression)).isEmpty()) {
                String str;
                string = str = (String)option4.get();
            } else if (expression instanceof SortOrder) {
                SortOrder sortOrder = (SortOrder)expression;
                Expression child = sortOrder.child();
                SortDirection direction = sortOrder.direction();
                NullOrdering nullOrdering = sortOrder.nullOrdering();
                string = package$.MODULE$.orderExpression(this.analyze(child), direction.sql(), nullOrdering.sql());
            } else if (expression instanceof UnaryExpression && !(option3 = Analyzer$UnaryExpressionExtractor$.MODULE$.unapply(unaryExpression = (UnaryExpression)expression)).isEmpty()) {
                String str;
                string = str = (String)option3.get();
            } else if (expression instanceof ScalarSubquery && (plan = (scalarSubquery = (ScalarSubquery)expression).plan()) != null) {
                SnowflakePlan snowflakePlan = plan;
                ((BufferLike)this.subqueryPlans().value()).append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SnowflakePlan[]{snowflakePlan}));
                string = package$.MODULE$.subqueryExpression(((Query)snowflakePlan.queries().last()).sql());
            } else if (expression instanceof WithinGroup) {
                WithinGroup withinGroup = (WithinGroup)expression;
                Expression expr8 = withinGroup.expr();
                Seq<Expression> orderByExprs = withinGroup.orderByCols();
                string = package$.MODULE$.withinGroupExpression(this.analyze(expr8), (Seq<String>)((Seq)orderByExprs.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.analyze((Expression)expr), Seq$.MODULE$.canBuildFrom())));
            } else if (expression instanceof InsertMergeExpression) {
                InsertMergeExpression insertMergeExpression = (InsertMergeExpression)expression;
                Option<Expression> condition = insertMergeExpression.condition();
                Seq<Expression> keys = insertMergeExpression.keys();
                Seq<Expression> values = insertMergeExpression.values();
                string = package$.MODULE$.insertMergeStatement((Option<String>)condition.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.analyze((Expression)expr)), (Seq<String>)((Seq)keys.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.analyze((Expression)expr), Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)values.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.analyze((Expression)expr), Seq$.MODULE$.canBuildFrom())));
            } else if (expression instanceof UpdateMergeExpression) {
                UpdateMergeExpression updateMergeExpression = (UpdateMergeExpression)expression;
                Option<Expression> condition = updateMergeExpression.condition();
                scala.collection.immutable.Map<Expression, Expression> assignments = updateMergeExpression.assignments();
                string = package$.MODULE$.updateMergeStatement((Option<String>)condition.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.analyze((Expression)expr)), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)assignments.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Expression k = (Expression)tuple2._1();
                    Expression v = (Expression)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)MODULE$.analyze(k), (Object)MODULE$.analyze(v));
                    return tuple22;
                }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())));
            } else if (expression instanceof DeleteMergeExpression) {
                DeleteMergeExpression deleteMergeExpression = (DeleteMergeExpression)expression;
                Option<Expression> condition = deleteMergeExpression.condition();
                string = package$.MODULE$.deleteMergeStatement((Option<String>)condition.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.analyze((Expression)expr)));
            } else if (expression instanceof ListAgg) {
                ListAgg listAgg = (ListAgg)expression;
                Expression expr9 = listAgg.col();
                String delimiter = listAgg.delimiter();
                boolean isDistinct = listAgg.isDistinct();
                string = package$.MODULE$.listAgg(this.analyze(expr9), DataTypeMapper$.MODULE$.stringToSql(delimiter), isDistinct);
            } else {
                throw new UnsupportedOperationException(new StringBuilder(35).append("Expression ").append(expr2.toString()).append(" of type ").append(expr2.dataType()).append(" not supported.").toString());
            }
        }
        return string;
    }

    public String windowFrameBoundary(String offset) {
        String string;
        try {
            int num = new StringOps(Predef$.MODULE$.augmentString(offset)).toInt();
            string = package$.MODULE$.windowFrameBoundaryExpression(((Object)BoxesRunTime.boxToInteger((int)RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(num)))).toString(), num >= 0);
        }
        catch (Throwable throwable) {
            string = offset;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toSqlAvoidOffset(Expression exp) {
        Expression expression = exp;
        if (!(expression instanceof Literal)) return this.analyze(exp);
        Literal literal = (Literal)expression;
        Object value = literal.value();
        Option<DataType> option = literal.dataTypeOption();
        if (!(option instanceof Some)) return this.analyze(exp);
        Some some = (Some)option;
        DataType dataType = (DataType)some.value();
        if (!(dataType instanceof IntegralType)) return this.analyze(exp);
        return DataTypeMapper$.MODULE$.toSqlWithoutCast(value, dataType);
    }

    private final int ARRAY_BIND_THRESHOLD() {
        return 512;
    }

    private Analyzer$() {
        MODULE$ = this;
        this.generatedAliasMaps = new DynamicVariable((Object)Map$.MODULE$.empty());
        this.aliasMapsToUse = new DynamicVariable((Object)Predef$.MODULE$.Map().empty());
        this.subqueryPlans = new DynamicVariable((Object)ArrayBuffer$.MODULE$.empty());
    }
}

