/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark.internal.analyzer;

import com.snowflake.snowpark.Row;
import com.snowflake.snowpark.SaveMode;
import com.snowflake.snowpark.Session;
import com.snowflake.snowpark.internal.ErrorMessage$;
import com.snowflake.snowpark.internal.Logging;
import com.snowflake.snowpark.internal.analyzer.Aggregate;
import com.snowflake.snowpark.internal.analyzer.Analyzer$;
import com.snowflake.snowpark.internal.analyzer.Attribute;
import com.snowflake.snowpark.internal.analyzer.CopyIntoNode;
import com.snowflake.snowpark.internal.analyzer.CreateViewCommand;
import com.snowflake.snowpark.internal.analyzer.Except;
import com.snowflake.snowpark.internal.analyzer.ExprId;
import com.snowflake.snowpark.internal.analyzer.Expression;
import com.snowflake.snowpark.internal.analyzer.Filter;
import com.snowflake.snowpark.internal.analyzer.Generator;
import com.snowflake.snowpark.internal.analyzer.Intersect;
import com.snowflake.snowpark.internal.analyzer.Join;
import com.snowflake.snowpark.internal.analyzer.JoinType;
import com.snowflake.snowpark.internal.analyzer.Lateral;
import com.snowflake.snowpark.internal.analyzer.Limit;
import com.snowflake.snowpark.internal.analyzer.LocalTempView$;
import com.snowflake.snowpark.internal.analyzer.LogicalPlan;
import com.snowflake.snowpark.internal.analyzer.MergeExpression;
import com.snowflake.snowpark.internal.analyzer.NamedExpression;
import com.snowflake.snowpark.internal.analyzer.PersistedView$;
import com.snowflake.snowpark.internal.analyzer.Pivot;
import com.snowflake.snowpark.internal.analyzer.Project;
import com.snowflake.snowpark.internal.analyzer.Range;
import com.snowflake.snowpark.internal.analyzer.SnowflakeCreateTable;
import com.snowflake.snowpark.internal.analyzer.SnowflakePlan;
import com.snowflake.snowpark.internal.analyzer.SnowflakeSampleNode;
import com.snowflake.snowpark.internal.analyzer.SnowflakeValues;
import com.snowflake.snowpark.internal.analyzer.Sort;
import com.snowflake.snowpark.internal.analyzer.SortOrder;
import com.snowflake.snowpark.internal.analyzer.StagedFileReader;
import com.snowflake.snowpark.internal.analyzer.TableDelete;
import com.snowflake.snowpark.internal.analyzer.TableFunctionExpression;
import com.snowflake.snowpark.internal.analyzer.TableFunctionJoin;
import com.snowflake.snowpark.internal.analyzer.TableFunctionRelation;
import com.snowflake.snowpark.internal.analyzer.TableMerge;
import com.snowflake.snowpark.internal.analyzer.TableUpdate;
import com.snowflake.snowpark.internal.analyzer.Union;
import com.snowflake.snowpark.internal.analyzer.UnresolvedRelation;
import com.snowflake.snowpark.internal.analyzer.ViewType;
import com.snowflake.snowpark.internal.analyzer.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.DynamicVariable;

@ScalaSignature(bytes="\u0006\u0001\u0005=v!\u0002\u0015*\u0011\u0013!d!\u0002\u001c*\u0011\u00139\u0004\"\u0002\u001f\u0002\t\u0003i\u0004b\u0002 \u0002\u0005\u0004%\ta\u0010\u0005\u0007=\u0006\u0001\u000b\u0011\u0002!\t\u000f}\u000b!\u0019!C\u0001A\"1A-\u0001Q\u0001\n\u0005Dq!Z\u0001C\u0002\u0013\u0005a\r\u0003\u0004o\u0003\u0001\u0006Ia\u001a\u0005\u0006_\u0006!\t\u0001]\u0004\u0006m\u0006A\ta\u001e\u0004\u0006s\u0006A\tA\u001f\u0005\u0006y-!\ta \u0005\b\u0003\u0003YA\u0011AA\u0002\u000f\u001d\t\u0019\"\u0001E\u0001\u0003+1q!a\u0006\u0002\u0011\u0003\tI\u0002\u0003\u0004=\u001f\u0011\u0005\u00111\u0004\u0005\b\u0003\u0003yA\u0011AA\u000f\u000f\u001d\t9#\u0001E\u0001\u0003S1q!a\u000b\u0002\u0011\u0003\ti\u0003\u0003\u0004='\u0011\u0005\u0011q\u0006\u0005\b\u0003\u0003\u0019B\u0011AA\u0019\u000f\u001d\tY$\u0001E\u0001\u0003{1q!a\u0010\u0002\u0011\u0003\t\t\u0005\u0003\u0004=/\u0011\u0005\u00111\t\u0005\b\u0003\u00039B\u0011AA#\u000f\u001d\ty%\u0001E\u0001\u0003#2q!a\u0015\u0002\u0011\u0003\t)\u0006\u0003\u0004=7\u0011\u0005\u0011q\u000b\u0005\b\u0003\u0003YB\u0011AA-\u0011\u001d\ti&\u0001C\u0001\u0003?Bq!!\u001a\u0002\t\u0003\t9\u0007C\u0005\u0002n\u0005\u0011\r\u0011\"\u0004\u0002p!A\u0011QO\u0001!\u0002\u001b\t\tH\u0002\u00047S\u0001i\u0013q\u0010\u0005\u000b\u0003\u0003\u0013#\u0011!Q\u0001\n\u0005\r\u0005B\u0002\u001f#\t\u0003\tY\tC\u0004\u0002\u0012\n\"\t!a%\t\u000f\u0005}%\u0005\"\u0003\u0002\"\"9\u0011q\u0014\u0012\u0005\n\u0005\u0015\u0016\u0001C!oC2L(0\u001a:\u000b\u0005)Z\u0013\u0001C1oC2L(0\u001a:\u000b\u00051j\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u00059z\u0013\u0001C:o_^\u0004\u0018M]6\u000b\u0005A\n\u0014!C:o_^4G.Y6f\u0015\u0005\u0011\u0014aA2p[\u000e\u0001\u0001CA\u001b\u0002\u001b\u0005I#\u0001C!oC2L(0\u001a:\u0014\u0005\u0005A\u0004CA\u001d;\u001b\u0005Y\u0013BA\u001e,\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#\u0001\u001b\u0002%\u001d,g.\u001a:bi\u0016$\u0017\t\\5bg6\u000b\u0007o]\u000b\u0002\u0001B\u0019\u0011I\u0012%\u000e\u0003\tS!a\u0011#\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u000b\u0006)1oY1mC&\u0011qI\u0011\u0002\u0010\tft\u0017-\\5d-\u0006\u0014\u0018.\u00192mKB!\u0011J\u0014)T\u001b\u0005Q%BA&M\u0003\u001diW\u000f^1cY\u0016T!!\u0014#\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002P\u0015\n\u0019Q*\u00199\u0011\u0005U\n\u0016B\u0001**\u0005\u0019)\u0005\u0010\u001d:JIB\u0011Ak\u0017\b\u0003+f\u0003\"A\u0016#\u000e\u0003]S!\u0001W\u001a\u0002\rq\u0012xn\u001c;?\u0013\tQF)\u0001\u0004Qe\u0016$WMZ\u0005\u00039v\u0013aa\u0015;sS:<'B\u0001.E\u0003M9WM\\3sCR,G-\u00117jCNl\u0015\r]:!\u00039\tG.[1t\u001b\u0006\u00048\u000fV8Vg\u0016,\u0012!\u0019\t\u0004\u0003\u001a\u0013\u0007\u0003\u0002+d!NK!aT/\u0002\u001f\u0005d\u0017.Y:NCB\u001cHk\\+tK\u0002\nQb];ccV,'/\u001f)mC:\u001cX#A4\u0011\u0007\u00053\u0005\u000eE\u0002JS.L!A\u001b&\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003k1L!!\\\u0015\u0003\u001bMswn\u001e4mC.,\u0007\u000b\\1o\u00039\u0019XOY9vKJL\b\u000b\\1og\u0002\nq!\u00198bYfTX\r\u0006\u0002Tc\")!/\u0003a\u0001g\u0006!Q\r\u001f9s!\t)D/\u0003\u0002vS\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002AQ\u000b'\r\\3Gk:\u001cG/[8o\u000bb\u0004(/Z:tS>tW\t\u001f;sC\u000e$xN\u001d\t\u0003q.i\u0011!\u0001\u0002!)\u0006\u0014G.\u001a$v]\u000e$\u0018n\u001c8FqB\u0014Xm]:j_:,\u0005\u0010\u001e:bGR|'o\u0005\u0002\fwB\u0011A0`\u0007\u0002\t&\u0011a\u0010\u0012\u0002\u0007\u0003:L(+\u001a4\u0015\u0003]\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u0006\u0005-\u0001\u0003\u0002?\u0002\bMK1!!\u0003E\u0005\u0019y\u0005\u000f^5p]\"1!/\u0004a\u0001\u0003\u001b\u00012!NA\b\u0013\r\t\t\"\u000b\u0002\u0018)\u0006\u0014G.\u001a$v]\u000e$\u0018n\u001c8FqB\u0014Xm]:j_:\f\u0001$\u00168bef,\u0005\u0010\u001d:fgNLwN\\#yiJ\f7\r^8s!\tAxB\u0001\rV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o\u000bb$(/Y2u_J\u001c\"aD>\u0015\u0005\u0005UA\u0003BA\u0003\u0003?AaA]\tA\u0002\u0005\u0005\u0002cA\u001b\u0002$%\u0019\u0011QE\u0015\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\fQd\u00159fG&\fGN\u0012:b[\u0016\u0014u.\u001e8eCJLX\t\u001f;sC\u000e$xN\u001d\t\u0003qN\u0011Qd\u00159fG&\fGN\u0012:b[\u0016\u0014u.\u001e8eCJLX\t\u001f;sC\u000e$xN]\n\u0003'm$\"!!\u000b\u0015\t\u0005\u0015\u00111\u0007\u0005\u0007eV\u0001\r!!\u000e\u0011\u0007U\n9$C\u0002\u0002:%\u0012Ac\u00159fG&\fGN\u0012:b[\u0016\u0014u.\u001e8eCJL\u0018a\u0006\"j]\u0006\u0014\u0018p\u00149fe\u0006$xN]#yiJ\f7\r^8s!\tAxCA\fCS:\f'/_(qKJ\fGo\u001c:FqR\u0014\u0018m\u0019;peN\u0011qc\u001f\u000b\u0003\u0003{!B!!\u0002\u0002H!1!/\u0007a\u0001\u0003\u0013\u00022!NA&\u0013\r\ti%\u000b\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\f\u0011c\u0012:pkBLgnZ#yiJ\f7\r^8s!\tA8DA\tHe>,\b/\u001b8h\u000bb$(/Y2u_J\u001c\"aG>\u0015\u0005\u0005EC\u0003BA\u0003\u00037BQA]\u000fA\u0002M\f1c^5oI><hI]1nK\n{WO\u001c3bef$2aUA1\u0011\u0019\t\u0019G\ba\u0001'\u00061qN\u001a4tKR\f\u0001\u0003^8Tc2\feo\\5e\u001f\u001a47/\u001a;\u0015\u0007M\u000bI\u0007\u0003\u0004\u0002l}\u0001\ra]\u0001\u0004Kb\u0004\u0018\u0001F!S%\u0006KvLQ%O\t~#\u0006JU#T\u0011>cE)\u0006\u0002\u0002r=\u0011\u00111O\u000f\u0003\u0005\u0001\tQ#\u0011*S\u0003f{&)\u0013(E?RC%+R*I\u001f2#\u0005\u0005K\u0002\"\u0003s\u00022\u0001`A>\u0013\r\ti\b\u0012\u0002\u0007S:d\u0017N\\3\u0014\u0005\tB\u0014aB:fgNLwN\u001c\t\u0005\u0003\u000b\u000b9)D\u0001.\u0013\r\tI)\f\u0002\b'\u0016\u001c8/[8o)\u0011\ti)a$\u0011\u0005U\u0012\u0003bBAAI\u0001\u0007\u00111Q\u0001\be\u0016\u001cx\u000e\u001c<f)\rY\u0017Q\u0013\u0005\b\u0003/+\u0003\u0019AAM\u0003\u0011\u0001H.\u00198\u0011\u0007U\nY*C\u0002\u0002\u001e&\u00121\u0002T8hS\u000e\fG\u000e\u00157b]\u0006IAm\u001c*fg>dg/\u001a\u000b\u0004W\u0006\r\u0006bBALM\u0001\u0007\u0011\u0011\u0014\u000b\u0006W\u0006\u001d\u0016\u0011\u0016\u0005\b\u0003/;\u0003\u0019AAM\u0011\u001d\tYk\na\u0001\u0003[\u000b\u0001C]3t_24X\rZ\"iS2$'/\u001a8\u0011\u000bQ\u001b\u0017\u0011T6")
public class Analyzer
extends Logging {
    private final Session session;

    public static String toSqlAvoidOffset(Expression expression) {
        return Analyzer$.MODULE$.toSqlAvoidOffset(expression);
    }

    public static String windowFrameBoundary(String string) {
        return Analyzer$.MODULE$.windowFrameBoundary(string);
    }

    public static String analyze(Expression expression) {
        return Analyzer$.MODULE$.analyze(expression);
    }

    public static DynamicVariable<ArrayBuffer<SnowflakePlan>> subqueryPlans() {
        return Analyzer$.MODULE$.subqueryPlans();
    }

    public static DynamicVariable<Map<ExprId, String>> aliasMapsToUse() {
        return Analyzer$.MODULE$.aliasMapsToUse();
    }

    public static DynamicVariable<scala.collection.mutable.Map<ExprId, String>> generatedAliasMaps() {
        return Analyzer$.MODULE$.generatedAliasMaps();
    }

    public SnowflakePlan resolve(LogicalPlan plan) {
        return (SnowflakePlan)Analyzer$.MODULE$.subqueryPlans().withValue((Object)ArrayBuffer$.MODULE$.empty(), (Function0 & Serializable & scala.Serializable)() -> (SnowflakePlan)Analyzer$.MODULE$.generatedAliasMaps().withValue((Object)Map$.MODULE$.empty(), (Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            SnowflakePlan result = (SnowflakePlan)$this.session.withAnalysisMode(true, (Function0 & Serializable & scala.Serializable)() -> this.doResolve(plan));
            result.addAliases((Map<ExprId, String>)((TraversableOnce)Analyzer$.MODULE$.generatedAliasMaps().value()).toMap(Predef$.MODULE$.$conforms()));
            if (((TraversableOnce)Analyzer$.MODULE$.subqueryPlans().value()).nonEmpty()) {
                result = result.withSubqueries((SnowflakePlan[])((TraversableOnce)Analyzer$.MODULE$.subqueryPlans().value()).toArray(ClassTag$.MODULE$.apply(SnowflakePlan.class)));
            }
            result.analyzeIfneeded();
            return var2_2;
        }));
    }

    private SnowflakePlan doResolve(LogicalPlan plan) {
        Map resolvedChildren = ((TraversableOnce)plan.children().map((Function1 & Serializable & scala.Serializable)c -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(c), (Object)this.resolve((LogicalPlan)c)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map useMaps = (Map)((TraversableOnce)resolvedChildren.values().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.exprToAlias(), Iterable$.MODULE$.canBuildFrom())).foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Map curr = (Map)tuple2._1();
            Map next = (Map)tuple2._2();
            Set common = (Set)curr.keySet().intersect((GenSet)next.keySet());
            Map map = (Map)curr.$plus$plus((GenTraversableOnce)next).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)Analyzer.$anonfun$doResolve$4(common, x0$2)));
            return map;
        });
        return (SnowflakePlan)Analyzer$.MODULE$.aliasMapsToUse().withValue((Object)useMaps, (Function0 & Serializable & scala.Serializable)() -> this.doResolve(plan, (Map<LogicalPlan, SnowflakePlan>)resolvedChildren));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SnowflakePlan doResolve(LogicalPlan plan, Map<LogicalPlan, SnowflakePlan> resolvedChildren) {
        boolean bl = false;
        SnowflakeValues snowflakeValues = null;
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof SnowflakePlan) {
            SnowflakePlan snowflakePlan = (SnowflakePlan)logicalPlan;
            return snowflakePlan;
        }
        if (logicalPlan instanceof TableFunctionJoin) {
            TableFunctionJoin tableFunctionJoin = (TableFunctionJoin)logicalPlan;
            LogicalPlan child = tableFunctionJoin.child();
            TableFunctionExpression tableFunction = tableFunctionJoin.tableFunction();
            return this.session.plans().joinTableFunction(Analyzer$.MODULE$.analyze(tableFunction), (SnowflakePlan)resolvedChildren.apply((Object)child), (Option<LogicalPlan>)new Some((Object)plan));
        }
        if (logicalPlan instanceof TableFunctionRelation) {
            TableFunctionRelation tableFunctionRelation = (TableFunctionRelation)logicalPlan;
            TableFunctionExpression tableFunction = tableFunctionRelation.TableFunction();
            return this.session.plans().fromTableFunction(Analyzer$.MODULE$.analyze(tableFunction));
        }
        if (logicalPlan instanceof Lateral) {
            Lateral lateral = (Lateral)logicalPlan;
            LogicalPlan child = lateral.child();
            TableFunctionExpression tableFunction = lateral.tableFunction();
            return this.session.plans().lateral(Analyzer$.MODULE$.analyze(tableFunction), (SnowflakePlan)resolvedChildren.apply((Object)child), (Option<LogicalPlan>)new Some((Object)plan));
        }
        if (logicalPlan instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)logicalPlan;
            Seq<Expression> groupingExpressions = aggregate.groupingExpressions();
            Seq<NamedExpression> aggregateExpressions = aggregate.aggregateExpressions();
            LogicalPlan child = aggregate.child();
            return this.session.plans().aggregate((Seq<String>)((Seq)groupingExpressions.map((Function1 & Serializable & scala.Serializable)exp -> Analyzer$.MODULE$.toSqlAvoidOffset((Expression)exp), Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)aggregateExpressions.map((Function1 & Serializable & scala.Serializable)expr -> Analyzer$.MODULE$.analyze((Expression)expr), Seq$.MODULE$.canBuildFrom())), (SnowflakePlan)resolvedChildren.apply((Object)child), (Option<LogicalPlan>)new Some((Object)plan));
        }
        if (logicalPlan instanceof Project) {
            Project project = (Project)logicalPlan;
            Seq<NamedExpression> projectList = project.projectList();
            LogicalPlan child = project.child();
            return this.session.plans().project((Seq<String>)((Seq)projectList.map((Function1 & Serializable & scala.Serializable)expr -> Analyzer$.MODULE$.analyze((Expression)expr), Seq$.MODULE$.canBuildFrom())), (SnowflakePlan)resolvedChildren.apply((Object)child), (Option<LogicalPlan>)new Some((Object)plan), this.session.plans().project$default$4());
        }
        if (logicalPlan instanceof Filter) {
            Filter filter = (Filter)logicalPlan;
            Expression condition = filter.condition();
            LogicalPlan child = filter.child();
            return this.session.plans().filter(Analyzer$.MODULE$.analyze(condition), (SnowflakePlan)resolvedChildren.apply((Object)child), (Option<LogicalPlan>)new Some((Object)plan));
        }
        if (logicalPlan instanceof SnowflakeSampleNode) {
            SnowflakeSampleNode snowflakeSampleNode = (SnowflakeSampleNode)logicalPlan;
            Option<Object> probabilityFraction = snowflakeSampleNode.probabilityFraction();
            Option<Object> rowCount = snowflakeSampleNode.rowCount();
            LogicalPlan child = snowflakeSampleNode.child();
            return this.session.plans().sample(probabilityFraction, rowCount, (SnowflakePlan)resolvedChildren.apply((Object)child), (Option<LogicalPlan>)new Some((Object)plan));
        }
        if (logicalPlan instanceof Sort) {
            Sort sort = (Sort)logicalPlan;
            Seq<SortOrder> order = sort.order();
            LogicalPlan child = sort.child();
            return this.session.plans().sort((Seq<String>)((Seq)order.map((Function1 & Serializable & scala.Serializable)expr -> Analyzer$.MODULE$.analyze((Expression)expr), Seq$.MODULE$.canBuildFrom())), (SnowflakePlan)resolvedChildren.apply((Object)child), (Option<LogicalPlan>)new Some((Object)plan));
        }
        if (logicalPlan instanceof Intersect) {
            Intersect intersect = (Intersect)logicalPlan;
            LogicalPlan left = intersect.left();
            LogicalPlan right = intersect.right();
            return this.session.plans().setOperator((SnowflakePlan)resolvedChildren.apply((Object)left), (SnowflakePlan)resolvedChildren.apply((Object)right), intersect.sql(), (Option<LogicalPlan>)new Some((Object)plan));
        }
        if (logicalPlan instanceof Except) {
            Except except = (Except)logicalPlan;
            LogicalPlan left = except.left();
            LogicalPlan right = except.right();
            return this.session.plans().setOperator((SnowflakePlan)resolvedChildren.apply((Object)left), (SnowflakePlan)resolvedChildren.apply((Object)right), except.sql(), (Option<LogicalPlan>)new Some((Object)plan));
        }
        if (logicalPlan instanceof Union) {
            Union union = (Union)logicalPlan;
            LogicalPlan left = union.left();
            LogicalPlan right = union.right();
            return this.session.plans().setOperator((SnowflakePlan)resolvedChildren.apply((Object)left), (SnowflakePlan)resolvedChildren.apply((Object)right), union.sql(), (Option<LogicalPlan>)new Some((Object)plan));
        }
        if (logicalPlan instanceof Join) {
            Join join = (Join)logicalPlan;
            LogicalPlan left = join.left();
            LogicalPlan right = join.right();
            JoinType joinType = join.joinType();
            Option<Expression> condition = join.condition();
            return this.session.plans().join((SnowflakePlan)resolvedChildren.apply((Object)left), (SnowflakePlan)resolvedChildren.apply((Object)right), joinType, (Option<String>)condition.map((Function1 & Serializable & scala.Serializable)expr -> Analyzer$.MODULE$.analyze((Expression)expr)), (Option<LogicalPlan>)new Some((Object)plan));
        }
        if (logicalPlan instanceof Range) {
            Range range = (Range)logicalPlan;
            long start = range.start();
            long end = range.end();
            long step = range.step();
            return this.session.plans().query(package$.MODULE$.rangeStatement(start, end, step, "id"), (Option<LogicalPlan>)new Some((Object)plan), this.session.plans().query$default$3());
        }
        if (logicalPlan instanceof Generator) {
            Generator generator = (Generator)logicalPlan;
            Seq<Expression> exprs = generator.exprs();
            long rowCount = generator.rowCount();
            return this.session.plans().query(package$.MODULE$.generator((Seq<String>)((Seq)exprs.map((Function1 & Serializable & scala.Serializable)expr -> Analyzer$.MODULE$.analyze((Expression)expr), Seq$.MODULE$.canBuildFrom())), rowCount), (Option<LogicalPlan>)new Some((Object)plan), this.session.plans().query$default$3());
        }
        if (logicalPlan instanceof SnowflakeValues) {
            bl = true;
            snowflakeValues = (SnowflakeValues)logicalPlan;
            Seq<Attribute> output = snowflakeValues.output();
            Seq<Row> data = snowflakeValues.data();
            if (data.isEmpty()) {
                return this.session.plans().query(package$.MODULE$.emptyValuesStatement(output), (Option<LogicalPlan>)new Some((Object)plan), this.session.plans().query$default$3());
            }
        }
        if (bl) {
            Seq<Attribute> output = snowflakeValues.output();
            Seq<Row> data = snowflakeValues.data();
            return output.size() * data.size() < 512 ? this.session.plans().query(package$.MODULE$.valuesStatement(output, data), (Option<LogicalPlan>)new Some((Object)plan), this.session.plans().query$default$3()) : this.session.plans().largeLocalRelationPlan(output, data, (Option<LogicalPlan>)new Some((Object)plan));
        }
        if (logicalPlan instanceof UnresolvedRelation) {
            UnresolvedRelation unresolvedRelation = (UnresolvedRelation)logicalPlan;
            String tableName = unresolvedRelation.name();
            return this.session.plans().table(tableName);
        }
        if (logicalPlan instanceof SnowflakeCreateTable) {
            SnowflakeCreateTable snowflakeCreateTable = (SnowflakeCreateTable)logicalPlan;
            String tableName = snowflakeCreateTable.tableName();
            SaveMode mode = snowflakeCreateTable.mode();
            Option<LogicalPlan> option = snowflakeCreateTable.query();
            if (option instanceof Some) {
                Some some = (Some)option;
                LogicalPlan child = (LogicalPlan)some.value();
                return this.session.plans().saveAsTable(tableName, mode, (SnowflakePlan)resolvedChildren.apply((Object)child));
            }
        }
        if (logicalPlan instanceof Limit) {
            SnowflakePlan snowflakePlan;
            Limit limit = (Limit)logicalPlan;
            Expression offset = limit.limitExpr();
            LogicalPlan child = limit.child();
            LogicalPlan logicalPlan2 = child;
            boolean bl2 = logicalPlan2 instanceof Sort ? true : (logicalPlan2 instanceof SnowflakePlan && (snowflakePlan = (SnowflakePlan)logicalPlan2).sourcePlan().isDefined() ? snowflakePlan.sourcePlan().get() instanceof Sort : false);
            boolean onTopOfOrderBy = bl2;
            return this.session.plans().limit(Analyzer$.MODULE$.toSqlAvoidOffset(offset), (SnowflakePlan)resolvedChildren.apply((Object)child), onTopOfOrderBy, (Option<LogicalPlan>)new Some((Object)plan));
        }
        if (logicalPlan instanceof TableUpdate) {
            TableUpdate tableUpdate = (TableUpdate)logicalPlan;
            String tableName = tableUpdate.tableName();
            Map<Expression, Expression> assignments = tableUpdate.assignments();
            Option<Expression> condition = tableUpdate.condition();
            Option<LogicalPlan> sourceData = tableUpdate.sourceData();
            return this.session.plans().update(tableName, (Map<String, String>)((Map)assignments.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Expression k = (Expression)tuple2._1();
                Expression v = (Expression)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)Analyzer$.MODULE$.analyze(k), (Object)Analyzer$.MODULE$.analyze(v));
                return tuple22;
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())), (Option<String>)condition.map((Function1 & Serializable & scala.Serializable)expr -> Analyzer$.MODULE$.analyze((Expression)expr)), (Option<SnowflakePlan>)sourceData.map(resolvedChildren));
        }
        if (logicalPlan instanceof TableDelete) {
            TableDelete tableDelete = (TableDelete)logicalPlan;
            String tableName = tableDelete.tableName();
            Option<Expression> condition = tableDelete.condition();
            Option<LogicalPlan> sourceData = tableDelete.sourceData();
            return this.session.plans().delete(tableName, (Option<String>)condition.map((Function1 & Serializable & scala.Serializable)expr -> Analyzer$.MODULE$.analyze((Expression)expr)), (Option<SnowflakePlan>)sourceData.map(resolvedChildren));
        }
        if (logicalPlan instanceof TableMerge) {
            TableMerge tableMerge = (TableMerge)logicalPlan;
            String tableName = tableMerge.tableName();
            LogicalPlan source = tableMerge.source();
            Expression joinExpr = tableMerge.joinExpr();
            Seq<MergeExpression> clauses = tableMerge.clauses();
            return this.session.plans().merge(tableName, (SnowflakePlan)resolvedChildren.apply((Object)source), Analyzer$.MODULE$.analyze(joinExpr), (Seq<String>)((Seq)clauses.map((Function1 & Serializable & scala.Serializable)expr -> Analyzer$.MODULE$.analyze((Expression)expr), Seq$.MODULE$.canBuildFrom())));
        }
        if (logicalPlan instanceof Pivot) {
            Pivot pivot = (Pivot)logicalPlan;
            Expression pivotColumn = pivot.pivotColumn();
            Seq<Expression> pivotValues = pivot.pivotValues();
            Seq<Expression> aggregates = pivot.aggregates();
            LogicalPlan child = pivot.child();
            Predef$.MODULE$.require(aggregates.size() == 1, (Function0 & Serializable & scala.Serializable)() -> "Only one aggregate is supported with pivot");
            return this.session.plans().pivot(Analyzer$.MODULE$.analyze(pivotColumn), (Seq<String>)((Seq)pivotValues.map((Function1 & Serializable & scala.Serializable)expr -> Analyzer$.MODULE$.analyze((Expression)expr), Seq$.MODULE$.canBuildFrom())), Analyzer$.MODULE$.analyze((Expression)aggregates.head()), this.resolve(child), (Option<LogicalPlan>)new Some((Object)plan));
        }
        if (logicalPlan instanceof CreateViewCommand) {
            boolean bl3;
            CreateViewCommand createViewCommand = (CreateViewCommand)logicalPlan;
            String name = createViewCommand.name();
            LogicalPlan child = createViewCommand.child();
            ViewType viewType = createViewCommand.viewType();
            ViewType viewType2 = viewType;
            if (PersistedView$.MODULE$.equals(viewType2)) {
                bl3 = false;
            } else {
                if (!LocalTempView$.MODULE$.equals(viewType2)) throw ErrorMessage$.MODULE$.PLAN_ANALYZER_UNSUPPORTED_VIEW_TYPE(viewType.toString());
                bl3 = true;
            }
            boolean isTemp = bl3;
            return this.session.plans().createOrReplaceView(name, this.resolve(child), isTemp);
        }
        if (!(logicalPlan instanceof CopyIntoNode)) throw new MatchError((Object)logicalPlan);
        CopyIntoNode copyIntoNode = (CopyIntoNode)logicalPlan;
        String name = copyIntoNode.tableName();
        Seq<String> columnNames = copyIntoNode.columnNames();
        Seq<Expression> transformations = copyIntoNode.transformations();
        Map<String, Object> options = copyIntoNode.options();
        StagedFileReader stagedFileReader = copyIntoNode.stagedFileReader();
        return stagedFileReader.table(name).columnNames(columnNames).transformations(transformations).options(options).createSnowflakePlan();
    }

    public static final /* synthetic */ boolean $anonfun$doResolve$4(Set common$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ExprId id = (ExprId)tuple2._1();
        boolean bl = !common$1.contains((Object)id);
        return bl;
    }

    public Analyzer(Session session) {
        this.session = session;
    }
}

