/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark_java;

import com.snowflake.snowpark.internal.JavaDataTypeUtils;
import com.snowflake.snowpark.internal.JavaUtils;
import com.snowflake.snowpark_java.DataFrame;
import com.snowflake.snowpark_java.WindowSpec;
import com.snowflake.snowpark_java.types.DataType;
import java.util.Optional;
import scala.Option;

public class Column {
    private final com.snowflake.snowpark.Column scalaColumn;

    Column(com.snowflake.snowpark.Column scalaColumn) {
        this.scalaColumn = scalaColumn;
    }

    public Column subField(String field) {
        return new Column(this.scalaColumn.apply(field));
    }

    public Column subField(int index) {
        return new Column(this.scalaColumn.apply(index));
    }

    public Optional<String> getName() {
        Option<String> name = this.scalaColumn.getName();
        if (name.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(name.get());
    }

    public Column as(String alias) {
        return new Column(this.scalaColumn.as(alias));
    }

    public Column alias(String alias) {
        return new Column(this.scalaColumn.alias(alias));
    }

    public Column unary_minus() {
        return new Column(this.scalaColumn.unary_$minus());
    }

    public Column unary_not() {
        return new Column(this.scalaColumn.unary_$bang());
    }

    public Column equal_to(Column other) {
        return new Column(this.scalaColumn.equal_to(other.scalaColumn));
    }

    public Column not_equal(Column other) {
        return new Column(this.scalaColumn.not_equal(other.scalaColumn));
    }

    public Column gt(Column other) {
        return new Column(this.scalaColumn.gt(other.scalaColumn));
    }

    public Column lt(Column other) {
        return new Column(this.scalaColumn.lt(other.scalaColumn));
    }

    public Column leq(Column other) {
        return new Column(this.scalaColumn.leq(other.scalaColumn));
    }

    public Column geq(Column other) {
        return new Column(this.scalaColumn.geq(other.scalaColumn));
    }

    public Column equal_null(Column other) {
        return new Column(this.scalaColumn.equal_null(other.scalaColumn));
    }

    public Column equal_nan() {
        return new Column(this.scalaColumn.equal_nan());
    }

    public Column is_null() {
        return new Column(this.scalaColumn.is_null());
    }

    public Column is_not_null() {
        return new Column(this.scalaColumn.is_not_null());
    }

    public Column or(Column other) {
        return new Column(this.scalaColumn.or(other.scalaColumn));
    }

    public Column and(Column other) {
        return new Column(this.scalaColumn.and(other.scalaColumn));
    }

    public Column between(Column lowerBound, Column upperBound) {
        return new Column(this.scalaColumn.between(lowerBound.scalaColumn, upperBound.scalaColumn));
    }

    public Column plus(Column other) {
        return new Column(this.scalaColumn.plus(other.scalaColumn));
    }

    public Column minus(Column other) {
        return new Column(this.scalaColumn.minus(other.scalaColumn));
    }

    public Column multiply(Column other) {
        return new Column(this.scalaColumn.multiply(other.scalaColumn));
    }

    public Column divide(Column other) {
        return new Column(this.scalaColumn.divide(other.scalaColumn));
    }

    public Column mod(Column other) {
        return new Column(this.scalaColumn.mod(other.scalaColumn));
    }

    public Column cast(DataType to) {
        return new Column(this.scalaColumn.cast(JavaDataTypeUtils.javaTypeToScalaType(to)));
    }

    public Column desc() {
        return new Column(this.scalaColumn.desc());
    }

    public Column desc_nulls_first() {
        return new Column(this.scalaColumn.desc_nulls_first());
    }

    public Column desc_nulls_last() {
        return new Column(this.scalaColumn.desc_nulls_last());
    }

    public Column asc() {
        return new Column(this.scalaColumn.asc());
    }

    public Column asc_nulls_first() {
        return new Column(this.scalaColumn.asc_nulls_first());
    }

    public Column asc_nulls_last() {
        return new Column(this.scalaColumn.asc_nulls_last());
    }

    public Column bitor(Column other) {
        return new Column(this.scalaColumn.bitor(other.scalaColumn));
    }

    public Column bitand(Column other) {
        return new Column(this.scalaColumn.bitand(other.scalaColumn));
    }

    public Column bitxor(Column other) {
        return new Column(this.scalaColumn.bitxor(other.scalaColumn));
    }

    public Column like(Column pattern) {
        return new Column(this.scalaColumn.like(pattern.scalaColumn));
    }

    public Column regexp(Column pattern) {
        return new Column(this.scalaColumn.regexp(pattern.scalaColumn));
    }

    public Column collate(String collateSpec) {
        return new Column(this.scalaColumn.collate(collateSpec));
    }

    public Column over() {
        return new Column(this.scalaColumn.over());
    }

    public Column over(WindowSpec windowSpec) {
        return new Column(this.scalaColumn.over(windowSpec.toScalaWindowSpec()));
    }

    public Column withinGroup(Column ... cols) {
        return new Column(this.scalaColumn.withinGroup(JavaUtils.columnArrayToSeq(Column.toScalaColumnArray(cols))));
    }

    public Column in(Object ... values) {
        return new Column(this.scalaColumn.in(JavaUtils.objectArrayToSeq(values)));
    }

    public Column in(DataFrame df) {
        return new Column(this.scalaColumn.in(df.getScalaDataFrame()));
    }

    public String toString() {
        return this.scalaColumn.toString();
    }

    com.snowflake.snowpark.Column toScalaColumn() {
        return this.scalaColumn;
    }

    static com.snowflake.snowpark.Column[] toScalaColumnArray(Column[] arr) {
        com.snowflake.snowpark.Column[] result = new com.snowflake.snowpark.Column[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            result[i] = arr[i].scalaColumn;
        }
        return result;
    }
}

