/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark_java;

import com.snowflake.snowpark.Session;
import com.snowflake.snowpark.internal.JavaUtils;
import com.snowflake.snowpark_java.DataFrameWriterAsyncActor;
import com.snowflake.snowpark_java.SaveMode;

public class DataFrameWriter {
    private final com.snowflake.snowpark.DataFrameWriter writer;
    private final Session session;

    DataFrameWriter(com.snowflake.snowpark.DataFrameWriter writer, Session session) {
        this.writer = writer;
        this.session = session;
    }

    public DataFrameWriter option(String key, Object value) {
        this.writer.option(key, value);
        return this;
    }

    public void saveAsTable(String tableName) {
        this.writer.saveAsTable(tableName);
    }

    public void saveAsTable(String[] multipartIdentifier) {
        this.writer.saveAsTable(JavaUtils.stringArrayToStringSeq(multipartIdentifier));
    }

    public DataFrameWriter mode(String saveMode) {
        this.writer.mode(saveMode);
        return this;
    }

    public DataFrameWriter mode(SaveMode saveMode) {
        this.writer.mode(JavaUtils.javaSaveModeToScala(saveMode));
        return this;
    }

    public DataFrameWriterAsyncActor async() {
        return new DataFrameWriterAsyncActor(this.writer.async(), this.session);
    }
}

