/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark_java;

import com.snowflake.snowpark.internal.JavaUtils;
import com.snowflake.snowpark_java.Column;
import com.snowflake.snowpark_java.DataFrame;
import com.snowflake.snowpark_java.DataFrameAsyncActor;
import com.snowflake.snowpark_java.DeleteResult;
import com.snowflake.snowpark_java.TypedAsyncJob;
import com.snowflake.snowpark_java.Updatable;
import com.snowflake.snowpark_java.UpdateResult;
import java.util.Map;

public class UpdatableAsyncActor
extends DataFrameAsyncActor {
    private final com.snowflake.snowpark.UpdatableAsyncActor uDfAsync;

    UpdatableAsyncActor(Updatable updatable) {
        super(updatable);
        this.uDfAsync = updatable.getScalaUpdatable().async();
    }

    public TypedAsyncJob<UpdateResult> update(Map<Column, Column> assignments) {
        return TypedAsyncJob.createUpdateResultJob(JavaUtils.async_updatable_update(Updatable.toScalaColumnMap(assignments), this.uDfAsync), this.session);
    }

    public TypedAsyncJob<UpdateResult> updateColumn(Map<String, Column> assignments) {
        return TypedAsyncJob.createUpdateResultJob(JavaUtils.async_updatable_updateColumn(Updatable.toScalaStringColumnMap(assignments), this.uDfAsync), this.session);
    }

    public TypedAsyncJob<UpdateResult> update(Map<Column, Column> assignments, Column condition) {
        return TypedAsyncJob.createUpdateResultJob(JavaUtils.async_updatable_update(Updatable.toScalaColumnMap(assignments), condition.toScalaColumn(), this.uDfAsync), this.session);
    }

    public TypedAsyncJob<UpdateResult> updateColumn(Map<String, Column> assignments, Column condition) {
        return TypedAsyncJob.createUpdateResultJob(JavaUtils.async_updatable_updateColumn(Updatable.toScalaStringColumnMap(assignments), condition.toScalaColumn(), this.uDfAsync), this.session);
    }

    public TypedAsyncJob<UpdateResult> update(Map<Column, Column> assignments, Column condition, DataFrame sourceData) {
        return TypedAsyncJob.createUpdateResultJob(JavaUtils.async_updatable_update(Updatable.toScalaColumnMap(assignments), condition.toScalaColumn(), sourceData.getScalaDataFrame(), this.uDfAsync), this.session);
    }

    public TypedAsyncJob<UpdateResult> updateColumn(Map<String, Column> assignments, Column condition, DataFrame sourceData) {
        return TypedAsyncJob.createUpdateResultJob(JavaUtils.async_updatable_updateColumn(Updatable.toScalaStringColumnMap(assignments), condition.toScalaColumn(), sourceData.getScalaDataFrame(), this.uDfAsync), this.session);
    }

    public TypedAsyncJob<DeleteResult> delete() {
        return TypedAsyncJob.createDeleteResultJob(this.uDfAsync.delete(), this.session);
    }

    public TypedAsyncJob<DeleteResult> delete(Column condition) {
        return TypedAsyncJob.createDeleteResultJob(this.uDfAsync.delete(condition.toScalaColumn()), this.session);
    }

    public TypedAsyncJob<DeleteResult> delete(Column condition, DataFrame sourceData) {
        return TypedAsyncJob.createDeleteResultJob(this.uDfAsync.delete(condition.toScalaColumn(), sourceData.getScalaDataFrame()), this.session);
    }
}

